/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.ints.Int2BooleanAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.function.Consumer;

public class PositionToBasesMap<T> {
    private Int2ObjectAVLTreeMap<T> delegate = new Int2ObjectAVLTreeMap();
    private IntSortedSet sortedKeys = new IntAVLTreeSet();
    private Int2BooleanAVLTreeMap ignoredPositions = new Int2BooleanAVLTreeMap();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        IntAVLTreeSet sorted = new IntAVLTreeSet();
        sorted.addAll((IntCollection)this.delegate.keySet());
        builder.append(String.format("key span: [%d-%d]%n", sorted.firstInt(), sorted.lastInt()));
        for (Object value : this.delegate.values()) {
            builder.append(value.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public IntSet keySet() {
        return this.sortedKeys;
    }

    public boolean containsKey(int position) {
        return this.sortedKeys.contains(position);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public void clear() {
        this.sortedKeys.clear();
        this.delegate.clear();
        this.ignoredPositions.clear();
    }

    public T remove(int k) {
        this.sortedKeys.remove(k);
        this.ignoredPositions.remove(k);
        return (T)this.delegate.remove(k);
    }

    public T get(int ok) {
        return (T)this.delegate.get(ok);
    }

    public void put(int keyPos, T positionBaseInfos) {
        this.sortedKeys.add(keyPos);
        this.delegate.put(keyPos, positionBaseInfos);
    }

    public ObjectSet<Map.Entry<Integer, T>> entrySet() {
        return this.delegate.entrySet();
    }

    public int firstPosition() {
        return this.sortedKeys.firstInt();
    }

    public void markIgnoredPosition(int position) {
        this.ignoredPositions.put(position, true);
    }

    public boolean isIgnoredPosition(int position) {
        return this.ignoredPositions.get(position);
    }

    public void removeFirst() {
        if (this.sortedKeys.isEmpty()) {
            return;
        }
        int keyToRemove = this.sortedKeys.firstInt();
        this.sortedKeys.remove(keyToRemove);
        this.delegate.remove(keyToRemove);
        this.ignoredPositions.remove(keyToRemove);
    }

    public void removeUpTo(int intermediatePosition) {
        int next;
        IntBidirectionalIterator iterator = this.sortedKeys.iterator();
        while (iterator.hasNext() && (next = ((Integer)iterator.next()).intValue()) <= intermediatePosition) {
            this.remove(next);
        }
    }

    public int width() {
        if (this.sortedKeys.isEmpty()) {
            return 0;
        }
        return this.sortedKeys.lastInt() - this.sortedKeys.firstInt();
    }

    public void trimWidth(int startFlapLength, Consumer<Integer> processFunction) {
        if (this.isEmpty()) {
            return;
        }
        int firstPosition = this.firstPosition();
        while (this.width() > startFlapLength * 2) {
            firstPosition = this.firstPosition();
            processFunction.accept(firstPosition);
            this.remove(firstPosition);
        }
    }
}

