/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import org.campagnelab.goby.alignments.Alignments;

public class PositionBaseInfo {
    public int readIndex;
    public int readerIndex;
    public byte qualityScore = (byte)-128;
    public byte readMappingQuality = (byte)-128;
    public boolean matchesReference;
    public char from = (char)32;
    public char to = (char)32;
    public int position;
    public boolean matchesForwardStrand;
    public int numVariationsInRead;
    public int insertSize;
    public Alignments.AlignmentEntry alignmentEntry;

    public PositionBaseInfo() {
    }

    public PositionBaseInfo(PositionBaseInfo other) {
        this.readIndex = other.readIndex;
        this.readerIndex = other.readerIndex;
        this.qualityScore = other.qualityScore;
        this.readMappingQuality = other.readMappingQuality;
        this.matchesReference = other.matchesReference;
        this.from = other.from;
        this.to = other.to;
        this.position = other.position;
        this.matchesForwardStrand = other.matchesForwardStrand;
        this.numVariationsInRead = other.numVariationsInRead;
        this.insertSize = other.insertSize;
        this.alignmentEntry = other.alignmentEntry;
    }

    public String toString() {
        char strand = this.matchesForwardStrand ? (char)'+' : '-';
        return this.matchesReference ? String.format("%c ref: %c s=%d", Character.valueOf(strand), Character.valueOf(this.from), this.readerIndex) : String.format("%c %c/%c q=%d s=%d", Character.valueOf(strand), Character.valueOf(this.from), Character.valueOf(this.to), this.qualityScore, this.readerIndex);
    }

    public boolean isInsertionOrDeletion() {
        return this.from == '-' || this.to == '-';
    }
}

