/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import htsjdk.samtools.SAMRecord;
import org.campagnelab.goby.alignments.Alignments;

public class EntryFlagHelper {
    public static String pairToString(SAMRecord entry) {
        StringBuffer sb = new StringBuffer();
        if (entry.getReadPairedFlag()) {
            sb.append("PAIRED|");
        }
        if (entry.getProperPairFlag()) {
            sb.append("PROPERLY_PAIRED|");
        }
        if (entry.getNotPrimaryAlignmentFlag()) {
            sb.append("NOT_PRIMARY_ALIGNMENT|");
        }
        if (entry.getReadUnmappedFlag()) {
            sb.append("READ_UNMAPPED|");
        }
        if (entry.getMateUnmappedFlag()) {
            sb.append("MATE_UNMAPPED|");
        }
        if (entry.getReadNegativeStrandFlag()) {
            sb.append("READ_REVERSE_STRAND|");
        }
        if (entry.getMateNegativeStrandFlag()) {
            sb.append("MATE_REVERSE_STRAND|");
        }
        if (entry.getFirstOfPairFlag()) {
            sb.append("FIRST|");
        }
        if (entry.getSecondOfPairFlag()) {
            sb.append("SECOND|");
        }
        return sb.toString();
    }

    public static String pairToString(Alignments.AlignmentEntry entry) {
        StringBuffer sb = new StringBuffer();
        if (EntryFlagHelper.isPaired(entry)) {
            sb.append("PAIRED|");
        }
        if (EntryFlagHelper.isProperlyPaired(entry)) {
            sb.append("PROPERLY_PAIRED|");
        }
        if (EntryFlagHelper.isNotPrimaryAlignment(entry)) {
            sb.append("NOT_PRIMARY_ALIGNMENT|");
        }
        if (EntryFlagHelper.isReadUnmapped(entry)) {
            sb.append("READ_UNMAPPED|");
        }
        if (EntryFlagHelper.isMateUnmapped(entry)) {
            sb.append("MATE_UNMAPPED|");
        }
        if (EntryFlagHelper.isReadReverseStrand(entry)) {
            sb.append("READ_REVERSE_STRAND|");
        }
        if (EntryFlagHelper.isMateReverseStrand(entry)) {
            sb.append("MATE_REVERSE_STRAND|");
        }
        if (EntryFlagHelper.isFirstInPair(entry)) {
            sb.append("FIRST|");
        }
        if (EntryFlagHelper.isSecondInPair(entry)) {
            sb.append("SECOND|");
        }
        return sb.toString();
    }

    public static String spliceToString(Alignments.AlignmentEntry entry) {
        StringBuffer sb = new StringBuffer();
        if (EntryFlagHelper.isNormalSplice(entry)) {
            sb.append("NORMAL_SPLICE|");
        }
        if (EntryFlagHelper.isNovelSplice(entry)) {
            sb.append("NOVEL_SPLICE|");
        }
        return sb.toString();
    }

    public static boolean isPaired(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 1L) != 0L;
    }

    public static int paired() {
        return 1;
    }

    public static int properlyPaired() {
        return 2;
    }

    public static int readUnmapped() {
        return 4;
    }

    public static int mateUnmapped() {
        return 8;
    }

    public static int readReverseStrand() {
        return 16;
    }

    public static int mateReverseStrand() {
        return 32;
    }

    public static int firstInPair() {
        return 64;
    }

    public static int secondInPair() {
        return 128;
    }

    public static int notPrimaryAlignment() {
        return 256;
    }

    public static boolean isProperlyPaired(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 2L) != 0L;
    }

    public static boolean isReadUnmapped(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 4L) != 0L;
    }

    public static boolean isMateUnmapped(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 8L) != 0L;
    }

    public static boolean isReadReverseStrand(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x10L) != 0L;
    }

    public static boolean isMateReverseStrand(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x20L) != 0L;
    }

    public static boolean isMateReverseStrand(int pairFlags) {
        return ((long)pairFlags & 0x20L) != 0L;
    }

    public static boolean isFirstInPair(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x40L) != 0L;
    }

    public static boolean isSecondInPair(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x80L) != 0L;
    }

    public static boolean isNotPrimaryAlignment(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x100L) != 0L;
    }

    public static boolean isNormalSplice(Alignments.AlignmentEntry entry) {
        return ((long)entry.getSplicedFlags() & 1L) != 0L;
    }

    public static boolean isNovelSplice(Alignments.AlignmentEntry entry) {
        return ((long)entry.getSplicedFlags() & 2L) != 0L;
    }
}

