/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineTranslator;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VCFSimpleHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private Map<String, String> genericFields = new LinkedHashMap<String, String>();
    public static final String ID_ATTRIBUTE = "ID";
    public static final String DESCRIPTION_ATTRIBUTE = "Description";

    public VCFSimpleHeaderLine(String key, String name, String description) {
        super(key, "");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(DESCRIPTION_ATTRIBUTE, description);
        this.initialize(name, map);
    }

    public VCFSimpleHeaderLine(String line, VCFHeaderVersion version, String key, List<String> expectedTagOrdering) {
        this(line, version, key, expectedTagOrdering, Collections.emptyList());
    }

    public VCFSimpleHeaderLine(String line, VCFHeaderVersion version, String key, List<String> expectedTagOrdering, List<String> recommendedTags) {
        this(key, VCFHeaderLineTranslator.parseLine(version, line, expectedTagOrdering, recommendedTags));
    }

    public VCFSimpleHeaderLine(String key, Map<String, String> mapping) {
        super(key, "");
        this.name = mapping.get(ID_ATTRIBUTE);
        this.initialize(this.name, mapping);
    }

    String getGenericFieldValue(String key) {
        return this.genericFields.get(key);
    }

    protected void initialize(String name, Map<String, String> genericFields) {
        if (name == null || genericFields == null || genericFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid VCFSimpleHeaderLine: key=%s name=%s", super.getKey(), name));
        }
        if (name.contains("<") || name.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (name.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        this.name = name;
        this.genericFields.putAll(genericFields);
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(ID_ATTRIBUTE, this.name);
        map.putAll(this.genericFields);
        return this.getKey() + "=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        VCFSimpleHeaderLine that = (VCFSimpleHeaderLine)o;
        return this.name.equals(that.name) && this.genericFields.equals(that.genericFields);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.genericFields.hashCode();
        return result;
    }

    @Override
    public String getID() {
        return this.name;
    }

    public Map<String, String> getGenericFields() {
        return Collections.unmodifiableMap(this.genericFields);
    }
}

