/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.variant.vcf.VCF3Parser;
import htsjdk.variant.vcf.VCF4Parser;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VCFHeaderLineTranslator {
    private static final Map<VCFHeaderVersion, VCFLineParser> mapping;

    public static Map<String, String> parseLine(VCFHeaderVersion version, String valueLine, List<String> expectedTagOrder) {
        return VCFHeaderLineTranslator.parseLine(version, valueLine, expectedTagOrder, Collections.emptyList());
    }

    public static Map<String, String> parseLine(VCFHeaderVersion version, String valueLine, List<String> expectedTagOrder, List<String> recommendedTags) {
        return mapping.get((Object)version).parseLine(valueLine, expectedTagOrder, recommendedTags);
    }

    static {
        HashMap<VCFHeaderVersion, VCFLineParser> map = new HashMap<VCFHeaderVersion, VCFLineParser>();
        map.put(VCFHeaderVersion.VCF4_0, new VCF4Parser());
        map.put(VCFHeaderVersion.VCF4_1, new VCF4Parser());
        map.put(VCFHeaderVersion.VCF4_2, new VCF4Parser());
        map.put(VCFHeaderVersion.VCF4_3, new VCF4Parser());
        map.put(VCFHeaderVersion.VCF3_3, new VCF3Parser());
        map.put(VCFHeaderVersion.VCF3_2, new VCF3Parser());
        mapping = Collections.unmodifiableMap(map);
    }
}

