/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.PositionalOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;

abstract class IndexingVariantContextWriter
implements VariantContextWriter {
    private final String name;
    private final Path location;
    private final SAMSequenceDictionary refDict;
    private OutputStream outputStream;
    private LocationAware locationSource = null;
    private IndexCreator indexer = null;
    static String DEFAULT_READER_NAME = "Reader Name";

    private IndexingVariantContextWriter(String name, Path location, OutputStream output, SAMSequenceDictionary refDict) {
        this.name = name;
        this.location = location;
        this.outputStream = output;
        this.refDict = refDict;
    }

    protected IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing) {
        this(name, IOUtil.toPath(location), output, refDict, enableOnTheFlyIndexing);
    }

    protected IndexingVariantContextWriter(String name, Path location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing) {
        this(name, location, output, refDict);
        if (enableOnTheFlyIndexing) {
            this.initIndexingWriter(new DynamicIndexCreator(location, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME));
        }
    }

    protected IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, IndexCreator idxCreator) {
        this(name, IOUtil.toPath(location), output, refDict, enableOnTheFlyIndexing, idxCreator);
    }

    protected IndexingVariantContextWriter(String name, Path location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, IndexCreator idxCreator) {
        this(name, location, output, refDict);
        if (enableOnTheFlyIndexing) {
            this.initIndexingWriter(idxCreator);
        }
    }

    private void initIndexingWriter(IndexCreator idxCreator) {
        this.indexer = idxCreator;
        if (this.outputStream instanceof LocationAware) {
            this.locationSource = (LocationAware)((Object)this.outputStream);
        } else {
            PositionalOutputStream positionalOutputStream = new PositionalOutputStream(this.outputStream);
            this.locationSource = positionalOutputStream;
            this.outputStream = positionalOutputStream;
        }
    }

    @Override
    public boolean checkError() {
        return this.getOutputStream() instanceof PrintStream && ((PrintStream)PrintStream.class.cast(this.getOutputStream())).checkError();
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getStreamName() {
        return this.name;
    }

    @Override
    public abstract void writeHeader(VCFHeader var1);

    @Override
    public void close() {
        try {
            this.outputStream.close();
            if (this.indexer != null) {
                this.indexer.setIndexSequenceDictionary(this.refDict);
                Index index = this.indexer.finalizeIndex(this.locationSource.getPosition());
                index.writeBasedOnFeaturePath(this.location);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to close index for " + this.getStreamName(), e);
        }
    }

    public SAMSequenceDictionary getRefDict() {
        return this.refDict;
    }

    @Override
    public void add(VariantContext vc) {
        if (this.indexer != null) {
            this.indexer.addFeature(vc, this.locationSource.getPosition());
        }
    }

    protected static final String writerName(File location, OutputStream stream) {
        return IndexingVariantContextWriter.writerName(IOUtil.toPath(location), stream);
    }

    protected static final String writerName(Path location, OutputStream stream) {
        return location == null ? (stream == null ? DEFAULT_READER_NAME : stream.toString()) : location.toAbsolutePath().toUri().toString();
    }
}

