/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.EdgingRecordAndOffset;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;

public class EdgeReadIterator
extends AbstractLocusIterator<EdgingRecordAndOffset, AbstractLocusInfo<EdgingRecordAndOffset>> {
    public EdgeReadIterator(SamReader samReader) {
        this(samReader, null);
    }

    public EdgeReadIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public EdgeReadIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        super(samReader, intervalList, useIndex);
    }

    @Override
    void accumulateSamRecord(SAMRecord rec) {
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            Interval interval;
            int accumulatorNextPosition;
            int readOffset = alignmentBlock.getReadStart() - 1;
            int refPos = alignmentBlock.getReferenceStart();
            if (this.accumulator.isEmpty()) {
                this.accumulator.add(this.createLocusInfo(this.getReferenceSequence(rec.getReferenceIndex()), rec.getAlignmentStart()));
            }
            if ((accumulatorNextPosition = ((AbstractLocusInfo)this.accumulator.get(0)).getPosition() + this.accumulator.size()) != ((AbstractLocusInfo)this.accumulator.get(this.accumulator.size() - 1)).getPosition() + 1) {
                throw new IllegalStateException("The accumulator has gotten into a funk. Cannot continue");
            }
            for (int locusPos = accumulatorNextPosition; locusPos <= refPos + alignmentBlock.getLength(); ++locusPos) {
                this.accumulator.add(this.createLocusInfo(this.getReferenceSequence(rec.getReferenceIndex()), locusPos));
            }
            int refOffsetInterval = refPos - rec.getAlignmentStart();
            int refOffsetEndInterval = refOffsetInterval + alignmentBlock.getLength();
            int startShift = 0;
            if (this.getIntervals() != null && (interval = this.getCurrentInterval()) != null) {
                int readEnd;
                int intervalEnd = interval.getEnd();
                int intervalStart = interval.getStart();
                if (!CoordMath.overlaps(refPos, refPos + alignmentBlock.getLength(), intervalStart, intervalEnd)) continue;
                if (refPos < intervalStart) {
                    startShift = intervalStart - refPos;
                    refOffsetInterval += startShift;
                }
                if ((readEnd = refPos + alignmentBlock.getLength()) > intervalEnd) {
                    refOffsetEndInterval = refOffsetEndInterval - (readEnd - intervalEnd) + 1;
                }
            }
            int length = refOffsetEndInterval - refOffsetInterval;
            EdgingRecordAndOffset recordAndOffset = this.createRecordAndOffset(rec, readOffset + startShift, length, refPos + startShift);
            ((AbstractLocusInfo)this.accumulator.get(refOffsetInterval)).add(recordAndOffset);
            EdgingRecordAndOffset recordAndOffsetEnd = this.createRecordAndOffset(recordAndOffset);
            ((AbstractLocusInfo)this.accumulator.get(refOffsetEndInterval)).add(recordAndOffsetEnd);
        }
    }

    @Override
    void accumulateIndels(SAMRecord rec) {
        throw new UnsupportedOperationException("Indels accumulation is not supported for " + this.getClass().getSimpleName() + ".");
    }

    @Override
    EdgingRecordAndOffset createRecordAndOffset(SAMRecord rec, int readOffset, int length, int refPos) {
        return EdgingRecordAndOffset.createBeginRecord(rec, readOffset, length, refPos);
    }

    EdgingRecordAndOffset createRecordAndOffset(EdgingRecordAndOffset startRecord) {
        return EdgingRecordAndOffset.createEndRecord(startRecord);
    }

    @Override
    AbstractLocusInfo<EdgingRecordAndOffset> createLocusInfo(SAMSequenceRecord referenceSequence, int lastPosition) {
        return new AbstractLocusInfo<EdgingRecordAndOffset>(referenceSequence, lastPosition);
    }

    @Override
    public void setMaxReadsToAccumulatePerLocus(int maxReadsToAccumulatePerLocus) {
        if (this.getMaxReadsToAccumulatePerLocus() != 0) {
            throw new UnsupportedOperationException("Locus cap is not supported for " + this.getClass().getSimpleName() + ".");
        }
    }

    @Override
    public void setQualityScoreCutoff(int qualityScoreCutoff) {
        throw new UnsupportedOperationException("Quality filtering is not supported for " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public void setEmitUncoveredLoci(boolean emitUncoveredLoci) {
        if (this.isEmitUncoveredLoci() != emitUncoveredLoci) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support work with skipping uncovered bases.");
        }
    }

    @Override
    public void setIncludeIndels(boolean includeIndels) {
        if (this.isIncludeIndels() != includeIndels) {
            throw new UnsupportedOperationException("Indels accumulation is not supported for " + this.getClass().getSimpleName() + ".");
        }
    }
}

