/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.util.Log;
import java.util.Objects;

public class AlignmentContext {
    private static final Log log = Log.getInstance(AlignmentContext.class);
    public static final int NO_ALIGNMENT_START = 0;
    public static final int NO_ALIGNMENT_SPAN = 0;
    public static final int NO_ALIGNMENT_END = 0;
    public static final AlignmentContext MULTIPLE_REFERENCE_CONTEXT = new AlignmentContext(ReferenceContext.MULTIPLE_REFERENCE_CONTEXT, 0, 0);
    public static final AlignmentContext UNMAPPED_UNPLACED_CONTEXT = new AlignmentContext(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, 0, 0);
    public static final AlignmentContext EOF_CONTAINER_CONTEXT = new AlignmentContext(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, 4542278, 0);
    private final ReferenceContext referenceContext;
    private final int alignmentStart;
    private final int alignmentSpan;

    public AlignmentContext(ReferenceContext referenceContext, int alignmentStart, int alignmentSpan) {
        this.referenceContext = referenceContext;
        this.alignmentStart = alignmentStart;
        this.alignmentSpan = alignmentSpan;
    }

    public ReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getAlignmentSpan() {
        return this.alignmentSpan;
    }

    public static void validateAlignmentContext(boolean isStrict, ReferenceContext referenceContext, int alignmentStart, int alignmentSpan) {
        switch (referenceContext.getType()) {
            case SINGLE_REFERENCE_TYPE: {
                if (alignmentStart >= 0) break;
                String errorString = String.format("Single-reference alignment context with an invalid start detected (index %d/start %d/span %d)", referenceContext.getReferenceSequenceID(), alignmentStart, alignmentSpan);
                if (isStrict) {
                    throw new CRAMException(errorString);
                }
                log.warn(errorString);
                break;
            }
            case UNMAPPED_UNPLACED_TYPE: {
                if (alignmentStart == 0 && alignmentSpan == 0 || alignmentStart == 4542278 && alignmentSpan == 0) break;
                String errorString = String.format("Unmapped/unplaced alignment context with invalid start/span detected (%d/%d)", alignmentStart, alignmentSpan);
                if (isStrict) {
                    throw new CRAMException(errorString);
                }
                log.warn(errorString);
                break;
            }
            case MULTIPLE_REFERENCE_TYPE: {
                if (alignmentStart == 0 && alignmentSpan == 0) break;
                String errorString = String.format("Multi-reference alignment context with invalid start/span detected (%d/%d)", alignmentStart, alignmentSpan);
                if (isStrict) {
                    throw new CRAMException(errorString);
                }
                log.warn(errorString);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Alignment context with unknown reference context type: %s", new Object[]{referenceContext.getType()}));
            }
        }
    }

    public String toString() {
        return String.format("sequenceId=%s, start=%d, span=%d", this.referenceContext, this.alignmentStart, this.alignmentSpan);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignmentContext that = (AlignmentContext)o;
        return this.alignmentStart == that.alignmentStart && this.alignmentSpan == that.alignmentSpan && Objects.equals(this.referenceContext, that.referenceContext);
    }

    public int hashCode() {
        return Objects.hash(this.referenceContext, this.alignmentStart, this.alignmentSpan);
    }
}

