/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public final class BZIP2ExternalCompressor
extends ExternalCompressor {
    public BZIP2ExternalCompressor() {
        super(BlockCompressionMethod.BZIP2);
    }

    @Override
    public byte[] compress(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BZip2CompressorOutputStream bos = new BZip2CompressorOutputStream((OutputStream)byteArrayOutputStream);){
            IOUtil.copyStream(new ByteArrayInputStream(data), (OutputStream)bos);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] uncompress(byte[] data) {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);){
            byte[] byArray = InputStreamUtils.readFully((InputStream)new BZip2CompressorInputStream((InputStream)byteArrayInputStream));
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

