/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class MemoryMappedFileBuffer
implements IndexFileBuffer {
    private MappedByteBuffer mFileBuffer;

    MemoryMappedFileBuffer(File file) {
        try {
            FileInputStream fileStream = new FileInputStream(file);
            FileChannel fileChannel = fileStream.getChannel();
            this.mFileBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            this.mFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
            fileChannel.close();
            fileStream.close();
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc.getMessage(), exc);
        }
    }

    @Override
    public void readBytes(byte[] bytes) {
        this.mFileBuffer.get(bytes);
    }

    @Override
    public int readInteger() {
        return this.mFileBuffer.getInt();
    }

    @Override
    public long readLong() {
        return this.mFileBuffer.getLong();
    }

    @Override
    public void skipBytes(int count) {
        this.mFileBuffer.position(this.mFileBuffer.position() + count);
    }

    @Override
    public void seek(long position) {
        this.mFileBuffer.position((int)position);
    }

    @Override
    public long position() {
        return this.mFileBuffer.position();
    }

    @Override
    public void close() {
        this.mFileBuffer = null;
    }
}

