/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIteratorFilter;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CoordMath;

public class BAMQueryMultipleIntervalsIteratorFilter
implements BAMIteratorFilter {
    final QueryInterval[] intervals;
    final boolean contained;
    int intervalIndex = 0;

    public BAMQueryMultipleIntervalsIteratorFilter(QueryInterval[] intervals, boolean contained) {
        this.contained = contained;
        this.intervals = intervals;
    }

    @Override
    public BAMIteratorFilter.FilteringIteratorState compareToFilter(SAMRecord record) {
        while (this.intervalIndex < this.intervals.length) {
            BAMIteratorFilter.IntervalComparison comparison = BAMQueryMultipleIntervalsIteratorFilter.compareIntervalToRecord(this.intervals[this.intervalIndex], record);
            switch (comparison) {
                case BEFORE: {
                    ++this.intervalIndex;
                    break;
                }
                case AFTER: {
                    return BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION;
                }
                case CONTAINED: {
                    return BAMIteratorFilter.FilteringIteratorState.MATCHES_FILTER;
                }
                case OVERLAPPING: {
                    return this.contained ? BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION : BAMIteratorFilter.FilteringIteratorState.MATCHES_FILTER;
                }
            }
        }
        return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
    }

    public static BAMIteratorFilter.IntervalComparison compareIntervalToRecord(QueryInterval interval, SAMRecord record) {
        int intervalEnd = interval.end <= 0 ? Integer.MAX_VALUE : interval.end;
        int alignmentEnd = record.getReadUnmappedFlag() && record.getAlignmentStart() != 0 ? record.getAlignmentStart() : record.getAlignmentEnd();
        if (interval.referenceIndex < record.getReferenceIndex()) {
            return BAMIteratorFilter.IntervalComparison.BEFORE;
        }
        if (interval.referenceIndex > record.getReferenceIndex()) {
            return BAMIteratorFilter.IntervalComparison.AFTER;
        }
        if (intervalEnd < record.getAlignmentStart()) {
            return BAMIteratorFilter.IntervalComparison.BEFORE;
        }
        if (alignmentEnd < interval.start) {
            return BAMIteratorFilter.IntervalComparison.AFTER;
        }
        if (CoordMath.encloses(interval.start, intervalEnd, record.getAlignmentStart(), alignmentEnd)) {
            return BAMIteratorFilter.IntervalComparison.CONTAINED;
        }
        return BAMIteratorFilter.IntervalComparison.OVERLAPPING;
    }
}

