/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;
    private final BlockCompressedOutputStream blockCompressedOutputStream;
    private BAMIndexer bamIndexer = null;

    protected BAMFileWriter(File path) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(path.getAbsolutePath());
    }

    protected BAMFileWriter(File path, int compressionLevel) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path, compressionLevel);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(path.getAbsolutePath());
    }

    protected BAMFileWriter(OutputStream os, File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, file);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    protected BAMFileWriter(OutputStream os, File file, int compressionLevel) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, file, compressionLevel);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    protected BAMFileWriter(OutputStream os, File file, int compressionLevel, DeflaterFactory deflaterFactory) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, file, compressionLevel, deflaterFactory);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    protected BAMFileWriter(OutputStream os, String absoluteFilename, int compressionLevel, DeflaterFactory deflaterFactory) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, (Path)null, compressionLevel, deflaterFactory);
        this.outputBinaryCodec = new BinaryCodec(this.blockCompressedOutputStream);
        this.outputBinaryCodec.setOutputFileName(absoluteFilename);
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getFileHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream(), this.getFilename());
        }
    }

    private String getPathString(File path) {
        return path != null ? path.getAbsolutePath() : null;
    }

    void enableBamIndexConstruction() {
        if (!this.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Not creating BAM index since not sorted by coordinates: " + (Object)((Object)this.getSortOrder()));
        }
        if (this.getFilename() == null) {
            throw new SAMException("Not creating BAM index since we don't have an output file name");
        }
        this.bamIndexer = this.createBamIndex(this.getFilename());
    }

    private BAMIndexer createBamIndex(String pathURI) {
        try {
            String indexFileBase = pathURI.endsWith(".bam") ? pathURI.substring(0, pathURI.lastIndexOf(46)) : pathURI;
            Path indexPath = IOUtil.getPath(indexFileBase + ".bai");
            if (Files.exists(indexPath, new LinkOption[0]) && !Files.isWritable(indexPath)) {
                throw new SAMException("Not creating BAM index since unable to write index file " + indexPath.toUri());
            }
            return new BAMIndexer(indexPath, this.getFileHeader());
        }
        catch (Exception e) {
            throw new SAMException("Not creating BAM index", e);
        }
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        this.prepareToWriteAlignments();
        if (this.bamIndexer != null) {
            try {
                long startOffset = this.blockCompressedOutputStream.getFilePointer();
                this.bamRecordCodec.encode(alignment);
                long stopOffset = this.blockCompressedOutputStream.getFilePointer();
                alignment.setFileSource(new SAMFileSource(null, new BAMFileSpan(new Chunk(startOffset, stopOffset))));
                this.bamIndexer.processAlignment(alignment);
            }
            catch (Exception e) {
                this.bamIndexer = null;
                throw new SAMException("Exception when processing alignment for BAM index " + alignment, e);
            }
        } else {
            this.bamRecordCodec.encode(alignment);
        }
    }

    @Override
    protected void writeHeader(String textHeader) {
        BAMFileWriter.writeHeader(this.outputBinaryCodec, this.getFileHeader(), textHeader);
    }

    @Override
    protected void finish() {
        this.outputBinaryCodec.close();
        try {
            if (this.bamIndexer != null) {
                this.bamIndexer.finish();
            }
        }
        catch (Exception e) {
            throw new SAMException("Exception writing BAM index file", e);
        }
    }

    @Override
    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }

    protected static void writeHeader(BinaryCodec outputBinaryCodec, SAMFileHeader samFileHeader, String headerText) {
        outputBinaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        outputBinaryCodec.writeString(headerText, true, false);
        outputBinaryCodec.writeInt(samFileHeader.getSequenceDictionary().size());
        for (SAMSequenceRecord sequenceRecord : samFileHeader.getSequenceDictionary().getSequences()) {
            outputBinaryCodec.writeString(sequenceRecord.getSequenceName(), true, true);
            outputBinaryCodec.writeInt(sequenceRecord.getSequenceLength());
        }
    }

    protected static void writeHeader(BinaryCodec outputBinaryCodec, SAMFileHeader samFileHeader) {
        StringWriter stringWriter = new StringWriter();
        new SAMTextHeaderCodec().encode(stringWriter, samFileHeader, true);
        String headerString = ((Object)stringWriter).toString();
        BAMFileWriter.writeHeader(outputBinaryCodec, samFileHeader, headerString);
    }

    public static void writeHeader(OutputStream outputStream, SAMFileHeader samFileHeader) {
        BlockCompressedOutputStream blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, (Path)null);
        BinaryCodec outputBinaryCodec = new BinaryCodec(blockCompressedOutputStream);
        BAMFileWriter.writeHeader(outputBinaryCodec, samFileHeader);
        try {
            blockCompressedOutputStream.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }
}

