/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibPathIterator;
import gov.nih.nlm.ncbi.ngs.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

class LMProperties
extends Properties {
    private String path;
    private String bits;
    private boolean dirty;

    LMProperties(String string, Map<String, String> map) {
        this.bits = string;
        this.path = LibPathIterator.ncbiHome();
        if (this.path != null) {
            this.path = this.path + LibPathIterator.fileSeparator() + "LibManager.properties";
            try {
                FileInputStream fileInputStream = new FileInputStream(this.path);
                this.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object setProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 != null && string3.equals(string2)) {
            return string3;
        }
        this.dirty = true;
        return super.setProperty(string, string2);
    }

    String get(String string) {
        return this.get(string, Logger.Level.FINE);
    }

    String cfgFilePath() {
        return this.path;
    }

    void setLastSearch(String string) {
        this.setProperty(this.getLibRoot(string) + "last-search", Long.toString(new Date().getTime()));
    }

    Date getLastSeach(String string) {
        String string2 = this.getProperty(this.getLibRoot(string) + "last-search");
        if (string2 == null) {
            return null;
        }
        return new Date(Long.valueOf(string2));
    }

    void setLatestVersion(String string, String string2) {
        String string3 = this.getLibRoot(string);
        this.setProperty(string3 + "latest-version/value", string2);
        this.setProperty(string3 + "latest-version/updated", Long.toString(new Date().getTime()));
    }

    String getLatestVersion(String string, long l) {
        String string2 = this.getLibRoot(string);
        String string3 = this.getProperty(string2 + "latest-version/value");
        String string4 = this.getProperty(string2 + "latest-version/updated");
        if (string4 == null || string3 == null) {
            return null;
        }
        if (new Date().getTime() - Long.valueOf(string4) > l) {
            this.remove(string2 + "latest-version/value");
            this.remove(string2 + "latest-version/updated");
            return null;
        }
        return string3;
    }

    void notLoaded(String string) {
        String string2 = this.getLibRoot(string);
        this.remove(string2 + "loaded/path");
        this.remove(string2 + "loaded/version");
        this.remove(string2 + "last-search");
        this.dirty = true;
    }

    void loaded(String string, String string2, String string3) {
        this.set(string, "loaded", string2, string3);
    }

    void saved(String string, String string2, String string3) {
        this.set(string, "saved", string2, string3);
    }

    void store() {
        try {
            if (!this.dirty) {
                return;
            }
            File file = new File(this.cfgFilePath());
            File file2 = file.getParentFile();
            if (file2 == null) {
                Logger.finest("Cannot find parent directory to store properties");
                return;
            }
            if (!file2.exists()) {
                if (!file2.mkdir()) {
                    Logger.finest("Cannot create " + file2.getName());
                    return;
                }
                file2.setExecutable(false, false);
                file2.setReadable(false, false);
                file2.setWritable(false, false);
                file2.setExecutable(true, true);
                file2.setReadable(true, true);
                file2.setWritable(true, true);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.store(fileOutputStream, null);
            fileOutputStream.close();
            this.dirty = false;
        }
        catch (IOException iOException) {
            Logger.finest(iOException);
        }
    }

    private void set(String string, String string2, String string3, String string4) {
        String string5 = this.getLibRoot(string) + string2 + "/";
        this.setProperty(string5 + "path", string4);
        this.setProperty(string5 + "version", string3);
    }

    private String get(String string, Logger.Level level) {
        String string2 = this.get(string, "loaded", level);
        if (string2 == null) {
            string2 = this.get(string, "saved", level);
        }
        return string2;
    }

    private String get(String string, String string2, Logger.Level level) {
        String string3 = this.getLibRoot(string) + string2 + "/";
        String string4 = this.getProperty(string3 + "version");
        if (string4 != null) {
            String string5 = this.getProperty(string3 + "path");
            if (string5 != null) {
                Logger.log(level, "The version of the most recently loaded " + string + " = " + string4);
                return string5;
            }
            this.remove(string3 + "version");
            this.dirty = true;
        }
        return null;
    }

    private String getLibRoot(String string) {
        return "/dll/" + string + "/" + this.bits + "/";
    }
}

