/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.iterators;

import edu.cornell.med.icb.io.TsvToFromMap;
import edu.cornell.med.icb.iterators.TextFileLineIterator;
import edu.cornell.med.icb.maps.LinkedHashToMultiTypeMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class TsvLineIterator
implements Iterable<LinkedHashToMultiTypeMap<String>>,
Closeable {
    private static final String COMMENT_CHAR = "#";
    private final TextFileLineIterator textFileLineIterator;
    private final Iterator<String> iterator;
    private final TsvToFromMap tsvReader;

    public TsvLineIterator(String filenameToRead) throws IOException {
        this(new File(filenameToRead));
    }

    public TsvLineIterator(File fileToRead) throws IOException {
        this.tsvReader = TsvToFromMap.createFromTsvFile(fileToRead);
        this.textFileLineIterator = new TextFileLineIterator(fileToRead);
        this.iterator = this.textFileLineIterator.iterator();
    }

    public TsvLineIterator(String filenameToRead, TsvToFromMap tsvReader) throws IOException {
        this(new File(filenameToRead), tsvReader);
    }

    public TsvLineIterator(File fileToRead, TsvToFromMap tsvReader) throws IOException {
        this.textFileLineIterator = new TextFileLineIterator(fileToRead);
        this.iterator = this.textFileLineIterator.iterator();
        this.tsvReader = tsvReader;
    }

    public TsvLineIterator(InputStream stream, TsvToFromMap tsvReader) throws IOException {
        this.textFileLineIterator = new TextFileLineIterator(stream);
        this.iterator = this.textFileLineIterator.iterator();
        this.tsvReader = tsvReader;
    }

    @Override
    public Iterator<LinkedHashToMultiTypeMap<String>> iterator() {
        return new TsvFileIterator();
    }

    @Override
    public void close() throws IOException {
        this.textFileLineIterator.close();
    }

    class TsvFileIterator
    implements Iterator<LinkedHashToMultiTypeMap<String>> {
        private LinkedHashToMultiTypeMap<String> nextline;

        public TsvFileIterator() {
            try {
                this.nextline = this.getNextLine(true);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public LinkedHashToMultiTypeMap<String> getNextLine(boolean skipOneLine) throws IOException {
            String readLine;
            if (skipOneLine) {
                while (TsvLineIterator.this.iterator.hasNext() && (readLine = (String)TsvLineIterator.this.iterator.next()).startsWith(TsvLineIterator.COMMENT_CHAR)) {
                }
            }
            while (TsvLineIterator.this.iterator.hasNext()) {
                readLine = (String)TsvLineIterator.this.iterator.next();
                if (readLine.startsWith(TsvLineIterator.COMMENT_CHAR)) continue;
                return TsvLineIterator.this.tsvReader.readDataToMap(readLine);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.nextline != null;
        }

        @Override
        public LinkedHashToMultiTypeMap<String> next() {
            try {
                LinkedHashToMultiTypeMap<String> result = this.nextline;
                if (this.nextline != null) {
                    this.nextline = this.getNextLine(false);
                }
                return result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

