/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.encode;

import java.io.File;
import java.util.Collection;
import java.util.Map;

public class EncodeFileRecord {
    boolean selected = false;
    String path;
    Map<String, String> attributes;
    String trackName;

    public EncodeFileRecord(String path, Map<String, String> attributes) {
        this.path = path;
        this.attributes = attributes;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileType() {
        String filetype = this.path;
        if (filetype.endsWith(".gz")) {
            filetype = filetype.substring(0, filetype.length() - 3);
        }
        int idx = filetype.lastIndexOf(".");
        return filetype.substring(idx + 1);
    }

    public String getAttributeValue(String name) {
        String value = this.attributes.get(name);
        if (name.equals("type") && value == null) {
            value = this.getFileType();
        }
        return value;
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean containsText(String filter) {
        for (String value : this.attributes.values()) {
            if (!value.contains(filter)) continue;
            return true;
        }
        return false;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getTrackName() {
        if (this.trackName == null) {
            StringBuffer sb = new StringBuffer();
            if (this.attributes.containsKey("cell")) {
                sb.append(this.attributes.get("cell") + " ");
            }
            if (this.attributes.containsKey("antibody")) {
                sb.append(this.attributes.get("antibody") + " ");
            }
            if (this.attributes.containsKey("dataType")) {
                sb.append(this.attributes.get("dataType") + " ");
            }
            if (this.attributes.containsKey("view")) {
                sb.append(this.attributes.get("view") + " ");
            }
            if (this.attributes.containsKey("replicate")) {
                sb.append("rep " + this.attributes.get("replicate"));
            }
            this.trackName = sb.toString().trim();
            if (sb.length() == 0) {
                this.trackName = new File(this.path).getName();
            }
        }
        return this.trackName;
    }

    public boolean hasMetaData() {
        return this.attributes.containsKey("cell") || this.attributes.containsKey("antibody");
    }
}

