/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipGenomes {
    public static void main(String[] args) throws IOException {
        File root = new File("/Users/jrobinso/projects/genomes");
        for (File f : root.listFiles()) {
            if (!f.getName().endsWith(".genome")) continue;
            String dirName = f.getName().replace(".genome", "");
            File dir = new File(root, dirName);
            dir.mkdir();
            UnzipGenomes.unzip(f, dir);
        }
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipEntry e;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zin = new ZipInputStream(in);
        while ((e = zin.getNextEntry()) != null) {
            File f = new File(destDir, e.getName());
            UnzipGenomes.unzip(zin, f);
        }
        zin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipInputStream zin, File f) throws IOException {
        System.out.println("unzipping " + f.getAbsolutePath());
        try (FileOutputStream out = null;){
            out = new FileOutputStream(f);
            byte[] b = new byte[512];
            int len = 0;
            while ((len = zin.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
    }
}

