/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broad.igv.util.Utilities;

public class CheckList
extends JPanel {
    private boolean editing = false;
    private boolean isDirty = false;
    private HashSet<String> itemSet = new HashSet();
    private boolean defaultState = true;
    private JLabel header = null;
    private JPanel itemPanel = new JPanel();
    private GridLayout layout;
    private Component[] componentState = new Component[0];

    public CheckList(boolean defaultState) {
        this(defaultState, null);
    }

    public CheckList(boolean defaultState, String headerText) {
        this.setLayout(new BorderLayout());
        this.defaultState = defaultState;
        this.layout = new GridLayout(0, 1);
        this.itemPanel.setLayout(this.layout);
        if (headerText != null) {
            this.header = new JLabel(headerText);
            this.add((Component)this.header, "North");
            this.add((Component)this.itemPanel, "Center");
        } else {
            this.add(this.itemPanel);
        }
        JPanel checkClearPanel = new JPanel();
        checkClearPanel.setLayout(new FlowLayout());
        JButton checkAllButton = new JButton("Select All");
        checkAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckList.this.setStateForAll(true);
            }
        });
        JButton clearAllButton = new JButton("Clear All");
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckList.this.setStateForAll(false);
            }
        });
        checkClearPanel.add(checkAllButton);
        checkClearPanel.add(clearAllButton);
        this.add((Component)checkClearPanel, "South");
    }

    private void setStateForAll(boolean selected) {
        for (Component c : this.itemPanel.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            ((JCheckBox)c).setSelected(selected);
        }
        this.isDirty = true;
    }

    public void addItems(List<String> itemStrings) {
        this.addItems(itemStrings, this.defaultState);
    }

    public void addItems(List<String> itemStrings, boolean isChecked) {
        int nColumns = itemStrings.size() / 20 + 1;
        this.layout.setColumns(nColumns);
        for (String itemText : itemStrings) {
            this.addItem(itemText, isChecked);
        }
        JButton checkAllButton = new JButton("Check All");
        this.itemPanel.add(checkAllButton);
        this.isDirty = true;
    }

    public void addItem(String itemText, Boolean isChecked) {
        if (this.itemSet.contains(itemText.trim())) {
            return;
        }
        JCheckBox checkBox = new JCheckBox();
        if (itemText != null) {
            checkBox.setText(itemText);
        }
        if (isChecked == null) {
            checkBox.setSelected(this.defaultState);
        } else {
            checkBox.setSelected(isChecked);
        }
        this.itemPanel.add(checkBox);
        this.itemSet.add(itemText.trim());
        this.isDirty = true;
    }

    public void clear() {
        this.itemPanel.removeAll();
        this.itemSet.clear();
        this.isDirty = true;
    }

    public void update() {
        if (this.isEditing()) {
            return;
        }
        Component[] components = this.getItemComponents();
        int length = components.length;
        this.componentState = new Component[length];
        int i = 0;
        for (Component component : this.itemPanel.getComponents()) {
            boolean isChecked = ((JCheckBox)component).isSelected();
            String text = ((JCheckBox)component).getText();
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected(isChecked);
            checkBox.setText(text);
            this.componentState[i++] = checkBox;
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public HashSet<String> getSelectedItems() {
        if (this.isDirty) {
            this.update();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Component component : this.componentState) {
            String text;
            JCheckBox checkBox;
            if (!(component instanceof JCheckBox) || !(checkBox = (JCheckBox)component).isSelected() || (text = checkBox.getText().trim()) == null || text.equals("")) continue;
            set.add(text);
        }
        return set;
    }

    public HashSet<String> getUnselectedItems() {
        if (this.isDirty) {
            this.update();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Component component : this.componentState) {
            String text;
            JCheckBox checkBox;
            if (!(component instanceof JCheckBox) || (checkBox = (JCheckBox)component).isSelected() || (text = checkBox.getText().trim()) == null || text.equals("")) continue;
            set.add(text);
        }
        return set;
    }

    public void deselectItems(Collection<String> strings) {
        for (Component component : this.componentState) {
            String text;
            JCheckBox checkBox;
            if (!(component instanceof JCheckBox) || !(checkBox = (JCheckBox)component).isSelected() || !strings.contains(text = checkBox.getText().trim())) continue;
            checkBox.setSelected(false);
        }
    }

    protected Component[] getItemComponents() {
        return this.itemPanel.getComponents();
    }

    public void sort() {
        ArrayList<String> temp = new ArrayList<String>();
        for (String item : this.itemSet) {
            temp.add(item.toLowerCase());
        }
        Collections.sort(temp, Utilities.getNumericStringComparator());
        Component[] checkBoxes = this.itemPanel.getComponents();
        this.itemPanel.removeAll();
        block1: for (int i = 0; i < temp.size(); ++i) {
            for (Component checkBox : checkBoxes) {
                String name = ((JCheckBox)checkBox).getText();
                if (!name.equalsIgnoreCase((String)temp.get(i))) continue;
                this.itemPanel.add(checkBox);
                continue block1;
            }
        }
        this.isDirty = true;
    }

    public void cancelChanges() {
        if (!this.isEditing()) {
            return;
        }
        this.itemPanel.removeAll();
        for (Component item : this.componentState) {
            this.itemPanel.add(item);
        }
    }
}

