/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.PAFFeature;
import org.broad.igv.util.ParsingUtils;

public class PAFCodec
extends AsciiFeatureCodec<PAFFeature> {
    private static Logger log = Logger.getLogger(MUTCodec.class);
    private static int chrColumn = 5;
    private static int startColumn = 7;
    private static int endColumn = 8;
    private static int scoreColumn = 11;
    private String path;
    private Genome genome;
    private int errorCount = 0;

    public PAFCodec(String path, Genome genome) {
        super(PAFFeature.class);
        this.path = path;
        this.genome = genome;
        try {
            LineIteratorImpl reader = new LineIteratorImpl((LineReader)new AsciiLineReader(ParsingUtils.openInputStream(path)));
            this.readActualHeader((LineIterator)reader);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    public PAFFeature decode(String line) {
        float score;
        int end;
        int start;
        String[] tokens = Globals.tabPattern.split(line);
        StringBuffer description = new StringBuffer();
        String chr = this.genome == null ? tokens[chrColumn].trim() : this.genome.getCanonicalChrName(tokens[chrColumn].trim());
        try {
            start = Integer.parseInt(tokens[startColumn].trim());
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (startColumn + 1) + " must be a numeric value.", this.path);
        }
        try {
            end = Integer.parseInt(tokens[endColumn].trim());
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (endColumn + 1) + " must be a numeric value.", this.path);
        }
        Strand strand = tokens[4].equals("+") ? Strand.POSITIVE : (tokens[4].equals("-") ? Strand.NEGATIVE : Strand.NONE);
        try {
            score = (float)Double.parseDouble(tokens[scoreColumn]);
        }
        catch (NumberFormatException e) {
            throw new DataLoadException("Column " + (scoreColumn + 1) + " must be a numeric value.", this.path);
        }
        String name = tokens[0] + ":" + tokens[2] + "-" + tokens[3];
        description.append("Query sequence name: " + tokens[0] + "<br>");
        description.append("Query sequence length: " + tokens[1] + "<br>");
        description.append("Query start (0-based): " + tokens[2] + "<br>");
        description.append("Query end (0-based):" + tokens[3] + "<br>");
        description.append("Relative strand: " + tokens[4] + "<br>");
        description.append("Target sequence name: " + tokens[5] + "<br>");
        description.append("Target sequence length: " + tokens[6] + "<br>");
        description.append("Target start (0-based): " + tokens[7] + "<br>");
        description.append("Target end (0-based): " + tokens[8] + "<br>");
        description.append("Number of residual matches: " + tokens[9] + "<br>");
        description.append("Alignment block length: " + tokens[10] + "<br>");
        description.append("Mapping quality (0-255): " + tokens[11] + "<br>");
        for (int i = 12; i < tokens.length; ++i) {
            String tag = tokens[i];
            if (tag.startsWith("cg")) continue;
            description.append(tag + "<br>");
        }
        return new PAFFeature(chr, start, end, strand, score, name, description.toString());
    }

    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.endsWith(".paf");
    }
}

