/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.fasta.FastaBlockCompressedSequence;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class JsonGenomeLoader
extends GenomeLoader {
    private static Logger log = Logger.getLogger(JsonGenomeLoader.class);
    private String genomePath;

    public JsonGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        String fastaPath;
        BufferedReader reader = ParsingUtils.openBufferedReader(this.genomePath);
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
        String id = json.get("id").getAsString();
        String name = json.get("name").getAsString();
        String indexPath = null;
        if (json.has("compressedFastaURL")) {
            JsonElement fastaElement = json.has("compressedFastaURL") ? json.get("compressedFastaURL") : json.get("fastaURL");
            fastaPath = fastaElement.getAsString();
        } else {
            fastaPath = json.get("fastaURL").getAsString();
            JsonElement indexPathObject = json.get("indexURL");
            indexPath = indexPathObject == null ? null : indexPathObject.getAsString();
        }
        fastaPath = FileUtils.getAbsolutePath(fastaPath, this.genomePath);
        if (indexPath != null) {
            indexPath = FileUtils.getAbsolutePath(indexPath, this.genomePath);
        }
        FastaIndexedSequence sequence = fastaPath.endsWith(".gz") ? new FastaBlockCompressedSequence(fastaPath, indexPath) : new FastaIndexedSequence(fastaPath, indexPath);
        JsonElement orderedElement = json.get("ordered");
        boolean ordered = orderedElement != null && orderedElement.getAsBoolean();
        JsonElement aliasURL = json.get("aliasURL");
        ArrayList<ResourceLocator> tracks = new ArrayList<ResourceLocator>();
        ArrayList<ResourceLocator> hiddenTracks = new ArrayList<ResourceLocator>();
        JsonArray annotations = json.getAsJsonArray("tracks");
        if (annotations == null) {
            annotations = json.getAsJsonArray("annotations");
        }
        if (annotations != null) {
            annotations.forEach(jsonElement -> {
                JsonObject obj = jsonElement.getAsJsonObject();
                String trackPath = obj.get("url").getAsString();
                JsonElement trackName = obj.get("name");
                JsonElement trackIndex = obj.get("indexURL");
                JsonElement indexedElement = obj.get("indexed");
                JsonElement hiddenElement = obj.get("hidden");
                boolean hidden = hiddenElement != null && hiddenElement.getAsBoolean();
                boolean indexed = indexedElement != null && indexedElement.getAsBoolean();
                String trackIndexPath = null;
                if (trackPath != null) {
                    trackPath = FileUtils.getAbsolutePath(trackPath, this.genomePath);
                }
                if (trackIndex != null) {
                    trackIndexPath = FileUtils.getAbsolutePath(trackIndex.getAsString(), this.genomePath);
                }
                ResourceLocator res = new ResourceLocator(trackPath);
                if (trackName != null) {
                    res.setName(trackName.getAsString());
                }
                if (trackIndexPath != null) {
                    res.setIndexPath(trackIndexPath);
                }
                if (indexedElement != null) {
                    res.setIndexed(indexed);
                }
                if (hidden) {
                    if (indexed || trackIndex != null) {
                        log.info((Object)("Hidden tracks cannot be indexed.  Ignoring " + trackPath));
                    } else {
                        hiddenTracks.add(res);
                    }
                } else {
                    tracks.add(res);
                }
            });
        }
        Genome newGenome = new Genome(id, name, sequence, ordered);
        newGenome.setAnnotationResources(tracks);
        if (aliasURL != null) {
            newGenome.addChrAliases(GenomeLoader.loadChrAliases(aliasURL.getAsString()));
        }
        if (hiddenTracks.size() > 0) {
            this.addToFeatureDB(hiddenTracks, newGenome);
        }
        return newGenome;
    }

    public GenomeDescriptor loadDescriptor() throws IOException {
        BufferedReader reader = ParsingUtils.openBufferedReader(this.genomePath);
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
        String id = json.get("id").getAsString();
        String name = json.get("name").getAsString();
        String fastaPath = json.get("fastaURL").getAsString();
        return new GenomeDescriptor(id, name, fastaPath);
    }

    private void addToFeatureDB(List<ResourceLocator> locators, Genome genome) {
        for (ResourceLocator locator : locators) {
            try {
                AbstractFeatureReader featureReader = TribbleFeatureSource.getBasicReader(locator, genome);
                for (Feature f : featureReader) {
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.addFeature((NamedFeature)f, genome);
                }
            }
            catch (IOException e) {
                log.error((Object)("Error loading " + locator.getPath()));
            }
        }
    }

    public static class GenomeDescriptor {
        String id;
        String name;
        String fastaURL;

        public GenomeDescriptor(String id, String name, String fastaURL) {
            this.id = id;
            this.name = name;
            this.fastaURL = fastaURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getFastaURL() {
            return this.fastaURL;
        }
    }
}

