/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.seg.Segment;
import org.broad.igv.data.seg.SegmentedBinaryLocalReader;
import org.broad.igv.data.seg.SegmentedBinaryReader;
import org.broad.igv.data.seg.SegmentedChromosomeData;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

public class SegmentedBinaryDataSet
implements SegmentedDataSet {
    SegmentedBinaryReader reader;
    private long lastRefreshTime = 0L;
    Boolean logNormalized = null;
    private List<String> sampleNames = null;
    Map<String, Map<String, List<LocusScore>>> segmentsCache = new HashMap<String, Map<String, List<LocusScore>>>();
    Map<String, SegmentedChromosomeData> chrData = new HashMap<String, SegmentedChromosomeData>();
    TrackType type = TrackType.COPY_NUMBER;

    public SegmentedBinaryDataSet(ResourceLocator locator) {
        this.reader = new SegmentedBinaryLocalReader(locator.getPath());
        try {
            this.type = TrackType.valueOf(this.reader.getStringAttribute("type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String logNormalizedString = this.reader.getStringAttribute("logNormalized");
            if (logNormalizedString != null) {
                this.logNormalized = logNormalizedString.equals("true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<LocusScore> getSegments(String heading, String chr) {
        List<LocusScore> segments;
        Map<String, List<LocusScore>> chrSegments = this.segmentsCache.get(heading);
        if (chrSegments == null) {
            chrSegments = new HashMap<String, List<LocusScore>>();
            this.segmentsCache.put(heading, chrSegments);
        }
        if ((segments = chrSegments.get(chr)) == null) {
            int i;
            SegmentedChromosomeData cd = this.chrData.get(chr);
            if (cd == null) {
                cd = this.reader.getChromosomeData(chr);
                this.chrData.put(chr, cd);
            }
            int[] startLocations = cd.getStartLocations(heading);
            int[] endLocations = cd.getEndLocations(heading);
            float[] values = cd.getValues(heading);
            if (startLocations == null || startLocations.length == 0) {
                return null;
            }
            if (this.logNormalized == null) {
                this.logNormalized = false;
                for (i = 0; i < values.length; ++i) {
                    if (!(values[i] < 0.0f)) continue;
                    this.logNormalized = true;
                    break;
                }
            }
            assert (startLocations.length == endLocations.length);
            assert (endLocations.length == values.length);
            segments = new ArrayList<LocusScore>(startLocations.length);
            for (i = 0; i < startLocations.length; ++i) {
                segments.add(new Segment(startLocations[i], endLocations[i], values[i]));
                chrSegments.put(chr, segments);
            }
        }
        return segments;
    }

    @Override
    public List<String> getSampleNames() {
        if (this.sampleNames == null) {
            this.sampleNames = this.reader.getSampleNames();
        }
        return this.sampleNames;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    @Override
    public boolean isLogNormalized() {
        return this.logNormalized == null ? true : this.logNormalized;
    }

    @Override
    public double getDataMax(String chr) {
        return 3.0;
    }

    @Override
    public double getDataMin(String chr) {
        return -3.0;
    }

    @Override
    public synchronized List<LocusScore> getWholeGenomeScores(String heading) {
        return this.getSegments(heading, "All");
    }

    public static class ChromosomeChunk {
    }
}

