/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.ExtraMath;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.codecs;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuffer buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;
    boolean unicodeCoercion;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String string2) {
        this(string2, false);
    }

    public StringFormatter(String string2, boolean bl) {
        this.format = string2;
        this.unicodeCoercion = bl;
        this.buffer = new StringBuffer(string2.length() + 100);
    }

    PyObject getarg() {
        PyObject pyObject = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                pyObject = this.args.__finditem__(this.argIndex++);
            }
        }
        if (pyObject == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return pyObject;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject pyObject = this.getarg();
            if (pyObject instanceof PyInteger) {
                return ((PyInteger)pyObject).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int n = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer n2 = Integer.valueOf(this.format.substring(n, this.index));
            return n2;
        }
        --this.index;
        return 0;
    }

    private void checkPrecision(String string2) {
        if (this.precision > 250) {
            throw Py.OverflowError("formatted " + string2 + " is too long (precision too long?)");
        }
    }

    private String formatLong(PyString pyString, char c, boolean bl) {
        this.checkPrecision("long");
        String string2 = pyString.toString();
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        if (c == 'x' || c == 'X') {
            n3 = 2;
        }
        if (string2.endsWith("L")) {
            --n;
        }
        boolean bl2 = this.negative = string2.charAt(0) == '-';
        if (this.negative) {
            ++n2;
        }
        int n4 = n - n3 - n2;
        if (!bl) {
            switch (c) {
                case 'o': {
                    if (n4 <= 1) break;
                    ++n2;
                    --n4;
                    break;
                }
                case 'X': 
                case 'x': {
                    n2 += 2;
                    n3 -= 2;
                }
            }
        }
        if (this.precision > n4) {
            int n5;
            StringBuffer stringBuffer = new StringBuffer();
            for (n5 = 0; n5 < n3; ++n5) {
                stringBuffer.append(string2.charAt(n2++));
            }
            for (n5 = 0; n5 < this.precision - n4; ++n5) {
                stringBuffer.append('0');
            }
            for (n5 = 0; n5 < n4; ++n5) {
                stringBuffer.append(string2.charAt(n2++));
            }
            string2 = stringBuffer.toString();
        } else if (n < string2.length() || n2 > 0) {
            string2 = string2.substring(n2, n);
        }
        switch (c) {
            case 'x': {
                string2 = string2.toLowerCase();
            }
        }
        return string2;
    }

    private String formatInteger(PyObject pyObject, int n, boolean bl) {
        return this.formatInteger(((PyInteger)pyObject.__int__()).getValue(), n, bl);
    }

    private String formatInteger(long l, int n, boolean bl) {
        this.checkPrecision("integer");
        if (bl) {
            if (l < 0L) {
                l = 0x100000000L + l;
            }
        } else if (l < 0L) {
            this.negative = true;
            l = -l;
        }
        String string2 = Long.toString(l, n);
        while (string2.length() < this.precision) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private String formatFloatDecimal(PyObject pyObject, boolean bl) {
        return this.formatFloatDecimal(pyObject.__float__().getValue(), bl);
    }

    private String formatFloatDecimal(double d, boolean bl) {
        this.checkPrecision("decimal");
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        int n = this.precision;
        if (n == -1) {
            n = 6;
        }
        if (d < 0.0) {
            d = -d;
            this.negative = true;
        }
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(bl ? 0 : n);
        numberFormat.setGroupingUsed(false);
        String string2 = numberFormat.format(d);
        return string2;
    }

    private String formatFloatExponential(PyObject pyObject, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = pyObject.__float__().getValue();
        boolean bl2 = false;
        if (d < 0.0) {
            d = -d;
            bl2 = true;
        }
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = ExtraMath.closeFloor(ExtraMath.log10(d));
        }
        int n = this.precision;
        this.precision = bl ? -1 : 3;
        String string2 = this.formatInteger((long)d2, 10, false);
        if (this.negative) {
            this.negative = false;
            string2 = '-' + string2;
        } else if (!bl) {
            string2 = '+' + string2;
        }
        this.precision = n;
        double d3 = d / Math.pow(10.0, d2);
        stringBuffer.append(this.formatFloatDecimal(d3, bl));
        stringBuffer.append(c);
        stringBuffer.append(string2);
        this.negative = bl2;
        return stringBuffer.toString();
    }

    public PyString format(PyObject pyObject) {
        PyObject pyObject2 = null;
        this.args = pyObject;
        boolean bl = false;
        if (pyObject instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (pyObject instanceof PyDictionary || pyObject instanceof PyStringMap || !(pyObject instanceof PySequence) && pyObject.__findattr__("__getitem__") != null) {
                pyObject2 = pyObject;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            int n;
            String string2;
            char c;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n2 = -1;
            this.precision = -1;
            char c2 = this.pop();
            if (c2 != '%') {
                this.buffer.append(c2);
                continue;
            }
            c2 = this.pop();
            if (c2 == '(') {
                if (pyObject2 == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int n3 = 1;
                c = this.index;
                while (n3 > 0) {
                    c2 = this.pop();
                    if (c2 == ')') {
                        --n3;
                        continue;
                    }
                    if (c2 != '(') continue;
                    ++n3;
                }
                string2 = this.format.substring(c, this.index - 1);
                this.args = pyObject2.__getitem__(new PyString(string2));
            } else {
                this.push();
            }
            block21: while (true) {
                c2 = this.pop();
                switch (c2) {
                    case '-': {
                        bl2 = true;
                        continue block21;
                    }
                    case '+': {
                        bl3 = true;
                        continue block21;
                    }
                    case ' ': {
                        bl4 = true;
                        continue block21;
                    }
                    case '#': {
                        bl5 = true;
                        continue block21;
                    }
                    case '0': {
                        bl6 = true;
                        continue block21;
                    }
                }
                break;
            }
            this.push();
            n2 = this.getNumber();
            if (n2 < 0) {
                n2 = -n2;
                bl2 = true;
            }
            if ((c2 = this.pop()) == '.') {
                this.precision = this.getNumber();
                if (this.precision < -1) {
                    this.precision = 0;
                }
                c2 = this.pop();
            }
            if (c2 == 'h' || c2 == 'l' || c2 == 'L') {
                c2 = this.pop();
            }
            if (c2 == '%') {
                this.buffer.append(c2);
                continue;
            }
            PyObject pyObject3 = this.getarg();
            c = ' ';
            string2 = null;
            this.negative = false;
            c = bl6 ? (char)'0' : ' ';
            switch (c2) {
                case 'r': 
                case 's': {
                    c = ' ';
                    string2 = c2 == 's' ? (this.unicodeCoercion ? pyObject3.__unicode__().toString() : pyObject3.__str__().toString()) : pyObject3.__repr__().toString();
                    if (this.precision >= 0 && string2.length() > this.precision) {
                        string2 = string2.substring(0, this.precision);
                    }
                    if (!(pyObject3 instanceof PyUnicode)) break;
                    bl = true;
                    break;
                }
                case 'd': 
                case 'i': {
                    if (pyObject3 instanceof PyLong) {
                        string2 = this.formatLong(pyObject3.__str__(), c2, bl5);
                        break;
                    }
                    string2 = this.formatInteger(pyObject3, 10, false);
                    break;
                }
                case 'u': {
                    if (pyObject3 instanceof PyLong) {
                        string2 = this.formatLong(pyObject3.__str__(), c2, bl5);
                        break;
                    }
                    string2 = this.formatInteger(pyObject3, 10, true);
                    break;
                }
                case 'o': {
                    if (pyObject3 instanceof PyLong) {
                        string2 = this.formatLong(pyObject3.__oct__(), c2, bl5);
                        break;
                    }
                    string2 = this.formatInteger(pyObject3, 8, true);
                    if (!bl5 || string2.charAt(0) == '0') break;
                    string2 = "0" + string2;
                    break;
                }
                case 'x': {
                    if (pyObject3 instanceof PyLong) {
                        string2 = this.formatLong(pyObject3.__hex__(), c2, bl5);
                        break;
                    }
                    string2 = this.formatInteger(pyObject3, 16, true);
                    string2 = string2.toLowerCase();
                    if (!bl5) break;
                    string2 = "0x" + string2;
                    break;
                }
                case 'X': {
                    if (pyObject3 instanceof PyLong) {
                        string2 = this.formatLong(pyObject3.__hex__(), c2, bl5);
                        break;
                    }
                    string2 = this.formatInteger(pyObject3, 16, true);
                    string2 = string2.toUpperCase();
                    if (!bl5) break;
                    string2 = "0X" + string2;
                    break;
                }
                case 'E': 
                case 'e': {
                    string2 = this.formatFloatExponential(pyObject3, c2, false);
                    break;
                }
                case 'f': {
                    string2 = this.formatFloatDecimal(pyObject3, false);
                    break;
                }
                case 'G': 
                case 'g': {
                    double d;
                    int n4;
                    n = this.precision;
                    if (n == -1) {
                        n = 6;
                    }
                    if ((n4 = (int)Math.ceil(ExtraMath.log10(d = pyObject3.__float__().getValue()))) > 0) {
                        if (n4 <= n) {
                            this.precision = n - n4;
                            string2 = this.formatFloatDecimal(pyObject3, true);
                        } else {
                            string2 = this.formatFloatExponential(pyObject3, (char)(c2 - 2), true);
                        }
                    } else {
                        string2 = this.formatFloatDecimal(pyObject3, true);
                    }
                    if (!bl5 || string2.indexOf(46) != -1) break;
                    int n5 = n - string2.length();
                    string2 = string2 + '.';
                    if (n5 <= 0) break;
                    char[] cArray = new char[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        cArray[n6++] = 48;
                    }
                    string2 = string2 + new String(cArray);
                    break;
                }
                case 'c': {
                    c = ' ';
                    if (pyObject3 instanceof PyString) {
                        string2 = ((PyString)pyObject3).toString();
                        if (string2.length() != 1) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        if (!(pyObject3 instanceof PyUnicode)) break;
                        bl = true;
                        break;
                    }
                    int n5 = ((PyInteger)pyObject3.__int__()).getValue();
                    string2 = new Character((char)n5).toString();
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newString(c2), null, "replace") + "' (0x" + Integer.toHexString(c2) + ") at index " + (this.index - 1));
                }
            }
            n = string2.length();
            int n7 = 0;
            String string3 = null;
            if (this.negative) {
                string3 = "-";
            } else if (bl3) {
                string3 = "+";
            } else if (bl4) {
                string3 = " ";
            }
            if (n2 < n) {
                n2 = n;
            }
            if (string3 != null) {
                if (c != ' ') {
                    this.buffer.append(string3);
                }
                if (n2 > n) {
                    --n2;
                }
            }
            if (bl5 && (c2 == 'x' || c2 == 'X')) {
                if (c != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n7 += 2;
                }
                if ((n2 -= 2) < 0) {
                    n2 = 0;
                }
                n -= 2;
            }
            if (n2 > n && !bl2) {
                do {
                    this.buffer.append(c);
                } while (--n2 > n);
            }
            if (c == ' ') {
                if (string3 != null) {
                    this.buffer.append(string3);
                }
                if (bl5 && (c2 == 'x' || c2 == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n7 += 2;
                }
            }
            if (n7 > 0) {
                this.buffer.append(string2.substring(n7));
            } else {
                this.buffer.append(string2);
            }
            while (--n2 >= n) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && pyObject.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted");
        }
        if (bl) {
            return new PyUnicode(this.buffer.toString());
        }
        return new PyString(this.buffer.toString());
    }
}

