/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.test;

import java.io.IOException;
import java.util.Locale;
import net.sf.profiler4j.agent.Agent;
import net.sf.profiler4j.agent.Transformer;

public class Test1 {
    private static long sumNET10;
    private static long sumNET20;
    private static long sumNET30;
    private static long sumNET100;
    private static long sumNET500;

    public static void main(String[] args) throws IOException {
        Test1.initLocalAgent("-beanprops:on -access:private", "*(*):accept");
        Thread t = new Thread("TEST1"){

            public void run() {
                int i;
                for (i = 0; i < 100; ++i) {
                    Test1.iter();
                    if (i % 10 != 0) continue;
                    System.out.println("Iter #" + i);
                }
                System.out.format("avg(NET10)=%.2fms\n", (double)sumNET10 / ((double)i * 1000000.0));
                System.out.format("avg(NET20)=%.2fms\n", (double)sumNET20 / ((double)i * 1000000.0));
                System.out.format("avg(NET30)=%.2fms\n", (double)sumNET30 / ((double)i * 1000000.0));
                System.out.format("avg(NET100)=%.2fms\n", (double)sumNET100 / ((double)i * 1000000.0));
                System.out.format("avg(NET500)=%.2fms\n", (double)sumNET500 / ((double)i * 1000000.0));
            }
        };
        t.setPriority(10);
        System.out.println("=== Starting Test Thread ====");
        t.start();
    }

    public static void initLocalAgent(String opts, String rules) throws IOException {
        Locale.setDefault(Locale.US);
        final int[] progress = new int[1];
        Transformer.Callback callback = new Transformer.Callback(){

            public void notifyClassTransformed(String className, int backSequence, int bachSize) {
                progress[0] = backSequence;
            }
        };
        int n = Agent.startNewSession(opts, rules, callback);
        while (progress[0] < n) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
    }

    private static void iter() {
        Test1.NET10();
        Test1.NET20();
        Test1.NET30();
        Test1.NET100();
        Test1.NET500();
    }

    private static void NET10() {
        long t0 = System.nanoTime();
        Test1.sleep(10L);
        sumNET10 += System.nanoTime() - t0;
    }

    private static void NET20() {
        long t0 = System.nanoTime();
        Test1.sleep(20L);
        sumNET20 += System.nanoTime() - t0;
    }

    private static void NET30() {
        long t0 = System.nanoTime();
        Test1.sleep(40L);
        sumNET30 += System.nanoTime() - t0;
    }

    private static void NET100() {
        long t0 = System.nanoTime();
        Test1.sleep(100L);
        sumNET100 += System.nanoTime() - t0;
    }

    private static void NET500() {
        long t0 = System.nanoTime();
        Test1.sleep(500L);
        sumNET500 += System.nanoTime() - t0;
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

