/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.util.Iterator;
import java.util.Map;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.readers.InputException;

public abstract class InputObject
extends ProviderUtil {
    protected Map map;

    public abstract Map initializeMap() throws InputException;

    public Object get(String key) throws InputException {
        Object o = this.getValue(key);
        if (o == null) {
            throw new InputException("InputObject[" + InputObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws InputException {
        Object o = this.getValue(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new InputException("InputObject[" + InputObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws InputException {
        Object o = this.getValue(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new InputException("InputObject[" + InputObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws InputException {
        Object o = this.getValue(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public long getLong(String key) throws InputException {
        Object o = this.getValue(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    private Object getValue(String key) {
        return key == null ? null : this.map.get(key);
    }

    public String getString(String key) throws InputException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean isNull(String key) {
        Object value = this.getValue(key);
        return value == null;
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        char b = s.charAt(0);
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                    try {
                        return Integer.parseInt(s.substring(2), 16);
                    }
                    catch (Exception e) {
                    }
                } else {
                    try {
                        return Integer.parseInt(s, 8);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                if (s.indexOf(46) > -1 || s.indexOf(101) > -1 || s.indexOf(69) > -1) {
                    return Double.valueOf(s);
                }
                Long myLong = new Long(s);
                if (myLong == (long)myLong.intValue()) {
                    return myLong.intValue();
                }
                return myLong;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public InputObject put(String key, Object value) throws InputException {
        if (key != null && value != null) {
            if (this.map.get(key) != null) {
                throw new InputException("Duplicate key \"" + key + "\"");
            }
            InputObject.verify(value);
            this.map.put(key, value);
        }
        if (value == null) {
            this.map.remove(key);
        }
        return this;
    }

    public InputObject putMap(String key, Map value) {
        this.map.putAll(value);
        return this;
    }

    static void verify(Object o) throws InputException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new InputException("Non-finite numbers not allowed");
        }
    }
}

