/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.adapter.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.adapter.file.FileBackingStoreFactory;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

public class FileBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    protected Logger logger = Logger.getLogger(FileBackingStore.class.getName());
    protected File baseDir;
    private boolean shutdown;
    private static Level TRACE_LEVEL = Level.FINE;
    private String debugStr;
    private FileBackingStoreFactory factory;
    private long defaultMaxIdleTimeoutInSeconds = 600L;

    @Override
    protected void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        if (conf.getLogger() != null) {
            this.logger = conf.getLogger();
        }
        super.initialize(conf);
        this.debugStr = "[FileBackingStore - " + conf.getStoreName() + "] ";
        this.baseDir = conf.getBaseDirectory();
        try {
            if (!this.baseDir.mkdirs() && !this.baseDir.isDirectory()) {
                throw new BackingStoreException("[FileBackingStore::initialize] Create base directory (" + this.baseDir.getAbsolutePath() + ") failed");
            }
            this.logger.log(Level.INFO, "[FileBackingStore::initialize] Successfully Created and initialized store. Working dir: " + conf.getBaseDirectory() + "; Configuration: " + conf);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, this.debugStr + " Exception during initialization", ex);
        }
        try {
            Map<String, Object> vendorMap = conf.getVendorSpecificSettings();
            this.defaultMaxIdleTimeoutInSeconds = Long.valueOf((String)vendorMap.get("max.idle.timeout.in.seconds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setFileBackingStoreFactory(FileBackingStoreFactory factory) {
        this.factory = factory;
    }

    @Override
    public BackingStoreFactory getBackingStoreFactory() {
        return this.factory;
    }

    @Override
    public V load(K key, String version) throws BackingStoreException {
        byte[] data;
        String fileName = key.toString();
        Serializable value = null;
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Entered load(" + key + ", " + version + ")");
        }
        if ((data = this.readFromfile(fileName)) != null) {
            try {
                ByteArrayInputStream bis2 = new ByteArrayInputStream(data);
                ObjectInputStream ois = super.createObjectInputStream(bis2);
                value = (Serializable)ois.readObject();
                if (this.logger.isLoggable(TRACE_LEVEL)) {
                    this.logger.log(TRACE_LEVEL, this.debugStr + "Done load(" + key + ", " + version + ")");
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, this.debugStr + "Failed to load(" + key + ", " + version + ")", ex);
            }
        }
        return (V)value;
    }

    @Override
    public void remove(K sessionKey) {
        this.remove(sessionKey.toString());
    }

    @Override
    private void remove(String sessionKey) {
        try {
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + "Entered remove(" + sessionKey + ")");
            }
            boolean status = this.removeFile(new File(this.baseDir, sessionKey));
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + "Done remove( " + sessionKey + "); status => " + status);
            }
        }
        catch (Exception ex) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Failed to remove(" + sessionKey + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            String[] fileNames;
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + "Entered destroy()");
            }
            if ((fileNames = this.baseDir.list()) == null) {
                return;
            }
            for (int i = 0; i < fileNames.length; ++i) {
                this.remove(fileNames[i]);
            }
            if (!this.baseDir.delete() && this.baseDir.exists()) {
                this.logger.log(Level.WARNING, this.debugStr + " destroy() failed to remove dir: " + this.baseDir.getAbsolutePath());
            }
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + "Done destroy()");
            }
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, this.debugStr + " destroy() failed ", th);
        }
        finally {
            FileBackingStoreFactory.removemapping(this.getBackingStoreConfiguration().getStoreName());
        }
    }

    @Override
    public int removeExpired() {
        return this.removeExpired(this.defaultMaxIdleTimeoutInSeconds * 1000L);
    }

    @Override
    public int removeExpired(long idleForMillis) {
        long threshold = System.currentTimeMillis() - idleForMillis;
        int expiredSessions = 0;
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Entered removeExpired()");
        }
        try {
            String[] fileNames = this.baseDir.list();
            if (fileNames == null) {
                return 0;
            }
            int size = fileNames.length;
            for (int i = 0; i < size && !this.shutdown; ++i) {
                long lastAccessed;
                File file = new File(this.baseDir, fileNames[i]);
                if (!file.exists() || (lastAccessed = file.lastModified()) >= threshold) continue;
                if (!file.delete()) {
                    if (!file.exists()) continue;
                    this.logger.log(Level.WARNING, this.debugStr + " Couldn't remove file: " + fileNames[i]);
                    continue;
                }
                ++expiredSessions;
            }
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + "Done removeExpired()");
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, this.debugStr + " Exception while getting " + "expired files", ex);
        }
        return expiredSessions;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public int size() throws BackingStoreException {
        String[] numFiles = this.baseDir.list();
        return numFiles == null ? 0 : numFiles.length;
    }

    @Override
    public String save(K sessionKey, V value, boolean isNew) throws BackingStoreException {
        String fileName = sessionKey.toString();
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Entered save(" + sessionKey + ")");
        }
        this.writetoFile(sessionKey, fileName, this.getSerializedState(sessionKey, value));
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Done save(" + sessionKey + ")");
        }
        return this.getBackingStoreConfiguration().getInstanceName();
    }

    public void updateTimeStamp(K k, String version, long timeStamp) throws BackingStoreException {
        this.updateTimestamp(k, timeStamp);
    }

    @Override
    public void updateTimestamp(K sessionKey, long time) throws BackingStoreException {
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Entered updateTimestamp(" + sessionKey + ", " + time + ")");
        }
        this.touchFile(sessionKey, sessionKey.toString(), time);
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + "Done updateTimestamp(" + sessionKey + ", " + time + ")");
        }
    }

    private void touchFile(Object sessionKey, String fileName, long time) throws BackingStoreException {
        block4: {
            try {
                File file = new File(this.baseDir, fileName);
                if (file.setLastModified(time)) break block4;
                if (!file.exists()) {
                    this.logger.log(Level.WARNING, this.debugStr + ": Cannot update timsestamp for: " + sessionKey + "; File does not exist");
                    break block4;
                }
                throw new BackingStoreException(this.debugStr + ": Cannot update timsestamp for: " + sessionKey);
            }
            catch (BackingStoreException sfsbSMEx) {
                throw sfsbSMEx;
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, this.debugStr + ": Exception while updating timestamp", ex);
                throw new BackingStoreException("Cannot update timsestamp for: " + sessionKey + "; Got exception: " + ex);
            }
        }
    }

    private boolean removeFile(final File file) {
        boolean success = false;
        success = System.getSecurityManager() == null ? file.delete() : ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.delete();
            }
        })).booleanValue();
        return success;
    }

    private byte[] getSerializedState(K key, V value) throws BackingStoreException {
        byte[] data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.flush();
            data = bos.toByteArray();
        }
        catch (IOException ioEx) {
            throw new BackingStoreException("Error during getSerializedState", ioEx);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException ioEx) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException ioEx) {}
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromfile(String fileName) {
        File file;
        byte[] data = null;
        if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(TRACE_LEVEL, this.debugStr + " Attempting to load session: " + fileName);
        }
        if ((file = new File(this.baseDir, fileName)).exists()) {
            int dataSize = (int)file.length();
            data = new byte[dataSize];
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                int count;
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                int offset = 0;
                for (int toRead = dataSize; toRead > 0; toRead -= count) {
                    count = bis.read(data, offset, toRead);
                    offset += count;
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "FileStore.readFromfile failed", ex);
            }
            finally {
                try {
                    bis.close();
                }
                catch (Exception ex) {
                    this.logger.log(Level.FINE, this.debugStr + " Error while " + "closing buffered input stream", ex);
                }
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    this.logger.log(Level.FINE, this.debugStr + " Error while " + "closing file input stream", ex);
                }
            }
        } else if (this.logger.isLoggable(TRACE_LEVEL)) {
            this.logger.log(Level.WARNING, this.debugStr + "Could not find " + "file for: " + fileName);
        }
        return data;
    }

    private void writetoFile(K sessionKey, String fileName, byte[] data) throws BackingStoreException {
        File file = new File(this.baseDir, fileName);
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            ((BufferedOutputStream)bos).write(data, 0, data.length);
            ((BufferedOutputStream)bos).flush();
            if (this.logger.isLoggable(TRACE_LEVEL)) {
                this.logger.log(TRACE_LEVEL, this.debugStr + " Successfully saved " + "session: " + sessionKey);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "writetoFile(" + sessionKey + ") failed", ex);
            try {
                this.removeFile(file);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            String errMsg = "Could not save session: " + sessionKey;
            throw new BackingStoreException(errMsg, ex);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "Error while closing buffered output stream", ex);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "Error while closing file output stream", ex);
            }
        }
    }
}

