/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiFrameworkLauncher;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiGlassFishRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public final class OSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private Framework framework;
    private Logger logger = LogFacade.BOOTSTRAP_LOGGER;
    private Properties oldProvisioningOptions;
    private Properties newProvisioningOptions;
    private OSGiFrameworkLauncher fwLauncher;

    @Override
    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        try {
            MainHelper.buildStartupContext(bsProps.getProperties());
            Properties properties = bsProps.getProperties();
            properties.setProperty("GlassFish.BUILDER_NAME", this.getClass().getName());
            long t0 = System.currentTimeMillis();
            this.fwLauncher = new OSGiFrameworkLauncher(properties);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            long t1 = System.currentTimeMillis();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Launched {0}", new Object[]{this.framework});
            if (this.newFramework()) {
                this.storeProvisioningOptions(properties);
            } else {
                this.reconfigure(properties);
            }
            BundleProvisioner bundleProvisioner = BundleProvisioner.createBundleProvisioner(this.framework.getBundleContext(), properties);
            List<Long> bundleIds = bundleProvisioner.installBundles();
            if (bundleProvisioner.hasAnyThingChanged()) {
                bundleProvisioner.refresh();
                this.deleteHK2Cache(properties);
                this.storeBundleIds(bundleIds.toArray(new Long[bundleIds.size()]));
            }
            if (bundleProvisioner.isSystemBundleUpdationRequired()) {
                this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00034");
                this.framework.update();
                this.framework.waitForStop(0L);
                this.framework.init();
                bundleProvisioner.setBundleContext(this.framework.getBundleContext());
            }
            bundleProvisioner.startBundles();
            long t2 = System.currentTimeMillis();
            this.framework.start();
            long t3 = System.currentTimeMillis();
            this.printStats(bundleProvisioner, t0, t1, t2, t3);
            return this.getGlassFishRuntime();
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public boolean handles(BootstrapProperties bsProps) {
        String builderName = bsProps.getProperty("GlassFish.BUILDER_NAME");
        if (builderName != null && !builderName.equals(this.getClass().getName())) {
            return false;
        }
        String platformStr = bsProps.getProperty("GlassFish_Platform");
        if (platformStr != null && platformStr.trim().length() != 0) {
            try {
                Constants.Platform platform = Constants.Platform.valueOf(platformStr);
                switch (platform) {
                    case Felix: 
                    case Equinox: 
                    case Knopflerfish: {
                        return true;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return false;
    }

    private GlassFishRuntime getGlassFishRuntime() throws GlassFishException {
        ServiceReference reference = this.framework.getBundleContext().getServiceReference(GlassFishRuntime.class.getName());
        if (reference != null) {
            GlassFishRuntime embeddedGfr = (GlassFishRuntime)this.framework.getBundleContext().getService(reference);
            return new OSGiGlassFishRuntime(embeddedGfr, this.framework);
        }
        throw new GlassFishException("No GlassFishRuntime available");
    }

    private void deleteHK2Cache(Properties properties) throws GlassFishException {
        File inhabitantsCache;
        String cacheDir = properties.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheDir != null && (inhabitantsCache = new File(cacheDir, "inhabitants")).exists() && !inhabitantsCache.delete()) {
            throw new GlassFishException("cannot delete cache:" + inhabitantsCache.getAbsolutePath());
        }
    }

    private void printStats(BundleProvisioner bundleProvisioner, long t0, long t1, long t2, long t3) {
        this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "installed = {0}, updated = {1}, uninstalled = {2}", new Object[]{bundleProvisioner.getNoOfInstalledBundles(), bundleProvisioner.getNoOfUpdatedBundles(), bundleProvisioner.getNoOfUninstalledBundles()});
        this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "build", "Total time taken (in ms) to initialize framework = {0}, to install/update/delete/start bundles = {1}, to start framework= {2}", new Object[]{t1 - t0, t2 - t1, t3 - t2});
    }

    private boolean newFramework() {
        return this.framework.getBundleContext().getBundles().length == 1;
    }

    private void reconfigure(Properties properties) throws Exception {
        if (this.hasBeenReconfigured(properties)) {
            this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00035");
            this.framework.stop();
            this.framework.waitForStop(0L);
            properties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
            this.fwLauncher = new OSGiFrameworkLauncher(properties);
            this.framework = this.fwLauncher.launchOSGiFrameWork();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "reconfigure", "Launched {0}", new Object[]{this.framework});
            this.storeProvisioningOptions(properties);
        }
    }

    private boolean hasBeenReconfigured(Properties properties) {
        try {
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "oldProvisioningOptions = {0}", new Object[]{this.getOldProvisioningOptions()});
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "hasBeenReconfigured", "newProvisioningOptions = {0}", new Object[]{this.getNewProvisioningOptions(properties)});
            return !this.getNewProvisioningOptions(properties).equals(this.getOldProvisioningOptions());
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private Properties getNewProvisioningOptions(Properties properties) {
        if (this.newProvisioningOptions == null) {
            Properties props = new Properties();
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("glassfish.osgi")) continue;
                props.setProperty(key, properties.getProperty(key));
            }
            this.newProvisioningOptions = props;
        }
        return this.newProvisioningOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBundleIds(Long[] bundleIds) {
        ObjectOutputStream os = null;
        try {
            File f = this.framework.getBundleContext().getDataFile("glassfish.bundleids");
            if (f == null) {
                this.logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00037");
                return;
            }
            os = new ObjectOutputStream(new FileOutputStream(f));
            os.writeObject(bundleIds);
            os.flush();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "storeBundleIds", "Stored bundle ids in {0}", new Object[]{f.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProvisioningOptions(Properties properties) {
        FileOutputStream os = null;
        try {
            File f = this.framework.getBundleContext().getDataFile("provisioning.properties");
            if (f == null) {
                this.logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00038");
                return;
            }
            os = new FileOutputStream(f);
            this.getNewProvisioningOptions(properties).store(os, "");
            os.flush();
            this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "storeProvisioningOptions", "Stored provisioning options in {0}", new Object[]{f.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Properties getOldProvisioningOptions() throws IOException {
        if (this.oldProvisioningOptions == null) {
            Properties options = new Properties();
            try {
                File f = this.framework.getBundleContext().getDataFile("provisioning.properties");
                if (f != null && f.exists()) {
                    options.load(new FileInputStream(f));
                    this.logger.logp(Level.FINE, "OSGiGlassFishRuntimeBuilder", "getOldProvisioningOptions", "Read provisioning options from {0}", new Object[]{f.getAbsolutePath()});
                    this.oldProvisioningOptions = options;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.oldProvisioningOptions;
    }
}

