/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.ui.internal.util.TreeItemAdapter;
import org.rssowl.ui.internal.util.ViewerOpenStrategy;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

public class BookMarkViewer
extends TreeViewer {
    private final BookMarkExplorer fExplorer;
    private ListenerList fOpenListeners = new ListenerList();
    private ViewerOpenStrategy fViewerOpenStrategy;

    public BookMarkViewer(BookMarkExplorer explorer, Composite parent, int style) {
        super(parent, style);
        this.fExplorer = explorer;
    }

    public void createChildren(Widget widget) {
        super.createChildren(widget);
    }

    public void refresh(boolean updateLabels) {
        this.getControl().getParent().setRedraw(false);
        try {
            super.refresh(updateLabels);
        }
        finally {
            this.getControl().getParent().setRedraw(true);
        }
    }

    public void refresh(Object element) {
        super.refresh(element);
        if (element == this.getRoot()) {
            return;
        }
        this.fExplorer.restoreExpandedElements();
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        this.fExplorer.restoreExpandedElements();
    }

    public void remove(final Object[] elements) {
        this.updateSelectionAfterDelete(new Runnable(){

            public void run() {
                BookMarkViewer.this.internalRemove(elements);
            }
        });
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        if (this.fViewerOpenStrategy != null) {
            this.fViewerOpenStrategy.clearExpandFlag();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
        if (this.fViewerOpenStrategy != null) {
            this.fViewerOpenStrategy.clearExpandFlag();
        }
    }

    protected void setSelection(List items) {
        super.setSelection(items);
        if (this.fViewerOpenStrategy != null) {
            this.fViewerOpenStrategy.clearExpandFlag();
        }
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        super.setSelectionToWidget(selection, reveal);
        if (this.fViewerOpenStrategy != null) {
            this.fViewerOpenStrategy.clearExpandFlag();
        }
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        super.setSelectionToWidget(v, reveal);
        if (this.fViewerOpenStrategy != null) {
            this.fViewerOpenStrategy.clearExpandFlag();
        }
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.fViewerOpenStrategy = new ViewerOpenStrategy(control);
        this.fViewerOpenStrategy.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                BookMarkViewer.this.internalHandleOpen();
            }
        });
    }

    public void addOpenListener(IOpenListener listener) {
        this.fOpenListeners.add((Object)listener);
    }

    private void internalHandleOpen() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection selection = this.getSelection();
            this.internalFireOpen(new OpenEvent((Viewer)this, selection));
        }
    }

    private void internalFireOpen(final OpenEvent event) {
        Object[] listeners = this.fOpenListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IOpenListener listener = (IOpenListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.open(event);
                }
            });
            ++i;
        }
    }

    private void updateSelectionAfterDelete(Runnable runnable) {
        Object[] selectedElements;
        Tree tree = (Tree)this.getControl();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.isEmpty()) {
            runnable.run();
            return;
        }
        int minSelectedIndex = Integer.MAX_VALUE;
        TreeItemAdapter parentOfMinSelected = new TreeItemAdapter(tree);
        Object[] objectArray = selectedElements = selection.toArray();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item;
            TreeItemAdapter parent;
            int index;
            Object selectedElement = objectArray[n2];
            Widget widget = this.findItem(selectedElement);
            if (widget instanceof TreeItem && (index = (parent = new TreeItemAdapter(item = (TreeItem)widget).getParent()).indexOf(item)) == (minSelectedIndex = Math.min(minSelectedIndex, index))) {
                parentOfMinSelected.setItem(parent.getItem());
            }
            ++n2;
        }
        runnable.run();
        Object data = null;
        if (parentOfMinSelected.getItem().isDisposed()) {
            return;
        }
        data = parentOfMinSelected.getItemCount() > minSelectedIndex ? parentOfMinSelected.getItem(minSelectedIndex).getData() : (parentOfMinSelected.getItemCount() > 0 ? parentOfMinSelected.getItem(parentOfMinSelected.getItemCount() - 1).getData() : parentOfMinSelected.getItem().getData());
        if (data != null) {
            StructuredSelection newSelection = new StructuredSelection(data);
            this.setSelection((ISelection)newSelection);
        }
    }
}

