/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.services.SyncService;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class SynchronizationStatusDialog
extends TitleAreaDialog {
    private LocalResourceManager fResources;
    private final SyncService.SyncStatus fStatus;
    private final DateFormat fDateFormat = OwlUI.getShortDateFormat();
    private final DateFormat fTimeFormat = OwlUI.getShortTimeFormat();

    public SynchronizationStatusDialog(Shell parentShell, SyncService.SyncStatus status) {
        super(parentShell);
        this.fStatus = status;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SynchronizationStatusDialog_SYNC_STATUS);
    }

    protected Control createDialogArea(Composite parent) {
        DateFormat format;
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.SynchronizationStatusDialog_SYNC_STATUS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "/icons/wizban/reader_wiz.png"));
        if (this.fStatus == null) {
            this.setMessage(Messages.SynchronizationStatusDialog_NO_STATUS_AVAILABLE, 1);
        } else if (this.fStatus.isOK()) {
            this.setMessage(Messages.SynchronizationStatusDialog_LAST_SYNC_OK, 1);
        } else {
            this.setMessage(Messages.SynchronizationStatusDialog_LAST_SYNC_ERROR, 3);
        }
        Link dialogMessageLink = new Link(composite, 64);
        dialogMessageLink.setLayoutData((Object)new GridData(4, 1, true, false));
        boolean isToday = this.fStatus != null ? DateUtils.isAfterIncludingToday((Date)new Date(this.fStatus.getTime()), (long)DateUtils.getToday().getTimeInMillis()) : false;
        DateFormat dateFormat = format = isToday ? this.fTimeFormat : this.fDateFormat;
        if (this.fStatus == null) {
            dialogMessageLink.setText(Messages.SynchronizationStatusDialog_NO_STATUS_MSG);
            dialogMessageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SynchronizationStatusDialog.this.close();
                    ImportAction action = new ImportAction();
                    action.openWizardDefault(SynchronizationStatusDialog.this.getParentShell());
                }
            });
        } else if (this.fStatus.isOK()) {
            if (this.fStatus.getItemCount() == 1) {
                dialogMessageLink.setText(NLS.bind((String)Messages.SynchronizationStatusDialog_LAST_SYNC_OK_MSG, (Object)format.format(this.fStatus.getTime()), (Object)this.fStatus.getTotalItemCount()));
            } else {
                dialogMessageLink.setText(NLS.bind((String)Messages.SynchronizationStatusDialog_LAST_SYNC_OK_MSG_N, (Object[])new Object[]{this.fStatus.getItemCount(), format.format(this.fStatus.getTime()), this.fStatus.getTotalItemCount()}));
            }
        } else {
            String userUrl;
            String string = userUrl = this.fStatus.getException() instanceof SyncConnectionException ? ((SyncConnectionException)this.fStatus.getException()).getUserUrl() : null;
            if (StringUtils.isSet(userUrl)) {
                dialogMessageLink.setText(NLS.bind((String)Messages.SynchronizationStatusDialog_LAST_SYNC_ERROR_MSG_LINK, (Object)format.format(this.fStatus.getTime()), (Object)this.fStatus.getException().getMessage()));
                dialogMessageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BrowserUtils.openLinkExternal(userUrl);
                    }
                });
            } else {
                dialogMessageLink.setText(NLS.bind((String)Messages.SynchronizationStatusDialog_LAST_SYNC_ERROR_MSG, (Object)format.format(this.fStatus.getTime()), (Object)CoreUtils.toMessage((Throwable)this.fStatus.getException())));
            }
        }
        new Label(composite, 0);
        Composite sepHolder = new Composite(parent, 0);
        sepHolder.setLayoutData((Object)new GridData(4, 1, true, false));
        sepHolder.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        Label separator = new Label(sepHolder, 258);
        separator.setLayoutData((Object)new GridData(768));
        SynchronizationStatusDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(0).setFocus();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point location = this.getInitialLocation(bestSize);
        this.getShell().setBounds(location.x, location.y, bestSize.x, bestSize.y);
    }
}

