/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.SearchMarkDialog;

public class NewSearchMarkAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private Shell fShell;
    private IFolder fParent;
    private IMark fPosition;

    public NewSearchMarkAction() {
        this(null, null, null);
    }

    public NewSearchMarkAction(Shell shell, IFolder parent, IMark position) {
        this.fShell = shell;
        this.fParent = parent;
        this.fPosition = position;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        this.internalRun();
    }

    private void internalRun() throws PersistenceException {
        SearchMarkDialog dialog = new SearchMarkDialog(this.fShell, OwlUI.getSelectedParent(this.fParent), this.fPosition);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        this.fParent = null;
        this.fPosition = null;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty()) {
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IFolder) {
                this.fParent = (IFolder)firstElement;
            } else if (firstElement instanceof IMark) {
                this.fParent = ((IMark)firstElement).getParent();
                this.fPosition = (IMark)firstElement;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }
}

