/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URIException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.util.RegExUtils;
import org.rssowl.core.util.StringUtils;

public class URIUtils {
    public static final String ABOUT_BLANK = "about:blank";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String[] FEED_EXTENSIONS = new String[]{"rss", "rdf", "xml", "atom", "feed"};
    private static final String[] CHARS_TO_ENCODE = new String[]{" ", "[", "]", "{", "}", "|", "^", "\\", "<", ">"};
    private static final String[] ENCODED_CHARS = new String[]{"%20", "%5B", "%5D", "%7B", "%7D", "%7C", "%5E", "%5C", "%3C", "%3E"};
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String FEED = "feed://";
    public static final String FEED_IDENTIFIER = "feed:";
    public static final String NEWS_IDENTIFIER = "news:";
    public static final String NNTP_IDENTIFIER = "nntp:";
    public static final String PROTOCOL_IDENTIFIER = "://";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FEED_SCHEME = "feed";
    public static final String FILE_SCHEME = "file";
    public static final String JS_IDENTIFIER = "javascript:";
    private static final String MANAGED_LINK_SEPARATOR = "#";
    private static final String MANAGED_LINK_ANCHOR = "rssowlmlink";
    public static final String MANAGED_LINK_IDENTIFIER = "#rssowlmlink";

    private URIUtils() {
    }

    public static URI normalizeUri(URI link) {
        return URIUtils.normalizeUri(link, false);
    }

    public static URI normalizeUri(URI link, boolean withPort) {
        try {
            if (withPort) {
                return new URI(link.getScheme(), null, URIUtils.safeGetHost(link), link.getPort(), null, null, null);
            }
            return new URI(link.getScheme(), URIUtils.safeGetHost(link), null, null);
        }
        catch (URISyntaxException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return link;
        }
    }

    public static URI resolve(URI base, URI relative) throws URISyntaxException {
        if (relative.isAbsolute()) {
            return relative;
        }
        if (relative.toString().startsWith("/")) {
            base = URIUtils.normalizeUri(base, true);
            return base.resolve(relative);
        }
        if (base.toString().endsWith("/")) {
            return base.resolve(relative);
        }
        return new URI(String.valueOf(base.toString()) + "/").resolve(relative.toString());
    }

    public static boolean looksLikeFeedLink(String str) {
        return URIUtils.looksLikeFeedLink(str, true);
    }

    public static boolean looksLikeFeedLink(String str, boolean strict) {
        if (!URIUtils.looksLikeLink(str)) {
            return false;
        }
        if (str.startsWith(FEED)) {
            return true;
        }
        String[] stringArray = FEED_EXTENSIONS;
        int n = FEED_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (strict && str.contains("." + extension)) {
                return true;
            }
            if (!strict && str.contains(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean looksLikeLink(String str) {
        return URIUtils.looksLikeLink(str, true);
    }

    public static boolean looksLikeLink(String str, boolean allowNewsGroup) {
        if (!StringUtils.isSet(str)) {
            return false;
        }
        if (str.indexOf(32) >= 0) {
            return false;
        }
        if (!allowNewsGroup && (str.startsWith(NEWS_IDENTIFIER) || str.startsWith(NNTP_IDENTIFIER))) {
            return false;
        }
        if (RegExUtils.isValidURL(str)) {
            return true;
        }
        try {
            new URL(str);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static String mailToUrllEncode(String str) {
        return URIUtils.urlEncode(str).replaceAll("\\+", "%20");
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    public static URI createURI(String str) {
        if (str == null) {
            return null;
        }
        try {
            str = str.trim();
            str = URIUtils.fastEncode(str);
            return new URI(str);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URI toFaviconUrl(URI link, boolean rewriteHost) throws URISyntaxException {
        String host = URIUtils.safeGetHost(link);
        if (!StringUtils.isSet(host)) {
            return null;
        }
        if (rewriteHost) {
            String[] hostSegments = host.split("\\.");
            int len = hostSegments.length;
            if (len > 2 && !"www".equals(hostSegments[0])) {
                host = String.valueOf(hostSegments[len - 2]) + "." + hostSegments[len - 1];
            } else {
                throw new URISyntaxException("", "");
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(HTTP);
        buf.append(host);
        buf.append("/favicon.ico");
        return new URI(URIUtils.fastEncode(buf.toString()));
    }

    public static URI toTopLevel(URI link) throws URISyntaxException {
        if (link == null) {
            return null;
        }
        String host = URIUtils.safeGetHost(link);
        if (!StringUtils.isSet(host)) {
            return null;
        }
        return new URI(HTTP + host);
    }

    public static String getFile(URI uri, String extension) {
        if (!StringUtils.isSet(extension)) {
            return URIUtils.getFile(uri);
        }
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        String fileQuerySegment = URIUtils.getFileSegmentFromQuery(uri.getQuery(), extension);
        String lastPathSegment = URIUtils.getLastSegmentFromPath(uri.getPath());
        if (StringUtils.isSet(fileQuerySegment) && fileQuerySegment.contains(extension)) {
            return URIUtils.urlDecode(fileQuerySegment);
        }
        if (StringUtils.isSet(lastPathSegment) && lastPathSegment.contains(extension)) {
            return URIUtils.urlDecode(lastPathSegment);
        }
        if (StringUtils.isSet(lastPathSegment)) {
            return URIUtils.urlDecode(lastPathSegment);
        }
        if (StringUtils.isSet(fileQuerySegment)) {
            return URIUtils.urlDecode(fileQuerySegment);
        }
        return uri.toASCIIString();
    }

    private static String getLastSegmentFromPath(String path) {
        String[] parts;
        if (StringUtils.isSet(path) && (parts = path.split("/")).length > 0 && StringUtils.isSet(parts[parts.length - 1])) {
            return parts[parts.length - 1];
        }
        return null;
    }

    private static String getFileSegmentFromQuery(String query, String extension) {
        if (StringUtils.isSet(query)) {
            StringTokenizer tokenizer = new StringTokenizer(query, "&?=/");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            Collections.reverse(tokens);
            for (String token : tokens) {
                if (!token.contains(extension)) continue;
                return token;
            }
        }
        return null;
    }

    private static String getFile(URI uri) {
        String[] parts;
        String file = uri.getPath();
        if (StringUtils.isSet(file) && (parts = file.split("/")).length > 0 && StringUtils.isSet(parts[parts.length - 1])) {
            return URIUtils.urlDecode(parts[parts.length - 1]);
        }
        return uri.toASCIIString();
    }

    public static String fastEncode(String url) {
        int i = 0;
        while (i < CHARS_TO_ENCODE.length) {
            if (url.contains(CHARS_TO_ENCODE[i])) {
                url = StringUtils.replaceAll(url, CHARS_TO_ENCODE[i], ENCODED_CHARS[i]);
            }
            ++i;
        }
        return url;
    }

    public static String fastDecode(String url) {
        int i = 0;
        while (i < ENCODED_CHARS.length) {
            if (url.contains(ENCODED_CHARS[i])) {
                url = StringUtils.replaceAll(url, ENCODED_CHARS[i], CHARS_TO_ENCODE[i]);
            }
            ++i;
        }
        return url;
    }

    public static String getLink(String value) {
        if (!StringUtils.isSet(value)) {
            return value;
        }
        if (value.contains(":") || value.contains("/")) {
            return value;
        }
        if (value.contains(" ") || !value.contains(".")) {
            String language;
            StringBuilder searchUrl = new StringBuilder();
            searchUrl.append("http://www.google.com/search?q=");
            searchUrl.append(URIUtils.urlEncode(value));
            searchUrl.append("&safe=active");
            Locale locale = Locale.getDefault();
            if (locale != null && StringUtils.isSet(language = locale.getLanguage())) {
                searchUrl.append("&hl=").append(language);
            }
            return searchUrl.toString();
        }
        return value;
    }

    public static String ensureProtocol(String link) {
        if (link != null && !link.contains(PROTOCOL_IDENTIFIER)) {
            return HTTP + link;
        }
        return link;
    }

    public static String toManaged(String link) {
        if (StringUtils.isSet(link)) {
            return String.valueOf(link) + MANAGED_LINK_IDENTIFIER;
        }
        return link;
    }

    public static String toUnManaged(String link) {
        if (URIUtils.isManaged(link)) {
            if (link.endsWith(MANAGED_LINK_IDENTIFIER)) {
                return link.substring(0, link.length() - MANAGED_LINK_IDENTIFIER.length());
            }
            if (link.endsWith(MANAGED_LINK_ANCHOR)) {
                return link.substring(0, link.length() - MANAGED_LINK_ANCHOR.length());
            }
        }
        return link;
    }

    public static boolean isManaged(String link) {
        return StringUtils.isSet(link) && link.endsWith(MANAGED_LINK_ANCHOR);
    }

    public static String safeGetHost(URI uri) {
        String host = uri.getHost();
        if (host != null) {
            return host;
        }
        try {
            org.apache.commons.httpclient.URI altUri = new org.apache.commons.httpclient.URI(uri.toString(), false);
            return altUri.getHost();
        }
        catch (URIException uRIException) {
            return null;
        }
    }

    public static URI toHTTP(URI uri) {
        if (uri == null) {
            return uri;
        }
        String scheme = uri.getScheme();
        if (HTTP_SCHEME.equals(scheme) || HTTPS_SCHEME.equals(scheme)) {
            return uri;
        }
        String newScheme = HTTP_SCHEME;
        if ("readers".equals(scheme)) {
            newScheme = HTTPS_SCHEME;
        }
        try {
            return new URI(newScheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri;
        }
    }

    public static String toHTTP(String str) {
        if (!StringUtils.isSet(str)) {
            return str;
        }
        if (str.startsWith(HTTP) || str.startsWith(HTTPS)) {
            return str;
        }
        try {
            return URIUtils.toHTTP(new URI(str)).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return str;
        }
    }
}

