/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumberTools;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NativeFSLockFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.search.Indexer;
import org.rssowl.core.internal.persist.search.Messages;
import org.rssowl.core.internal.persist.search.ModelSearchQueries;
import org.rssowl.core.internal.persist.search.NewsDocument;
import org.rssowl.core.internal.persist.search.SearchDocument;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.IndexListener;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.persist.service.ProfileLockedException;
import org.rssowl.core.util.SearchHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSearchImpl
implements IModelSearch {
    private static final INews.State[] NEWS_STATES = INews.State.values();
    private static final int INDEX_CHUNK_SIZE = 500;
    static final int MAX_CLAUSE_COUNT = 65536;
    private volatile IndexSearcher fSearcher;
    private volatile Indexer fIndexer;
    private volatile Directory fDirectory;
    private final List<IndexListener> fIndexListeners = new CopyOnWriteArrayList<IndexListener>();
    private final Map<IndexSearcher, AtomicInteger> fSearchers = new ConcurrentHashMap<IndexSearcher, AtomicInteger>(3, 0.75f, 1);

    @Override
    public void startup() throws PersistenceException {
        this.startup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup(boolean clearIndex) throws PersistenceException {
        try {
            Object path;
            if (this.fDirectory == null) {
                path = Activator.getDefault().getStateLocation().toOSString();
                if (clearIndex) {
                    File directory = new File((String)path);
                    File[] indexFiles = directory.listFiles((FilenameFilter)new IndexFileNameFilter());
                    try {
                        File[] fileArray = indexFiles;
                        int n = indexFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                }
                NativeFSLockFactory lockFactory = new NativeFSLockFactory((String)path);
                this.fDirectory = FSDirectory.getDirectory((String)path, (LockFactory)lockFactory);
            }
            if (this.fIndexer == null) {
                this.fIndexer = new Indexer(this, this.fDirectory);
            }
            this.fIndexer.initIfNecessary(clearIndex);
            path = this;
            synchronized (path) {
                if (this.fSearcher == null) {
                    this.fSearcher = this.createIndexSearcher();
                }
            }
        }
        catch (LockObtainFailedException e) {
            throw new ProfileLockedException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean emergency) throws PersistenceException {
        try {
            if (this.fIndexer != null) {
                this.fIndexer.shutdown(emergency);
            }
            if (emergency) {
                return;
            }
            ModelSearchImpl modelSearchImpl = this;
            synchronized (modelSearchImpl) {
                for (Map.Entry<IndexSearcher, AtomicInteger> mapEntry : this.fSearchers.entrySet()) {
                    if (mapEntry.getValue().get() != 0) continue;
                    this.dispose(mapEntry.getKey());
                }
                while (!this.fSearchers.isEmpty()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    for (Map.Entry<IndexSearcher, AtomicInteger> mapEntry : this.fSearchers.entrySet()) {
                        if (mapEntry.getValue().get() != 0) continue;
                        this.dispose(mapEntry.getKey());
                    }
                }
                this.fSearcher = null;
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    private BooleanClause createIsCopyTermQuery(boolean copy) {
        String field = String.valueOf(20);
        TermQuery termQuery = new TermQuery(new Term(field, NumberTools.longToString((long)0L)));
        BooleanClause.Occur occur = copy ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST;
        return new BooleanClause((Query)termQuery, occur);
    }

    public Map<IGuid, List<NewsReference>> searchNewsByGuids(List<IGuid> guids, boolean copy, IProgressMonitor monitor) {
        HashMap<IGuid, List<NewsReference>> linkToRefs = new HashMap<IGuid, List<NewsReference>>(guids.size());
        IndexSearcher currentSearcher = this.getCurrentSearcher();
        try {
            for (IGuid guid : guids) {
                if (monitor.isCanceled()) {
                    HashMap<IGuid, List<NewsReference>> hashMap = linkToRefs;
                    return hashMap;
                }
                BooleanQuery query = this.createGuidQuery(guid, copy);
                List<NewsReference> newsRefs = this.simpleSearch(currentSearcher, (Query)query);
                if (newsRefs.isEmpty()) continue;
                linkToRefs.put(guid, newsRefs);
            }
            HashMap<IGuid, List<NewsReference>> hashMap = linkToRefs;
            return hashMap;
        }
        finally {
            this.disposeIfNecessary(currentSearcher);
        }
    }

    public Map<URI, List<NewsReference>> searchNewsByLinks(List<URI> links, boolean copy, IProgressMonitor monitor) {
        HashMap<URI, List<NewsReference>> linkToRefs = new HashMap<URI, List<NewsReference>>(links.size());
        IndexSearcher currentSearcher = this.getCurrentSearcher();
        try {
            for (URI link : links) {
                if (monitor.isCanceled()) {
                    HashMap<URI, List<NewsReference>> hashMap = linkToRefs;
                    return hashMap;
                }
                BooleanQuery query = this.createNewsByLinkBooleanQuery(link, copy);
                List<NewsReference> newsRefs = this.simpleSearch(currentSearcher, (Query)query);
                if (newsRefs.isEmpty()) continue;
                linkToRefs.put(link, newsRefs);
            }
            HashMap<URI, List<NewsReference>> hashMap = linkToRefs;
            return hashMap;
        }
        finally {
            this.disposeIfNecessary(currentSearcher);
        }
    }

    public List<NewsReference> searchNewsByLink(URI link, boolean copy) {
        Assert.isNotNull((Object)link, (String)"link");
        BooleanQuery query = this.createNewsByLinkBooleanQuery(link, copy);
        return this.simpleSearch((Query)query);
    }

    private BooleanQuery createNewsByLinkBooleanQuery(URI link, boolean copy) {
        BooleanQuery query = new BooleanQuery(true);
        query.add((Query)new TermQuery(new Term(String.valueOf(1), link.toString().toLowerCase())), BooleanClause.Occur.MUST);
        query.add(this.createIsCopyTermQuery(copy));
        return query;
    }

    public List<NewsReference> searchNewsByGuid(IGuid guid, boolean copy) {
        Assert.isNotNull((Object)guid, (String)"guid");
        BooleanQuery query = this.createGuidQuery(guid, copy);
        return this.simpleSearch((Query)query);
    }

    private BooleanQuery createGuidQuery(IGuid guid, boolean copy) {
        BooleanQuery query = new BooleanQuery(true);
        query.add((Query)new TermQuery(new Term(String.valueOf(5), guid.getValue().toLowerCase())), BooleanClause.Occur.MUST);
        query.add(this.createIsCopyTermQuery(copy));
        return query;
    }

    private List<NewsReference> simpleSearch(Query query) {
        IndexSearcher currentSearcher = this.getCurrentSearcher();
        try {
            List<NewsReference> newsRefs;
            List<NewsReference> list = newsRefs = this.simpleSearch(currentSearcher, query);
            return list;
        }
        finally {
            this.disposeIfNecessary(currentSearcher);
        }
    }

    private List<NewsReference> simpleSearch(IndexSearcher currentSearcher, Query query) {
        ArrayList<NewsReference> resultList = new ArrayList<NewsReference>(2);
        try {
            currentSearcher.search(query, (HitCollector)new SimpleHitCollector(currentSearcher, resultList));
            return resultList;
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private void disposeIfNecessary(IndexSearcher currentSearcher) {
        AtomicInteger referenceCount = this.fSearchers.get(currentSearcher);
        if (referenceCount.decrementAndGet() == 0 && this.fSearcher != currentSearcher) {
            try {
                this.dispose(currentSearcher);
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
    }

    @Override
    public List<SearchHit<NewsReference>> searchNews(ISearch search) throws PersistenceException {
        return this.searchNews(search.getSearchConditions(), search.matchAllConditions());
    }

    @Override
    public List<SearchHit<NewsReference>> searchNews(Collection<ISearchCondition> conditions, boolean matchAllConditions) throws PersistenceException {
        return this.searchNews(conditions, null, matchAllConditions);
    }

    @Override
    public List<SearchHit<NewsReference>> searchNews(Collection<ISearchCondition> conditions, ISearchCondition scope, boolean matchAllConditions) throws PersistenceException {
        try {
            return this.doSearchNews(conditions, scope, matchAllConditions);
        }
        catch (BooleanQuery.TooManyClauses e) {
            if (BooleanQuery.getMaxClauseCount() != 65536) {
                BooleanQuery.setMaxClauseCount((int)65536);
                return this.doSearchNews(conditions, scope, matchAllConditions);
            }
            throw new PersistenceException(Messages.ModelSearchImpl_ERROR_WILDCARDS, e);
        }
    }

    private List<SearchHit<NewsReference>> doSearchNews(Collection<ISearchCondition> conditions, ISearchCondition scope, boolean matchAllConditions) throws PersistenceException {
        Query bQuery = ModelSearchQueries.createQuery(conditions, scope, matchAllConditions);
        final IndexSearcher currentSearcher = this.getCurrentSearcher();
        final ArrayList<SearchHit<NewsReference>> resultList = new ArrayList<SearchHit<NewsReference>>();
        final HashMap searchResultNewsIds = new HashMap();
        HitCollector collector = new HitCollector(){

            public void collect(int doc, float score) {
                try {
                    Document document = currentSearcher.doc(doc);
                    long newsId = Long.parseLong(document.get(SearchDocument.ENTITY_ID_TEXT));
                    INews.State newsState = NEWS_STATES[Integer.parseInt(document.get(NewsDocument.STATE_ID_TEXT))];
                    HashMap<Integer, INews.State> data = new HashMap<Integer, INews.State>(1);
                    data.put(14, newsState);
                    if (!searchResultNewsIds.containsKey(newsId)) {
                        resultList.add(new SearchHit<NewsReference>(new NewsReference(newsId), score, data));
                        searchResultNewsIds.put(newsId, newsId);
                    }
                }
                catch (IOException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
            }
        };
        try {
            currentSearcher.search(bQuery, collector);
            ArrayList<SearchHit<NewsReference>> arrayList = resultList;
            this.disposeIfNecessary(currentSearcher);
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                this.disposeIfNecessary(currentSearcher);
                throw throwable;
            }
            catch (IOException e) {
                throw new PersistenceException(Messages.ModelSearchImpl_ERROR_SEARCH, e);
            }
        }
    }

    private IndexSearcher createIndexSearcher() throws CorruptIndexException, IOException {
        IndexSearcher searcher = new IndexSearcher(IndexReader.open((Directory)this.fDirectory));
        this.fSearchers.put(searcher, new AtomicInteger(0));
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher getCurrentSearcher() throws PersistenceException {
        try {
            boolean flushed = this.fIndexer.flushIfNecessary();
            IndexSearcher currentSearcher = this.fSearcher;
            ModelSearchImpl modelSearchImpl = this;
            synchronized (modelSearchImpl) {
                IndexReader currentReader;
                IndexReader newReader;
                if (flushed && currentSearcher == this.fSearcher && (newReader = (currentReader = this.fSearcher.getIndexReader()).reopen()) != currentReader) {
                    IndexSearcher newSearcher = new IndexSearcher(newReader);
                    this.fSearchers.put(newSearcher, new AtomicInteger(1));
                    this.fSearcher = newSearcher;
                    AtomicInteger referenceCount = this.fSearchers.get(currentSearcher);
                    if (referenceCount != null && referenceCount.get() == 0) {
                        this.dispose(currentSearcher);
                    }
                    return this.fSearcher;
                }
                this.fSearchers.get(this.fSearcher).incrementAndGet();
                return this.fSearcher;
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    private void dispose(IndexSearcher searcher) throws IOException {
        this.fSearchers.remove(searcher);
        searcher.close();
        searcher.getIndexReader().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearIndex() throws PersistenceException {
        try {
            ModelSearchImpl modelSearchImpl = this;
            synchronized (modelSearchImpl) {
                AtomicInteger refCount;
                IndexSearcher currentSearcher = this.fSearcher;
                this.fIndexer.clearIndex();
                this.fSearcher = this.createIndexSearcher();
                while ((refCount = this.fSearchers.get(currentSearcher)) != null) {
                    if (refCount.get() == 0) {
                        this.dispose(currentSearcher);
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new PersistenceException("Failed to close IndexSearcher: " + this.fSearcher);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public void addIndexListener(IndexListener listener) {
        this.fIndexListeners.add(listener);
    }

    @Override
    public void removeIndexListener(IndexListener listener) {
        this.fIndexListeners.remove(listener);
    }

    @Override
    public void optimize() {
        try {
            this.fIndexer.optimize();
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    void notifyIndexUpdated(int docCount) {
        for (IndexListener listener : this.fIndexListeners) {
            listener.indexUpdated(docCount);
        }
    }

    @Override
    public void reIndexOnNextStartup() throws PersistenceException {
        try {
            DBManager.getDefault().getReIndexFile().createNewFile();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void reindexAll(IProgressMonitor monitor) throws PersistenceException {
        Collection newsList = InternalOwl.getDefault().getPersistenceService().getDAOService().getNewsDAO().loadAll();
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(Messages.ModelSearchImpl_PROGRESS_WAIT, newsList.size());
        monitor.subTask(Messages.ModelSearchImpl_REINDEX_SEARCH_INDEX);
        this.reindexInChunks(newsList.iterator(), monitor);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexInChunks(Iterator<INews> iterator, IProgressMonitor monitor) {
        boolean isFirstRun = true;
        if (monitor.isCanceled()) {
            return;
        }
        this.startup(true);
        Indexer indexer = this.fIndexer;
        synchronized (indexer) {
            boolean userCanceled = false;
            this.clearIndex();
            while (iterator.hasNext()) {
                ArrayList<INews> newsChunkToBeIndexed = new ArrayList<INews>(500);
                int i = 0;
                while (i < 500 && iterator.hasNext()) {
                    newsChunkToBeIndexed.add(iterator.next());
                    ++i;
                }
                if (newsChunkToBeIndexed.isEmpty()) break;
                if (!isFirstRun) {
                    this.fIndexer.flushIfNecessary();
                }
                for (INews newsitem : newsChunkToBeIndexed) {
                    if (!userCanceled && monitor.isCanceled()) {
                        monitor.setTaskName(Messages.ModelSearchImpl_WAIT_TASK_COMPLETION);
                        userCanceled = true;
                    }
                    ArrayList<INews> indexList = new ArrayList<INews>(1);
                    indexList.add(newsitem);
                    this.fIndexer.index(indexList, false, false);
                    monitor.worked(1);
                }
                isFirstRun = false;
            }
        }
        IndexSearcher currentSearcher = null;
        try {
            currentSearcher = this.getCurrentSearcher();
        }
        finally {
            if (currentSearcher != null) {
                this.disposeIfNecessary(currentSearcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(IProgressMonitor monitor) throws PersistenceException {
        List<NewsReference> results = this.simpleSearch((Query)new MatchAllDocsQuery());
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(Messages.ModelSearchImpl_PROGRESS_WAIT, results.size());
        monitor.subTask(Messages.ModelSearchImpl_CLEANUP_SEARCH_INDEX);
        HashSet<NewsReference> newsToDelete = new HashSet<NewsReference>();
        INewsDAO newsDao = InternalOwl.getDefault().getPersistenceService().getDAOService().getNewsDAO();
        for (NewsReference newsRef : results) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!newsDao.exists(newsRef.getId())) {
                newsToDelete.add(newsRef);
            } else {
                INews resolvedNews = (INews)newsDao.load(newsRef.getId());
                if (resolvedNews == null || !resolvedNews.isVisible()) {
                    newsToDelete.add(newsRef);
                }
            }
            monitor.worked(1);
        }
        Indexer indexer = this.fIndexer;
        synchronized (indexer) {
            try {
                this.fIndexer.removeFromIndex(newsToDelete);
            }
            catch (IOException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        }
        monitor.done();
    }

    @Override
    public void cleanUpOnNextStartup() throws PersistenceException {
        try {
            DBManager.getDefault().getCleanUpIndexFile().createNewFile();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SimpleHitCollector
    extends HitCollector {
        private final IndexSearcher fSearcher;
        private final List<NewsReference> fResultList;
        private final Map<Long, Long> fSearchResultNewsIds = new HashMap<Long, Long>();

        SimpleHitCollector(IndexSearcher searcher, List<NewsReference> resultList) {
            this.fSearcher = searcher;
            this.fResultList = resultList;
        }

        public void collect(int doc, float score) {
            try {
                Document document = this.fSearcher.doc(doc);
                long newsId = Long.parseLong(document.get(SearchDocument.ENTITY_ID_TEXT));
                if (!this.fSearchResultNewsIds.containsKey(newsId)) {
                    this.fResultList.add(new NewsReference(newsId));
                    this.fSearchResultNewsIds.put(newsId, newsId);
                }
            }
            catch (IOException e) {
                Activator.safeLogError(e.getMessage(), e);
            }
        }
    }
}

