/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.ObjectMarshaller;

public final class ObjectHeader {
    private final ClassMetadata _yapClass;
    public final MarshallerFamily _marshallerFamily;
    public final ObjectHeaderAttributes _headerAttributes;

    public ObjectHeader(ObjectContainerBase objectContainerBase, Buffer buffer) {
        this(objectContainerBase, null, buffer);
    }

    public ObjectHeader(ClassMetadata classMetadata, Buffer buffer) {
        this(null, classMetadata, buffer);
    }

    public ObjectHeader(StatefulBuffer statefulBuffer) {
        this(statefulBuffer.getStream(), (Buffer)statefulBuffer);
    }

    public ObjectHeader(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, Buffer buffer) {
        int n = buffer.readInt();
        this._marshallerFamily = this.readMarshallerFamily(buffer, n);
        n = this.normalizeID(n);
        this._yapClass = classMetadata != null ? classMetadata : objectContainerBase.getYapClass(n);
        this._headerAttributes = ObjectHeader.readAttributes(this._marshallerFamily, buffer);
    }

    public static ObjectHeader defrag(ReaderPair readerPair) {
        Buffer buffer = readerPair.source();
        Buffer buffer2 = readerPair.target();
        ObjectHeader objectHeader = new ObjectHeader(readerPair.context().systemTrans().stream(), null, buffer);
        int n = readerPair.mapping().mappedID(objectHeader.yapClass().getID());
        objectHeader._marshallerFamily._object.writeObjectClassID(buffer2, n);
        objectHeader._marshallerFamily._object.skipMarshallerInfo(buffer2);
        ObjectHeader.readAttributes(objectHeader._marshallerFamily, buffer2);
        return objectHeader;
    }

    public ObjectMarshaller objectMarshaller() {
        return this._marshallerFamily._object;
    }

    private MarshallerFamily readMarshallerFamily(Buffer buffer, int n) {
        boolean bl = this.marshallerAware(n);
        int n2 = 0;
        if (bl) {
            n2 = buffer.readByte();
        }
        MarshallerFamily marshallerFamily = MarshallerFamily.version(n2);
        return marshallerFamily;
    }

    private static ObjectHeaderAttributes readAttributes(MarshallerFamily marshallerFamily, Buffer buffer) {
        return marshallerFamily._object.readHeaderAttributes(buffer);
    }

    private boolean marshallerAware(int n) {
        return n < 0;
    }

    private int normalizeID(int n) {
        return n < 0 ? -n : n;
    }

    public ClassMetadata yapClass() {
        return this._yapClass;
    }
}

