/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.dialog.DialogProgrammOrdnerOeffnen;
import mediathek.tool.ListenerMediathekView;

public class UrlHyperlinkAction
extends AbstractAction {
    String url;
    JFrame jFrameParent;

    public UrlHyperlinkAction(JFrame jjFrameParent, String uurl) throws URISyntaxException {
        this.url = uurl;
        this.jFrameParent = jjFrameParent;
        super.putValue("Name", uurl);
        super.putValue("ShortDescription", this.url);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            UrlHyperlinkAction.urlOeffnen(this.jFrameParent, e.getActionCommand());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static void urlOeffnen(JFrame paFrame, String url) throws URISyntaxException {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            try {
                if (d.isSupported(Desktop.Action.BROWSE)) {
                    d.browse(new URI(url));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String programm = "";
                if (Daten.mVConfig.get("Programm-Url-oeffnen").equals("")) {
                    String text = "\n Der Browser zum Anzeigen der URL wird nicht gefunden.\n Browser selbst ausw\u00e4hlen.";
                    DialogProgrammOrdnerOeffnen dialog = new DialogProgrammOrdnerOeffnen(paFrame, true, "", "Browser suchen", text);
                    dialog.setVisible(true);
                    if (dialog.ok) {
                        programm = dialog.ziel;
                    }
                } else {
                    programm = Daten.mVConfig.get("Programm-Url-oeffnen");
                }
                Runtime.getRuntime().exec(programm + " " + url);
                Daten.mVConfig.add("Programm-Url-oeffnen", programm);
                ListenerMediathekView.notify(19, UrlHyperlinkAction.class.getSimpleName());
            }
            catch (Exception ex) {
                Daten.mVConfig.add("Programm-Url-oeffnen", "");
                Log.fehlerMeldung(316497658, ex, "URL \u00f6ffnen: " + url);
            }
        }
    }
}

