/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataHandler;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenMediaDB;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFont;
import mediathek.tool.TModel;
import mediathek.tool.TModelAbo;
import mediathek.tool.TModelDownload;
import mediathek.tool.TModelFilm;
import msearch.daten.DatenFilm;

public final class MVTable
extends JTable {
    public static final int TABELLE_STANDARD = -1;
    public static final int TABELLE_TAB_FILME = 0;
    public static final int TABELLE_TAB_DOWNLOADS = 1;
    public static final int TABELLE_TAB_ABOS = 2;
    public static final int TABELLE_TAB_PSET = 3;
    public static final int TABELLE_TAB_PROG = 4;
    public static final int TABELLE_MEDIA_DB = 5;
    public static final String FELDTRENNER = "|";
    public static final String SORT_ASCENDING = "ASCENDING";
    public static final String SORT_DESCENDING = "DESCENDING";
    public boolean iconAnzeigen = false;
    public boolean iconKlein = false;
    private final int[] breite;
    private final int[] reihe;
    private String nrDatenSystem = "";
    private int tabelle;
    private int maxSpalten;
    private List<? extends RowSorter.SortKey> listeSortKeys = null;
    private int indexSpalte = 0;
    private int[] selRows;
    private String[] indexWertSelection = null;
    private int[] selIndexes = null;
    private boolean[] spaltenAnzeigen;
    private String iconAnzeigenStr = "";
    private String iconKleinStr = "";

    public MVTable(int tabelle) {
        this.tabelle = tabelle;
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
        switch (tabelle) {
            case 0: {
                Object[] spaltenTitel = DatenFilm.COLUMN_NAMES;
                this.maxSpalten = 26;
                this.spaltenAnzeigen = this.getSpaltenEinAus(DatenFilm.spaltenAnzeigen, 26);
                this.indexSpalte = 0;
                this.nrDatenSystem = "Eigenschaften-Tabellen-Filme";
                this.iconAnzeigenStr = "system-tab-filme-icon-anzeigen";
                this.iconKleinStr = "system-tab-filme-icon-klein";
                this.setModel(new TModelFilm(new Object[0][], spaltenTitel));
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
                break;
            }
            case 1: {
                Object[] spaltenTitel = DatenDownload.COLUMN_NAMES;
                this.maxSpalten = 38;
                this.spaltenAnzeigen = this.getSpaltenEinAus(DatenDownload.spaltenAnzeigen, 38);
                this.indexSpalte = 0;
                this.nrDatenSystem = "Eigenschaften-Tabellen-Downloads";
                this.iconAnzeigenStr = "system-tab-download-icon-anzeigen";
                this.iconKleinStr = "system-tab-download-icon-klein";
                this.setDragEnabled(true);
                this.setDropMode(DropMode.INSERT_ROWS);
                this.setTransferHandler(new TableRowTransferHandlerDownload(this));
                this.setModel(new TModelDownload(new Object[0][], spaltenTitel));
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
                break;
            }
            case 2: {
                Object[] spaltenTitel = DatenAbo.COLUMN_NAMES;
                this.maxSpalten = 12;
                this.spaltenAnzeigen = this.getSpaltenEinAus(DatenAbo.spaltenAnzeigen, 12);
                this.indexSpalte = 0;
                this.nrDatenSystem = "Eigenschaften-Tabellen-Abos";
                this.iconAnzeigenStr = "system-tab-abo-icon-anzeigen";
                this.iconKleinStr = "system-tab-abo-icon-klein";
                this.setModel(new TModelAbo(new Object[0][], spaltenTitel));
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
                break;
            }
            case 3: {
                Object[] spaltenTitel = DatenPset.COLUMN_NAMES;
                this.maxSpalten = 22;
                this.spaltenAnzeigen = this.getSpaltenEinAus(DatenPset.spaltenAnzeigen, 22);
                this.indexSpalte = 0;
                this.nrDatenSystem = "";
                this.setModel(new TModel(new Object[0][], spaltenTitel));
                this.setRowSorter(null);
                this.setAutoCreateRowSorter(false);
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
                break;
            }
            case 4: {
                Object[] spaltenTitel = DatenProg.COLUMN_NAMES;
                this.maxSpalten = 8;
                this.spaltenAnzeigen = this.getSpaltenEinAus(DatenProg.spaltenAnzeigen, 8);
                this.indexSpalte = 0;
                this.nrDatenSystem = "";
                this.setModel(new TModel(new Object[0][], spaltenTitel));
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
                break;
            }
            case 5: {
                Object[] spaltenTitel = DatenMediaDB.COLUMN_NAMES;
                this.maxSpalten = 3;
                this.spaltenAnzeigen = this.getSpaltenEinAus(new boolean[3], 3);
                this.indexSpalte = 0;
                this.nrDatenSystem = "Eigenschaften-Tabellen-MediaDB";
                this.setModel(new TModel(new Object[0][], spaltenTitel));
                this.getTableHeader().addMouseListener(new WidthAdjuster(this));
            }
        }
        this.breite = this.getArray(this.maxSpalten);
        this.reihe = this.getArray(this.maxSpalten);
        if (!this.iconAnzeigenStr.isEmpty()) {
            this.iconAnzeigen = Boolean.parseBoolean(Daten.mVConfig.get(this.iconAnzeigenStr));
        }
        if (!this.iconKleinStr.isEmpty()) {
            this.iconKlein = Boolean.parseBoolean(Daten.mVConfig.get(this.iconKleinStr));
        }
        this.setHeight();
        ListenerMediathekView.addListener(new ListenerMediathekView(36, MVTable.class.getSimpleName()){

            @Override
            public void ping() {
                MVTable.this.setHeight();
            }
        });
    }

    public void setHeight() {
        if (!this.iconAnzeigen) {
            if (MVFont.fontSize < 15) {
                this.setRowHeight(18);
            } else {
                this.setRowHeight(MVFont.fontSize + MVFont.fontSize / 3);
            }
        } else if (this.iconKlein) {
            if (MVFont.fontSize < 18) {
                this.setRowHeight(20);
            } else {
                this.setRowHeight(MVFont.fontSize + MVFont.fontSize / 3);
            }
        } else if (MVFont.fontSize < 30) {
            this.setRowHeight(36);
        } else {
            this.setRowHeight(MVFont.fontSize + MVFont.fontSize / 3);
        }
    }

    public void reorder(int index, int[] rowFrom) {
        this.getSelected();
        TModelDownload tModel = (TModelDownload)this.getModel();
        for (int i = 0; i < this.getRowCount(); ++i) {
            DatenDownload d = (DatenDownload)tModel.getValueAt(this.convertRowIndexToModel(i), 37);
            if (d == null) continue;
            Daten.listeDownloads.remove(d);
            Daten.listeDownloads.add(d);
        }
        LinkedList<DatenDownload> liste = new LinkedList<DatenDownload>();
        for (int row : rowFrom) {
            if (index > row) {
                --index;
            }
            DatenDownload d = (DatenDownload)tModel.getValueAt(this.convertRowIndexToModel(row), 37);
            liste.add(d);
            Daten.listeDownloads.remove(d);
        }
        Daten.listeDownloads.addAll(index, liste);
        this.getRowSorter().setSortKeys(null);
        this.setRowSorter(null);
        this.setAutoCreateRowSorter(true);
        this.setSelected();
        ListenerMediathekView.notify(29, MVTable.class.getSimpleName());
    }

    public void initTabelle() {
        try {
            if (this.nrDatenSystem.isEmpty()) {
                return;
            }
            String b = "";
            String r = "";
            String s = "";
            String upDown = "";
            boolean ok = false;
            if (!Daten.mVConfig.get(this.nrDatenSystem).equals("")) {
                RowSorter.SortKey sk;
                ok = true;
                int f1 = Daten.mVConfig.get(this.nrDatenSystem).indexOf(FELDTRENNER);
                if (f1 != -1) {
                    int f3;
                    b = Daten.mVConfig.get(this.nrDatenSystem).substring(0, f1);
                    int f2 = Daten.mVConfig.get(this.nrDatenSystem).indexOf(FELDTRENNER, f1 + 1);
                    if (f2 != -1) {
                        r = Daten.mVConfig.get(this.nrDatenSystem).substring(f1 + 1, f2);
                    }
                    if ((f3 = Daten.mVConfig.get(this.nrDatenSystem).indexOf(FELDTRENNER, f2 + 1)) != -1) {
                        s = Daten.mVConfig.get(this.nrDatenSystem).substring(f2 + 1, f3);
                        upDown = Daten.mVConfig.get(this.nrDatenSystem).substring(f3 + 1);
                    }
                }
                if (!this.arrLesen(b, this.breite)) {
                    ok = false;
                }
                if (!this.arrLesen(r, this.reihe)) {
                    ok = false;
                }
                if ((sk = this.sortKeyLesen(s, upDown)) != null) {
                    LinkedList<RowSorter.SortKey> listSortKeys_ = new LinkedList<RowSorter.SortKey>();
                    listSortKeys_.add(sk);
                    this.getRowSorter().setSortKeys(listSortKeys_);
                }
            }
            if (ok) {
                this.setSpaltenEinAus(this.breite, this.spaltenAnzeigen);
                this.setSpalten();
            } else {
                this.resetTabelle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean anzeigen(int i, boolean[] spaltenAnzeigen) {
        return spaltenAnzeigen[i];
    }

    private void setSpaltenEinAus(int[] nr, boolean[] spaltenAnzeigen) {
        for (int i = 0; i < spaltenAnzeigen.length; ++i) {
            spaltenAnzeigen[i] = nr[i] > 0;
        }
    }

    private boolean[] getSpaltenEinAus(boolean[] spaltenAnzeigen, int MAX_ELEM) {
        for (int i = 0; i < MAX_ELEM; ++i) {
            spaltenAnzeigen[i] = true;
        }
        return spaltenAnzeigen;
    }

    public void fireTableDataChanged(boolean setSpalten) {
        if (setSpalten) {
            this.getSelected();
        }
        ((TModel)this.getModel()).fireTableDataChanged();
        if (setSpalten) {
            this.setSelected();
        }
    }

    public void requestFocusSelelct(JScrollPane jScrollPane) {
        this.requestFocus();
        if (this.getRowCount() > 0) {
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            int firstSelectedRow = this.getSelectedRow();
            Rectangle cellLocation = this.getCellRect(firstSelectedRow, 0, false);
            jScrollPane.getVerticalScrollBar().setValue(cellLocation.y);
        }
    }

    public void requestFocusSelelct(JScrollPane jScrollPane, int zeile) {
        this.requestFocus();
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(zeile, zeile);
            int firstSelectedRow = this.getSelectedRow();
            Rectangle cellLocation = this.getCellRect(firstSelectedRow, 0, false);
            jScrollPane.getVerticalScrollBar().setValue(cellLocation.y);
        }
    }

    public void setSelRow(int i) {
        if (this.getRowCount() > 0) {
            if (i < 0) {
                i = 0;
            }
            if (i >= this.getRowCount()) {
                i = this.getRowCount() - 1;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection(i);
        }
    }

    public void scrollToSelection() {
        if (this.getRowCount() > 0) {
            int i = this.getSelectedRow();
            if (i < 0) {
                i = 0;
                this.setRowSelectionInterval(i, i);
            }
            if (i >= this.getRowCount()) {
                i = this.getRowCount() - 1;
            }
            this.scrollToSelection(i);
        }
    }

    private void scrollToSelection(int rowIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    public void getSelected() {
        int selRow = this.getSelectedRow();
        this.selRows = this.getSelectedRows();
        switch (this.tabelle) {
            case 0: 
            case 1: 
            case 2: {
                if (selRow >= 0) {
                    this.selIndexes = new int[this.selRows.length];
                    int k = 0;
                    for (int i : this.selRows) {
                        this.selIndexes[k++] = (Integer)this.getModel().getValueAt(this.convertRowIndexToModel(i), this.indexSpalte);
                    }
                    break;
                }
                this.selIndexes = null;
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (this.selRows == null || this.selRows.length <= 0) break;
                this.indexWertSelection = new String[this.selRows.length];
                for (int i = 0; i < this.selRows.length; ++i) {
                    this.indexWertSelection[i] = this.getModel().getValueAt(this.convertRowIndexToModel(this.selRows[i]), this.indexSpalte).toString();
                }
            }
        }
    }

    private void setSelected() {
        switch (this.tabelle) {
            case 0: 
            case 1: 
            case 2: {
                if (this.selIndexes != null) {
                    this.selectionModel.setValueIsAdjusting(true);
                    TModel tModel = (TModel)this.getModel();
                    for (int i : this.selIndexes) {
                        int r = tModel.getIdxRow(i);
                        if (r < 0) continue;
                        r = this.convertRowIndexToView(r);
                        this.addRowSelectionInterval(r, r);
                    }
                    this.selectionModel.setValueIsAdjusting(false);
                }
                this.indexWertSelection = null;
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (this.selRows == null || this.selRows.length <= 0) break;
                this.selectionModel.setValueIsAdjusting(true);
                for (int selectedRow : this.selRows) {
                    if (selectedRow >= this.getRowCount()) continue;
                    this.addRowSelectionInterval(selectedRow, selectedRow);
                }
                this.selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public void spaltenEinAus() {
        int i;
        this.getSpalten();
        for (i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            if (!this.anzeigen(i, this.spaltenAnzeigen)) {
                this.breite[i] = 0;
                continue;
            }
            if (this.breite[i] != 0) continue;
            this.breite[i] = 100;
        }
        for (i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            if (this.breite[i] == 0) {
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(0);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(0);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(0);
                continue;
            }
            this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(10);
            this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(3000);
            this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(this.breite[i]);
        }
        this.validate();
    }

    public void getSpalten() {
        int i;
        this.getSelected();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        this.listeSortKeys = this.getRowSorter() != null ? this.getRowSorter().getSortKeys() : null;
    }

    public void setSpalten() {
        this.setSelected();
        try {
            int i;
            for (i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
                if (!this.anzeigen(i, this.spaltenAnzeigen)) {
                    this.breite[i] = 0;
                    continue;
                }
                if (this.breite[i] != 0) continue;
                this.breite[i] = 100;
            }
            for (i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
                if (this.breite[i] == 0) {
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(0);
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(0);
                    this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(0);
                    continue;
                }
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMinWidth(10);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setMaxWidth(3000);
                this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).setPreferredWidth(this.breite[i]);
            }
            for (i = 0; i < this.reihe.length && i < this.getColumnCount(); ++i) {
                this.getColumnModel().moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
            }
            if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
                this.getRowSorter().setSortKeys(this.listeSortKeys);
            }
            this.validate();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(965001463, ex);
        }
    }

    private void resetFilmeTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        if (i == 0) {
            this.breite[i] = 75;
        } else if (i == 3) {
            this.breite[i] = 300;
        } else if (i == 6 || i == 7 || i == 1 || i == 9 || i == 8 || i == 11) {
            this.breite[i] = 100;
        } else if (i == 12) {
            this.breite[i] = 500;
        } else if (i == 4 || i == 5) {
            this.breite[i] = 50;
        }
    }

    private void resetDownloadsTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        if (i == 0 || i == 1) {
            this.breite[i] = 75;
        } else if (i == 6 || i == 7 || i == 26 || i == 36 || i == 15 || i == 34 || i == 35 || i == 33) {
            this.breite[i] = 50;
        } else if (i == 5) {
            this.breite[i] = 250;
        } else if (i == 2 || i == 4) {
            this.breite[i] = 150;
        } else if (i == 12 || i == 13 || i == 11 || i == 10 || i == 3 || i == 8 || i == 9 || i == 14 || i == 16) {
            this.breite[i] = 100;
        }
    }

    private void resetAbosTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        if (i == 0 || i == 1) {
            this.breite[i] = 75;
        } else if (i == 10 || i == 3) {
            this.breite[i] = 100;
        }
    }

    public void resetTabelle() {
        block6: for (int i = 0; i < this.maxSpalten; ++i) {
            switch (this.tabelle) {
                case 0: {
                    this.resetFilmeTab(i);
                    continue block6;
                }
                case 1: {
                    this.resetDownloadsTab(i);
                    continue block6;
                }
                case 2: {
                    this.resetAbosTab(i);
                    continue block6;
                }
                case 5: {
                    this.reihe[i] = i;
                    this.breite[i] = 200;
                }
            }
        }
        this.listeSortKeys = null;
        this.getRowSorter().setSortKeys(null);
        this.setRowSorter(null);
        this.setAutoCreateRowSorter(true);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite, this.spaltenAnzeigen);
        this.setSpalten();
    }

    private void spaltenAusschaltenFilme(int i) {
        if (i == 10 || i == 13 || i == 23 || i == 16 || i == 17 || i == 20 || i == 21 || i == 18 || i == 19 || i == 24 || i == 22 || i == 25) {
            this.breite[i] = 0;
        }
    }

    private void spaltenAusschaltenDownloads(int i) {
        if (i == 17 || i == 20 || i == 21 || i == 23 || i == 24 || i == 25 || i == 26 || i == 36 || i == 27 || i == 28 || i == 30 || i == 31 || i == 32 || i == 18 || i == 37 || i == 34 || i == 33 || i == 35 || i == 15) {
            this.breite[i] = 0;
        }
    }

    private void spaltenAusschalten() {
        block4: for (int i = 0; i < this.maxSpalten; ++i) {
            switch (this.tabelle) {
                case 0: {
                    this.spaltenAusschaltenFilme(i);
                    continue block4;
                }
                case 1: {
                    this.spaltenAusschaltenDownloads(i);
                    continue block4;
                }
            }
        }
    }

    public void tabelleNachDatenSchreiben() {
        int i;
        if (this.tabelle == -1) {
            return;
        }
        String s = "";
        String upDown = "";
        int[] reihe_ = new int[this.maxSpalten];
        int[] breite_ = new int[this.maxSpalten];
        for (i = 0; i < reihe_.length && i < this.getModel().getColumnCount(); ++i) {
            reihe_[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < breite_.length && i < this.getModel().getColumnCount(); ++i) {
            breite_[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        String b = Integer.toString(breite_[0]);
        String r = Integer.toString(reihe_[0]);
        for (i = 1; i < this.breite.length; ++i) {
            b = b + "," + Integer.toString(breite_[i]);
            r = r + "," + Integer.toString(reihe_[i]);
        }
        this.listeSortKeys = this.getRowSorter().getSortKeys();
        if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
            RowSorter.SortKey sk = this.listeSortKeys.get(0);
            s = String.valueOf(sk.getColumn());
            upDown = sk.getSortOrder().equals((Object)SortOrder.ASCENDING) ? SORT_ASCENDING : SORT_DESCENDING;
        }
        Daten.mVConfig.add(this.nrDatenSystem, b + FELDTRENNER + r + FELDTRENNER + s + FELDTRENNER + upDown);
        if (!this.iconAnzeigenStr.isEmpty()) {
            Daten.mVConfig.add(this.iconAnzeigenStr, String.valueOf(this.iconAnzeigen));
        }
        if (!this.iconKleinStr.isEmpty()) {
            Daten.mVConfig.add(this.iconKleinStr, String.valueOf(this.iconKlein));
        }
    }

    private int[] getArray(int anzahl) {
        int[] arr = new int[anzahl];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = -1;
        }
        return arr;
    }

    private boolean arrLesen(String s, int[] arr) {
        if (this.maxSpalten != this.countString(s)) {
            return false;
        }
        for (int i = 0; i < this.maxSpalten; ++i) {
            String sub;
            if (s.equals("")) continue;
            if (s.contains(",")) {
                sub = s.substring(0, s.indexOf(44));
                s = s.replaceFirst(sub + ",", "");
            } else {
                sub = s;
                s = "";
            }
            try {
                arr[i] = Integer.parseInt(sub);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private RowSorter.SortKey sortKeyLesen(String s, String upDown) {
        RowSorter.SortKey sk;
        try {
            int sp = Integer.parseInt(s);
            sk = upDown.equals(SORT_DESCENDING) ? new RowSorter.SortKey(sp, SortOrder.DESCENDING) : new RowSorter.SortKey(sp, SortOrder.ASCENDING);
        }
        catch (Exception ex) {
            return null;
        }
        return sk;
    }

    private int countString(String s) {
        int ret = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ',') continue;
            ++ret;
        }
        return ++ret;
    }

    public class WidthAdjuster
    extends MouseAdapter {
        private List<? extends RowSorter.SortKey> listeSortKeys = null;
        private final JTable table;
        private static final int EPSILON = 5;
        private final Cursor EAST = Cursor.getPredefinedCursor(11);
        private final Cursor WEST = Cursor.getPredefinedCursor(10);

        public WidthAdjuster(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            int c = this.getLeftColumn(evt.getPoint());
            if (evt.getClickCount() == 1) {
                this.listeSortKeys = this.table.getRowSorter() != null ? this.table.getRowSorter().getSortKeys() : null;
            }
            if (evt.getClickCount() > 1 && this.usingResizeCursor()) {
                this.resize(this.getLeftColumn(evt.getPoint()));
            }
        }

        private JTableHeader getTableHeader() {
            return this.table.getTableHeader();
        }

        private boolean usingResizeCursor() {
            Cursor cursor = this.getTableHeader().getCursor();
            return cursor.equals(this.EAST) || cursor.equals(this.WEST);
        }

        private int getLeftColumn(Point pt) {
            pt.x -= 5;
            return this.getTableHeader().columnAtPoint(pt);
        }

        private void resize(int col) {
            TableColumnModel tcm = this.table.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            TableCellRenderer tcr = tc.getHeaderRenderer();
            if (tcr == null) {
                tcr = this.table.getTableHeader().getDefaultRenderer();
            }
            Object obj = tc.getHeaderValue();
            Component comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, 0, 0);
            int maxWidth = comp.getPreferredSize().width;
            int ub = this.table.getRowCount();
            for (int i = 0; i != ub; ++i) {
                tcr = this.table.getCellRenderer(i, col);
                obj = this.table.getValueAt(i, col);
                comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, i, col);
                int w = comp.getPreferredSize().width;
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            tc.setPreferredWidth(maxWidth += 10);
            tc.setWidth(maxWidth);
            if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
                this.table.getRowSorter().setSortKeys(this.listeSortKeys);
            }
        }
    }

    class TableRowTransferHandlerDownload
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
        private JTable table = null;
        private int[] transferedRows = null;

        public TableRowTransferHandlerDownload(JTable table) {
            this.table = table;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            assert (c.equals(this.table));
            this.transferedRows = this.table.getSelectedRows();
            return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            try {
                boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
                this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
                return b;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            try {
                JTable target = (JTable)info.getComponent();
                JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                int index = dl.getRow();
                TModel tModel = (TModel)this.table.getModel();
                int max = tModel.getRowCount();
                if (index < 0 || index > max) {
                    index = max;
                }
                target.setCursor(Cursor.getPredefinedCursor(0));
                if (this.transferedRows != null) {
                    MVTable.this.reorder(index, this.transferedRows);
                    this.transferedRows = null;
                    return true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int act) {
            if (act == 2) {
                this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

