/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenMediaDB;
import mediathek.tool.Filter;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.TModelMediaDB;
import msearch.tool.MSLog;

public class MVMediaDB {
    private final ArrayList<DatenMediaDB> fileArray = new ArrayList();
    public final String FILE_TRENNER = "<>";
    private boolean makeIndex = false;
    private String[] suffix = new String[]{""};
    private boolean ohneSuffix = true;

    public synchronized int getSizeFileArray() {
        return this.fileArray.size();
    }

    public synchronized void getModelMediaDB(TModelMediaDB modelMediaDB) {
        modelMediaDB.setRowCount(0);
        for (DatenMediaDB s : this.fileArray) {
            modelMediaDB.addRow(s.getRow());
        }
    }

    public synchronized void searchFiles(TModelMediaDB modelFilm, String title) {
        block4: {
            modelFilm.setRowCount(0);
            if (this.makeIndex || title.isEmpty()) break block4;
            Pattern p = Filter.makePattern(title);
            if (p != null) {
                for (DatenMediaDB s : this.fileArray) {
                    if (!p.matcher(s.arr[0]).matches()) continue;
                    modelFilm.addRow(s.getRow());
                }
            } else {
                title = title.toLowerCase();
                for (DatenMediaDB s : this.fileArray) {
                    if (!s.arr[0].toLowerCase().contains(title)) continue;
                    modelFilm.addRow(s.getRow());
                }
            }
        }
    }

    public synchronized void makeIndex() {
        ListenerMediathekView.notify(41, MVMediaDB.class.getSimpleName());
        this.suffix = Daten.mVConfig.get("Media_DB_Suffix").split(",");
        for (int i = 0; i < this.suffix.length; ++i) {
            this.suffix[i] = this.suffix[i].toLowerCase();
            if (this.suffix[i].isEmpty() || this.suffix[i].startsWith(".")) continue;
            this.suffix[i] = "." + this.suffix[i];
        }
        this.ohneSuffix = Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_ohne-Suffix"));
        this.makeIndex = true;
        this.fileArray.clear();
        new Thread(new Index()).start();
    }

    private boolean checkSuffix(String[] str, String uurl) {
        if (str.length == 1 && str[0].isEmpty()) {
            return true;
        }
        boolean ret = true;
        String url = uurl.toLowerCase();
        for (String s : str) {
            if (this.ohneSuffix) {
                if (!url.endsWith(s)) continue;
                ret = false;
                break;
            }
            ret = false;
            if (!url.endsWith(s)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeFileArray(String datei) {
        OutputStreamWriter out = null;
        try {
            MSLog.systemMeldung((String)("MediaDB schreiben (" + this.fileArray.size() + " Dateien) :"));
            File file = new File(datei);
            File dir = new File(file.getParent());
            if (!dir.exists() && !dir.mkdirs()) {
                MSLog.fehlerMeldung((int)945120365, (String)("Kann den Pfad nicht anlegen: " + dir.toString()));
            }
            MSLog.systemMeldung((String)("   --> Start Schreiben nach: " + datei));
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(datei), "UTF-8");
            for (DatenMediaDB s : this.fileArray) {
                out.write(s.arr[0] + "\n");
            }
            MSLog.systemMeldung((String)"   --> geschrieben!");
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung((int)102035478, (Exception)ex, (String)("nach: " + datei));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private class Index
    implements Runnable {
        private Index() {
        }

        @Override
        public synchronized void run() {
            try {
                String db = Daten.mVConfig.get("Media_DB_Pfade-Medien");
                if (!db.isEmpty()) {
                    File f;
                    String error = "";
                    boolean more = false;
                    for (String s : db.split("<>")) {
                        f = new File(s);
                        if (f.canRead()) continue;
                        if (!error.isEmpty()) {
                            error = error + "\n";
                            more = true;
                        }
                        error = error + f.getPath();
                    }
                    if (!error.isEmpty()) {
                        MVMessageDialog.showMessageDialog(null, (more ? "Die Pfade der Mediensammlung k\u00f6nnen nicht gelesen werden:\n" : "Der Pfad der Mediensammlung kann nicht gelesen werden:\n") + error, "Fehler beim Erstellen der Mediensammlung", 0);
                    }
                    for (String s : db.split("<>")) {
                        f = new File(s);
                        this.searchFile(f);
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(120321254, ex);
            }
            MVMediaDB.this.makeIndex = false;
            ListenerMediathekView.notify(42, MVMediaDB.class.getSimpleName());
        }

        private void searchFile(File dir) {
            if (dir == null) {
                return;
            }
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.searchFile(file);
                        continue;
                    }
                    if (!MVMediaDB.this.checkSuffix(MVMediaDB.this.suffix, file.getName())) continue;
                    MVMediaDB.this.fileArray.add(new DatenMediaDB(file.getName(), file.getParent().intern(), file.length()));
                }
            }
        }
    }
}

