/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.security.CodeSource;
import java.util.ResourceBundle;
import mediathek.Main;
import mediathek.controller.Log;

public class MVFunctionSys {
    public static OperatingSystemType getOs() {
        OperatingSystemType os = OperatingSystemType.UNKNOWN;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            if (System.getenv("ProgramFiles(x86)") != null) {
                os = OperatingSystemType.WIN64;
            } else if (System.getenv("ProgramFiles") != null) {
                os = OperatingSystemType.WIN32;
            }
        } else if (SystemInfo.isLinux()) {
            os = OperatingSystemType.LINUX;
        } else if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
            os = OperatingSystemType.LINUX;
        } else if (SystemInfo.isMacOSX()) {
            os = OperatingSystemType.MAC;
        }
        return os;
    }

    public static String getOsString() {
        return MVFunctionSys.getOs().toString();
    }

    public static String getPathJar() {
        String s;
        String pFilePath = "pFile";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Main.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception cS) {
                // empty catch block
            }
        }
        if (!(s = propFile.getAbsolutePath().replace(pFilePath, "")).endsWith(File.separator)) {
            s = s + File.separator;
        }
        return s;
    }

    public static String pathProgramIcons() {
        return MVFunctionSys.getPathJar() + "Icons/Programm";
    }

    public static String pathSenderIcons() {
        return MVFunctionSys.getPathJar() + "Icons/Sender";
    }

    public static String getProgVersionString() {
        return "MediathekView 11  [Buildnummer: " + MVFunctionSys.getBuildNr() + "]";
    }

    public static String[] getJavaVersion() {
        String[] ret = new String[]{"Vendor: " + System.getProperty("java.vendor"), "VMname: " + System.getProperty("java.vm.name"), "Version: " + System.getProperty("java.version"), "Runtimeversion: " + System.getProperty("java.runtime.version")};
        return ret;
    }

    public static String getCompileDate() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            Log.fehlerMeldung(807293847, e);
        }
        return msg;
    }

    public static String getBuildNr() {
        String propToken = "BUILD";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            Log.fehlerMeldung(134679898, e);
        }
        return msg;
    }

    public static enum OperatingSystemType {
        UNKNOWN(""),
        WIN32("Windows"),
        WIN64("Windows"),
        LINUX("Linux"),
        MAC("Mac");

        private final String name;

        private OperatingSystemType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

