/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import mediathek.controller.starter.RuntimeExec;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialogEinstellungen.DialogImportPset;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVMessageDialog;

public class GuiFunktionenProgramme
extends GuiFunktionen {
    private static final ArrayList<String> winPfade = new ArrayList();

    private static void setWinProgPfade() {
        String[] PFAD;
        String pfad;
        if (System.getenv("ProgramFiles") != null && new File(pfad = System.getenv("ProgramFiles")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        if (System.getenv("ProgramFiles(x86)") != null && new File(pfad = System.getenv("ProgramFiles(x86)")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        for (String s : PFAD = new String[]{"C:\\Program Files", "C:\\Programme", "C:\\Program Files (x86)"}) {
            if (!new File(s).exists() || winPfade.contains(s)) continue;
            winPfade.add(s);
        }
    }

    public static String getMusterPfadVlc() {
        String PFAD_LINUX_VLC = "/usr/bin/vlc";
        String PFAD_FREEBSD = "/usr/local/bin/vlc";
        String PFAD_MAC_VLC = "/Applications/VLC.app/Contents/MacOS/VLC";
        String PFAD_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        String pfad = "";
        switch (GuiFunktionenProgramme.getOs()) {
            case LINUX: {
                if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                    pfad = "/usr/local/bin/vlc";
                    break;
                }
                pfad = "/usr/bin/vlc";
                break;
            }
            case MAC: {
                pfad = "/Applications/VLC.app/Contents/MacOS/VLC";
                break;
            }
            default: {
                String s;
                GuiFunktionenProgramme.setWinProgPfade();
                Iterator<String> iterator = winPfade.iterator();
                while (iterator.hasNext() && !new File(pfad = (s = iterator.next()) + "\\VideoLAN\\VLC\\vlc.exe").exists()) {
                }
                break;
            }
        }
        if (!new File(pfad).exists() && System.getenv("PATH_VLC") != null) {
            pfad = System.getenv("PATH_VLC");
        }
        if (!new File(pfad).exists()) {
            pfad = "";
        }
        return pfad;
    }

    public static String getMusterPfadFlv() {
        String pfad;
        String PFAD_LINUX_FLV = "/usr/bin/flvstreamer";
        String PFAD_FREEBSD = "/usr/local/bin/flvstreamer";
        String PFAD_MAC_FLV = "bin/flvstreamer_macosx_intel_32bit_latest";
        String PFAD_WINDOWS_FLV = "bin\\flvstreamer_win32_latest.exe";
        switch (GuiFunktionenProgramme.getOs()) {
            case LINUX: {
                if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                    pfad = "/usr/local/bin/flvstreamer";
                    break;
                }
                pfad = "/usr/bin/flvstreamer";
                break;
            }
            case MAC: {
                pfad = MVFunctionSys.getPathJar() + "bin/flvstreamer_macosx_intel_32bit_latest";
                break;
            }
            default: {
                pfad = "bin\\flvstreamer_win32_latest.exe";
            }
        }
        if (!new File(pfad).exists() && System.getenv("PATH_FLVSTREAMER") != null) {
            pfad = System.getenv("PATH_FLVSTREAMER");
        }
        if (!new File(pfad).exists()) {
            pfad = "";
        }
        return pfad;
    }

    public static String getMusterPfadFFmpeg() {
        String pfad;
        String PFAD_LINUX_FFMPEG = "/usr/bin/ffmpeg";
        String PFAD_FREEBSD_FFMPEG = "/usr/local/bin/ffmpeg";
        String PFAD_MAC_FFMPEG = "bin/ffmpeg";
        String PFAD_WINDOWS_FFMPEG = "bin\\ffmpeg.exe";
        switch (GuiFunktionenProgramme.getOs()) {
            case LINUX: {
                if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                    pfad = "/usr/local/bin/ffmpeg";
                    break;
                }
                pfad = "/usr/bin/ffmpeg";
                break;
            }
            case MAC: {
                pfad = MVFunctionSys.getPathJar() + "bin/ffmpeg";
                break;
            }
            default: {
                pfad = "bin\\ffmpeg.exe";
            }
        }
        if (!new File(pfad).exists() && System.getenv("PATH_FFMPEG") != null) {
            pfad = System.getenv("PATH_FFMPEG");
        }
        if (!new File(pfad).exists()) {
            pfad = "";
        }
        return pfad;
    }

    public static String getPfadScript() {
        String pfadScript;
        String PFAD_LINUX_SCRIPT = "bin/flv.sh";
        String PFAD_WINDOWS_SCRIPT = "bin\\flv.bat";
        switch (GuiFunktionenProgramme.getOs()) {
            case LINUX: {
                pfadScript = GuiFunktionenProgramme.getPathJar() + "bin/flv.sh";
                break;
            }
            case MAC: {
                pfadScript = GuiFunktionenProgramme.getPathJar() + "bin/flv.sh";
                break;
            }
            default: {
                pfadScript = "bin\\flv.bat";
            }
        }
        return pfadScript;
    }

    public static void addSetVorlagen(JFrame parent, Daten daten, ListePset pSet, boolean auto, boolean setVersion) {
        if (pSet == null) {
            if (!auto) {
                MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            }
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        for (DatenPset ps : pSet) {
            if (ps.arr[16].equals("") || GuiFunktionenProgramme.addOnZip(ps.arr[16])) continue;
            if (!auto) {
                MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            }
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (auto) {
            if (Daten.listePset.addPset(pSet) && setVersion) {
                Daten.mVConfig.add("Version-Programmset", pSet.version);
            }
        } else {
            DialogImportPset dialog = new DialogImportPset(parent, true, daten, pSet);
            dialog.setVisible(true);
            if (dialog.ok) {
                if (Daten.listePset.addPset(pSet)) {
                    if (setVersion) {
                        Daten.mVConfig.add("Version-Programmset", pSet.version);
                    }
                    MVMessageDialog.showMessageDialog(null, pSet.size() + " Programmset importiert!", "Ok", 1);
                } else {
                    MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
                }
            }
        }
    }

    private static boolean addOnZip(String datei) {
        block36: {
            String zielPfad = GuiFunktionenProgramme.addsPfad(GuiFunktionenProgramme.getPathJar(), "bin");
            int timeout = 10000;
            try {
                if (!GuiFunktionen.istUrl(datei)) {
                    File zipFile = new File(datei);
                    if (!zipFile.exists()) {
                        return false;
                    }
                    if (datei.endsWith(".zip")) {
                        if (!GuiFunktionenProgramme.entpacken(zipFile, new File(zielPfad))) {
                            return false;
                        }
                    } else {
                        int n;
                        FileInputStream in = new FileInputStream(datei);
                        FileOutputStream fOut = new FileOutputStream(GuiFunktionen.addsPfad(zielPfad, datei));
                        byte[] buffer = new byte[1024];
                        while ((n = in.read(buffer)) != -1) {
                            fOut.write(buffer, 0, n);
                        }
                        fOut.close();
                        in.close();
                    }
                    break block36;
                }
                URLConnection conn = new URL(datei).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                if (datei.endsWith(".zip")) {
                    File tmpFile = File.createTempFile("mediathek", null);
                    tmpFile.deleteOnExit();
                    try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                        int n;
                        FileOutputStream fOut = new FileOutputStream(tmpFile);
                        byte[] buffer = new byte[1024];
                        while ((n = in.read(buffer)) != -1) {
                            fOut.write(buffer, 0, n);
                        }
                        fOut.close();
                    }
                    if (!GuiFunktionenProgramme.entpacken(tmpFile, new File(zielPfad))) {
                        return false;
                    }
                    break block36;
                }
                String file = GuiFunktionen.getDateiName(datei);
                File f = new File(GuiFunktionen.addsPfad(zielPfad, file));
                try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                    int n;
                    FileOutputStream fOut = new FileOutputStream(f);
                    byte[] buffer = new byte[1024];
                    while ((n = in.read(buffer)) != -1) {
                        fOut.write(buffer, 0, n);
                    }
                    fOut.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean entpacken(File archive, File destDir) throws Exception {
        if (!destDir.exists()) {
            return false;
        }
        ZipFile zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        byte[] buffer = new byte[16384];
        while (entries.hasMoreElements()) {
            BufferedInputStream bis;
            ZipEntry entry = entries.nextElement();
            String entryFileName = entry.getName();
            File dir = GuiFunktionenProgramme.buildDirectoryHierarchyFor(entryFileName, destDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (entry.isDirectory()) continue;
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(destDir, entryFileName)));){
                int len;
                bis = new BufferedInputStream(zipFile.getInputStream(entry));
                while ((len = bis.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                bos.flush();
            }
            bis.close();
        }
        zipFile.close();
        return true;
    }

    private static File buildDirectoryHierarchyFor(String entryName, File destDir) {
        int lastIndex = entryName.lastIndexOf(47);
        String internalPathToEntry = entryName.substring(0, lastIndex + 1);
        return new File(destDir, internalPathToEntry);
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        String s1 = "";
        if (str.equals("")) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (praefix) {
                    if (url.startsWith(s1.toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(s1.toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static boolean checkPfadBeschreibbar(String pfad) {
        boolean ret = false;
        File testPfad = new File(pfad);
        try {
            if (!testPfad.exists()) {
                testPfad.mkdirs();
            }
            if (!pfad.equals("") && testPfad.isDirectory() && testPfad.canWrite()) {
                File tmpFile = File.createTempFile("mediathek", "tmp", testPfad);
                tmpFile.delete();
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean programmePruefen(JFrame jFrame, Daten daten) {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean ret = true;
        String text = "";
        for (DatenPset datenPset : Daten.listePset) {
            ret = true;
            if (datenPset.isFreeLine() || datenPset.isLable()) continue;
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n";
            text = text + "| Programmgruppe: " + datenPset.arr[0] + "\n";
            String zielPfad = datenPset.arr[4];
            if (datenPset.progsContainPath()) {
                if (zielPfad.equals("")) {
                    ret = false;
                    text = text + "|       Zielpfad fehlt!\n";
                } else if (!GuiFunktionenProgramme.checkPfadBeschreibbar(zielPfad)) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" nicht beschreibbar!" + "\n";
                }
            }
            for (DatenProg datenProg : datenPset.getListeProg()) {
                if (new File(datenProg.arr[2]).canExecute()) continue;
                RuntimeExec r = new RuntimeExec(datenProg.arr[2]);
                Process pr = r.exec(false);
                if (pr != null) {
                    pr.destroy();
                    continue;
                }
                ret = false;
                text = text + "|       Falscher Programmpfad!\n";
                text = text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                text = text + "|             Pfad: " + datenProg.arr[2] + "\n";
                if (datenProg.arr[2].contains(File.separator)) continue;
                text = text + "|        -> Wenn das Programm nicht im Systempfad liegt, \n";
                text = text + "|             wird der Start nicht klappen!\n";
            }
            if (ret) {
                text = text + "|  -> Ok!\n";
            }
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n\n\n";
        }
        new DialogHilfe(jFrame, true, text).setVisible(true);
        return ret;
    }
}

