/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultCaret;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;

public class PanelMeldungen
extends PanelVorlage {
    private final StringBuffer text;
    private final int logArt;
    private int firstScroll = 25;
    private Color cGruen = new Color(0, 153, 51);
    private Color cRot = new Color(255, 0, 0);
    private JButton jButtonLoeschen;
    private JCheckBox jCheckBoxAuto;
    private JCheckBox jCheckBoxUmbrechen;
    private JLabel jLabelHeader;
    private JTextArea jTextArea;

    public PanelMeldungen(Daten d, JFrame parentComponent, StringBuffer ttext, int llogArt, String header) {
        super(d, parentComponent);
        this.initComponents();
        this.text = ttext;
        this.jLabelHeader.setText(header);
        this.logArt = llogArt;
        if (this.logArt == 17) {
            this.jCheckBoxAuto.setSelected(true);
        } else {
            this.jCheckBoxAuto.setSelected(false);
        }
        this.jCheckBoxAuto.setForeground(this.jCheckBoxAuto.isSelected() ? this.cGruen : this.cRot);
        this.setText();
        this.jButtonLoeschen.addActionListener(new BeobLoeschen());
        this.jCheckBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelMeldungen.this.jCheckBoxAuto.setForeground(PanelMeldungen.this.jCheckBoxAuto.isSelected() ? PanelMeldungen.this.cGruen : PanelMeldungen.this.cRot);
                PanelMeldungen.this.setAuto();
            }
        });
        this.jCheckBoxUmbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PanelMeldungen.this.stopBeob) {
                    Daten.mVConfig.add(PanelMeldungen.this.getNrSystem(), String.valueOf(PanelMeldungen.this.jCheckBoxUmbrechen.isSelected()));
                    PanelMeldungen.this.setLineWrab();
                }
            }
        });
        this.setAuto();
        this.setLineWrab();
    }

    public void notifyPanel() {
        if (this.jCheckBoxAuto.isSelected() || this.firstScroll > 0) {
            if (this.firstScroll > 0) {
                --this.firstScroll;
            }
            this.setLineWrab();
        }
    }

    private void setAuto() {
        if (this.jCheckBoxAuto.isSelected()) {
            DefaultCaret caret = (DefaultCaret)this.jTextArea.getCaret();
            caret.setUpdatePolicy(2);
        } else {
            DefaultCaret caret = (DefaultCaret)this.jTextArea.getCaret();
            caret.setUpdatePolicy(1);
        }
    }

    private void setLineWrab() {
        this.stopBeob = true;
        this.jCheckBoxUmbrechen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get(this.getNrSystem())));
        this.jTextArea.setLineWrap(this.jCheckBoxUmbrechen.isSelected());
        this.jTextArea.setWrapStyleWord(false);
        this.setText();
        this.stopBeob = false;
    }

    private String getNrSystem() {
        String nr = "Meldungsfenster-Systemmeldungen";
        switch (this.logArt) {
            case 16: {
                nr = "Meldungsfenster-Fehlermeldungen";
                break;
            }
            case 17: {
                nr = "Meldungsfenster-Systemmeldungen";
                break;
            }
            case 18: {
                nr = "Meldungsfenster-Playermeldungen";
            }
        }
        return nr;
    }

    private void setText() {
        String s = this.text.toString();
        this.jTextArea.setText(s);
    }

    private void initComponents() {
        this.jButtonLoeschen = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jLabelHeader = new JLabel();
        this.jCheckBoxAuto = new JCheckBox();
        this.jCheckBoxUmbrechen = new JCheckBox();
        this.jButtonLoeschen.setText("L\u00f6schen");
        this.jTextArea.setEditable(false);
        this.jTextArea.setColumns(20);
        this.jTextArea.setRows(5);
        jScrollPane.setViewportView(this.jTextArea);
        this.jLabelHeader.setText("jLabel1");
        this.jCheckBoxAuto.setSelected(true);
        this.jCheckBoxAuto.setText("Autoscroll");
        this.jCheckBoxUmbrechen.setText("Zeilen umbrechen");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane, GroupLayout.Alignment.TRAILING, -1, 429, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelHeader).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxAuto).addGap(18, 18, 18).addComponent(this.jCheckBoxUmbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.jButtonLoeschen))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelHeader).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jScrollPane, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jCheckBoxAuto).addComponent(this.jCheckBoxUmbrechen).addComponent(this.jButtonLoeschen)).addContainerGap()));
    }

    private class BeobLoeschen
    implements ActionListener {
        private BeobLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Log.clearText(PanelMeldungen.this.logArt);
            PanelMeldungen.this.setText();
        }
    }
}

