/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.IoXmlLesen;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.res.GetIcon;
import mediathek.tool.MVMessageDialog;

public class PanelImport
extends PanelVorlage {
    private JButton jButtonImportDatei;
    private JButton jButtonPfad;
    private JCheckBox jCheckBoxAbo;
    private JCheckBox jCheckBoxBlack;
    private JCheckBox jCheckBoxErsetzungstabelle;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldDatei;
    private JTextField jTextFieldPfadKonfig;

    public PanelImport(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jButtonPfad.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonImportDatei.setEnabled(false);
        this.jButtonPfad.addActionListener(new BeobPfad());
        this.jTextFieldDatei.getDocument().addDocumentListener(new BeobPfadDoc());
        this.jButtonImportDatei.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelImport.this.importDatei(PanelImport.this.jTextFieldDatei.getText());
            }
        });
        this.jCheckBoxAbo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelImport.this.setButtonImport();
            }
        });
        this.jCheckBoxBlack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelImport.this.setButtonImport();
            }
        });
        this.jCheckBoxErsetzungstabelle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelImport.this.setButtonImport();
            }
        });
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        this.jTextFieldPfadKonfig.setText(xmlFilePath.toAbsolutePath().toString());
    }

    private void importDatei(String datei) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        int[] found = IoXmlLesen.importAboBlacklist(datei, this.jCheckBoxAbo.isSelected(), this.jCheckBoxBlack.isSelected(), this.jCheckBoxErsetzungstabelle.isSelected());
        String text = "Es wurden\n" + found[0] + " Abos und\n" + found[1] + " Blacklisteintr\u00e4ge\n" + found[2] + " Ersetzungen\n" + "hinzugef\u00fcgt";
        this.setCursor(Cursor.getPredefinedCursor(0));
        MVMessageDialog.showMessageDialog(this.parentComponent, text, "Import", 1);
    }

    private void setButtonImport() {
        this.jButtonImportDatei.setEnabled(!this.jTextFieldDatei.getText().isEmpty() && (this.jCheckBoxAbo.isSelected() || this.jCheckBoxBlack.isSelected() || this.jCheckBoxErsetzungstabelle.isSelected()));
    }

    private void initComponents() {
        JPanel jPanel6 = new JPanel();
        this.jTextFieldDatei = new JTextField();
        this.jButtonPfad = new JButton();
        this.jButtonImportDatei = new JButton();
        JLabel jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jCheckBoxAbo = new JCheckBox();
        this.jCheckBoxBlack = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldPfadKonfig = new JTextField();
        this.jCheckBoxErsetzungstabelle = new JCheckBox();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Abos und Blacklist aus Datei importieren"));
        this.jButtonPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonImportDatei.setText("Import");
        jLabel7.setText("Datei:");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Damit k\u00f6nnen Abos/Blacklist/Ersetzungstabelle aus einer alten gesicherten\nKonfigurationsdatei importiert werden.\n(mediathek.xml oder mediathek.xml_copy_1, mediathek.xml_copy_2, ..)\n\n\nSollen die aktuellen Einstellungen durch die importierten ersetzt werden,\nsollten die aktuellen zuerst gel\u00f6scht werden.\n\nDie importierten Abos/Blacklist/Ersetzungstabelle werden\nan die vorhandenen angeh\u00e4ngt.\n");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jCheckBoxAbo.setText("Abos importieren");
        this.jCheckBoxBlack.setText("Blacklist importieren");
        this.jLabel1.setText("aktuelle Konfigurationsdatei:");
        this.jTextFieldPfadKonfig.setEditable(false);
        this.jTextFieldPfadKonfig.setText("jTextField1");
        this.jCheckBoxErsetzungstabelle.setText("Ersetzungstabelle");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldPfadKonfig)).addGroup(GroupLayout.Alignment.LEADING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(GroupLayout.Alignment.LEADING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel6Layout.createSequentialGroup().addContainerGap(12, -2).addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jTextFieldDatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPfad)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jCheckBoxAbo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 379, Short.MAX_VALUE).addComponent(this.jButtonImportDatei)).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxErsetzungstabelle).addComponent(this.jCheckBoxBlack)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPfad).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDatei, -2, -1, -2).addComponent(jLabel7))).addGap(18, 18, 18).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonImportDatei).addComponent(this.jCheckBoxAbo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBlack).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxErsetzungstabelle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 100, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPfadKonfig, -2, -1, -2).addContainerGap()));
        jPanel6Layout.linkSize(1, this.jButtonPfad, this.jTextFieldDatei, this.jTextFieldPfadKonfig);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelImport.this.daten.mediathekGui, "Konfigdatei ausw\u00e4hlen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        PanelImport.this.jTextFieldDatei.setText(new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(304656587, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                if (PanelImport.this.jTextFieldDatei.getText().equals("")) {
                    chooser.setCurrentDirectory(Daten.getMediathekXmlFilePath().toFile());
                } else {
                    chooser.setCurrentDirectory(new File(PanelImport.this.jTextFieldDatei.getText()));
                }
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelImport.this.jTextFieldDatei.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(802039730, ex);
                    }
                }
            }
        }
    }

    private class BeobPfadDoc
    implements DocumentListener {
        private BeobPfadDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            PanelImport.this.setButtonImport();
        }
    }
}

