/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import mediathek.daten.Daten;
import mediathek.daten.ListePset;
import mediathek.daten.ListePsetVorlagen;
import mediathek.gui.dialogEinstellungen.PanelEinstellungenGeo;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.dialogEinstellungen.PanelPsetKurz;
import mediathek.gui.dialogEinstellungen.PanelPsetLang;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MVFunctionSys;

public class DialogStarteinstellungen
extends JDialog {
    Daten daten;
    private static final int STAT_START = 1;
    private static final int STAT_PFAD = 2;
    private static final int STAT_PSET = 3;
    private static final int STAT_FERTIG = 4;
    private int status = 1;
    private final JFrame parentComponent;
    JCheckBox jCheckBox = new JCheckBox("Einmal am Tag nach einer neuen Programmversion suchen");
    private JButton jButtonStandard;
    private JCheckBox jCheckBoxAlleEinstellungen;
    private JCheckBox jCheckBoxAnpassen;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogStarteinstellungen(JFrame parent, Daten dd) {
        super((Frame)parent, true);
        this.parentComponent = parent;
        this.initComponents();
        this.daten = dd;
        this.setTitle("Erster Start");
        this.jButtonStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.jCheckBoxAnpassen.setVisible(false);
                DialogStarteinstellungen.this.weiter();
            }
        });
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.status = 3;
                DialogStarteinstellungen.this.weiter();
            }
        });
        Daten.mVConfig.add("update-suchen", Boolean.TRUE.toString());
        Daten.mVConfig.add("pfad-vlc", GuiFunktionenProgramme.getMusterPfadVlc());
        Daten.mVConfig.add("pfad-flvstreamer", GuiFunktionenProgramme.getMusterPfadFlv());
        Daten.mVConfig.add("pfad-ffmpeg", GuiFunktionenProgramme.getMusterPfadFFmpeg());
        PanelEinstellungenGeo panelEinstellungenGeo = new PanelEinstellungenGeo(dd, this.parentComponent);
        this.jCheckBox = new JCheckBox("Einmal am Tag nach einer neuen Programmversion suchen");
        this.jCheckBox.setSelected(true);
        this.jCheckBox.addActionListener(new BeobCheckBoxSuchen());
        GroupLayout extraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(extraLayout);
        extraLayout.setHorizontalGroup(extraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extraLayout.createSequentialGroup().addContainerGap().addGroup(extraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panelEinstellungenGeo).addComponent(this.jCheckBox)).addContainerGap()));
        extraLayout.setVerticalGroup(extraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extraLayout.createSequentialGroup().addContainerGap().addComponent(panelEinstellungenGeo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox).addContainerGap()));
    }

    private void weiter() {
        switch (this.status) {
            case 1: {
                this.statusStart();
                break;
            }
            case 2: {
                this.statusPfade();
                break;
            }
            case 3: {
                this.statusPset();
                break;
            }
            default: {
                this.beenden();
            }
        }
    }

    private void statusStart() {
        this.jButtonStandard.setText("Weiter");
        this.status = Daten.mVConfig.get("pfad-vlc").equals("") || Daten.mVConfig.get("pfad-flvstreamer").equals("") || Daten.mVConfig.get("pfad-ffmpeg").equals("") ? 2 : (this.jCheckBoxAnpassen.isSelected() ? 2 : (this.addStandarSet(this.parentComponent, this.daten) ? 4 : 3));
        this.weiter();
    }

    private void statusPfade() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        switch (MVFunctionSys.getOs()) {
            case MAC: 
            case WIN32: 
            case WIN64: {
                this.jScrollPane1.setViewportView(new PanelProgrammPfade(this.parentComponent, true, false, false));
                break;
            }
            default: {
                this.jScrollPane1.setViewportView(new PanelProgrammPfade(this.parentComponent, true, true, true));
            }
        }
        this.status = 3;
        this.jButtonStandard.setText("Weiter");
    }

    private void statusPset() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(true);
        if (Daten.listePset.size() == 0) {
            this.addStandarSet(this.parentComponent, this.daten);
        }
        if (this.jCheckBoxAlleEinstellungen.isSelected()) {
            this.jScrollPane1.setViewportView(new PanelPsetLang(this.daten, this.parentComponent, Daten.listePset));
        } else {
            this.jScrollPane1.setViewportView(new PanelPsetKurz(this.daten, this.parentComponent, Daten.listePset));
        }
        this.status = 4;
        this.jButtonStandard.setText("Weiter");
    }

    private boolean addStandarSet(JFrame parent, Daten daten) {
        boolean ret = false;
        ListePset pSet = ListePsetVorlagen.getStandarset(parent, daten, true);
        if (pSet != null) {
            Daten.listePset.addPset(pSet);
            Daten.mVConfig.add("Version-Programmset", pSet.version);
            ret = true;
        }
        return ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        this.jButtonStandard = new JButton();
        this.jCheckBoxAlleEinstellungen = new JCheckBox();
        this.jCheckBoxAnpassen = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.setDefaultCloseOperation(2);
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 255), 3));
        this.jButtonStandard.setText("Mit Standardeinstellungen starten");
        this.jCheckBoxAlleEinstellungen.setText("alle Einstellungen anzeigen");
        this.jCheckBoxAnpassen.setText("vorher anpassen");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAlleEinstellungen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAnpassen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonStandard).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStandard).addComponent(this.jCheckBoxAlleEinstellungen).addComponent(this.jCheckBoxAnpassen)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 679, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 510, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(18, 18, 18).addComponent(jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private class BeobCheckBoxSuchen
    implements ActionListener {
        private BeobCheckBoxSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.mVConfig.add("update-suchen", Boolean.toString(DialogStarteinstellungen.this.jCheckBox.isSelected()));
        }
    }
}

