/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import mediathek.daten.Daten;
import mediathek.res.GetIcon;
import mediathek.tool.Filter;
import mediathek.tool.ListenerMediathekView;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import org.jdesktop.swingx.JXSearchField;

public final class MVToolBar
extends JToolBar {
    public static final String TOOLBAR_NIX = "";
    public static final String TOOLBAR_TAB_FILME = "Tab-Filme";
    public static final String TOOLBAR_TAB_DOWNLOADS = "Tab-Downloads";
    public static final String TOOLBAR_TAB_ABOS = "Tab-Abos";
    public static final String TOOLBAR_TAB_MELDUNGEN = "Meldungen";
    Box.Filler filler__5;
    Box.Filler filler__10;
    Box.Filler filler__trenner;
    MVButton jButtonAboAendern;
    MVButton jButtonAbosAusschalten;
    MVButton jButtonAbosEinschalten;
    MVButton jButtonAbosLoeschen;
    MVButton jButtonDownloadAktualisieren;
    MVButton jButtonDownloadAlleStarten;
    MVButton jButtonDownloadAufraeumen;
    MVButton jButtonDownloadFilmStarten;
    MVButton jButtonDownloadLoeschen;
    MVButton jButtonDownloadZurueckstellen;
    MVButton jButtonFilmAbspielen;
    MVButton jButtonFilmSpeichern;
    MVButton jButtonFilmeLaden;
    JButton jButtonFilterPanel;
    MVButton jButtonInfo;
    public JXSearchField jTextFieldFilter;
    private String nrToolbar = "";
    private String nrIconKlein = "";
    private final Daten daten;
    BeobMausToolBar beobMausToolBar = new BeobMausToolBar();
    LinkedList<MVButton> buttonListAlles = new LinkedList();
    LinkedList<MVButton> buttonListDownloads = new LinkedList();
    LinkedList<MVButton> buttonListAbos = new LinkedList();
    boolean extern = false;
    String state;
    LinkedList<MVButton> buttonListToUse;

    public MVToolBar(Daten ddaten, String sstate) {
        this.extern = true;
        this.daten = ddaten;
        this.state = sstate;
        switch (sstate) {
            case "Tab-Downloads": {
                this.nrToolbar = "Toolbar-Download-Extern";
                this.nrIconKlein = "system-icon-groesse-Download-Extern";
                this.buttonListToUse = this.buttonListDownloads;
                break;
            }
            case "Tab-Abos": {
                this.nrToolbar = "Toolbar-Abo-Extern";
                this.nrIconKlein = "system-icon-groesse-Abos-Extern";
                this.buttonListToUse = this.buttonListAbos;
                break;
            }
            default: {
                this.nrToolbar = TOOLBAR_NIX;
                this.nrIconKlein = TOOLBAR_NIX;
                this.buttonListToUse = new LinkedList();
            }
        }
        this.startup();
        this.setToolbar(this.state);
    }

    public MVToolBar(Daten ddaten) {
        this.daten = ddaten;
        this.nrToolbar = "Toolbar-Alles";
        this.nrIconKlein = "system-icon-groesse-alles";
        this.buttonListToUse = this.buttonListAlles;
        this.startup();
    }

    private void startup() {
        this.setBackground(new Color(204, 204, 204));
        this.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.setFloatable(false);
        this.filler__5 = new Box.Filler(new Dimension(5, 20), new Dimension(5, 20), new Dimension(5, Short.MAX_VALUE));
        this.filler__10 = new Box.Filler(new Dimension(10, 20), new Dimension(10, 20), new Dimension(10, Short.MAX_VALUE));
        this.filler__trenner = new Box.Filler(new Dimension(1, 5), new Dimension(1, 5), new Dimension(Short.MAX_VALUE, 5));
        this.jButtonFilmeLaden = new MVButton(new String[]{TOOLBAR_TAB_FILME, TOOLBAR_TAB_DOWNLOADS}, "Filmliste laden", "neue Filmliste laden", "filmlisteLaden_32.png", "filmlisteLaden_16.png");
        this.buttonListAlles.add(this.jButtonFilmeLaden);
        this.buttonListDownloads.add(this.jButtonFilmeLaden);
        this.jButtonInfo = new MVButton(new String[]{TOOLBAR_TAB_FILME, TOOLBAR_TAB_DOWNLOADS}, "Filminformation anzeigen", "Filminformation anzeigen", "info_32.png", "info_16.png");
        this.buttonListAlles.add(this.jButtonInfo);
        this.buttonListDownloads.add(this.jButtonInfo);
        this.jButtonFilmAbspielen = new MVButton(new String[]{TOOLBAR_TAB_FILME}, "Film abspielen", "Film abspielen", "film_start_32.png", "film_start_16.png");
        this.buttonListAlles.add(this.jButtonFilmAbspielen);
        this.jButtonFilmSpeichern = new MVButton(new String[]{TOOLBAR_TAB_FILME}, "Film aufzeichnen", "Film aufzeichnen", "film_rec_32.png", "film_rec_16.png");
        this.buttonListAlles.add(this.jButtonFilmSpeichern);
        this.jButtonDownloadAktualisieren = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "Liste der Downloads aktualisieren", "Liste der Downloads aktualisieren", "view-refresh_32.png", "view-refresh_16.png");
        this.buttonListAlles.add(this.jButtonDownloadAktualisieren);
        this.buttonListDownloads.add(this.jButtonDownloadAktualisieren);
        this.jButtonDownloadAlleStarten = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "alle Downloads starten", "alle Downloads starten", "download_alleStarten_32.png", "download_alleStarten_16.png");
        this.buttonListAlles.add(this.jButtonDownloadAlleStarten);
        this.buttonListDownloads.add(this.jButtonDownloadAlleStarten);
        this.jButtonDownloadFilmStarten = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "Film Starten", "gespeicherten Film abspielen", "film_start_32.png", "film_start_16.png");
        this.buttonListAlles.add(this.jButtonDownloadFilmStarten);
        this.buttonListDownloads.add(this.jButtonDownloadFilmStarten);
        this.jButtonDownloadZurueckstellen = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "Downloads zur\u00fcckstellen", "Downloads zur\u00fcckstellen", "undo_32.png", "undo_16.png");
        this.buttonListAlles.add(this.jButtonDownloadZurueckstellen);
        this.buttonListDownloads.add(this.jButtonDownloadZurueckstellen);
        this.jButtonDownloadLoeschen = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "Downloads aus Liste entfernen", "Downloads aus Liste entfernen", "download_del_32.png", "download_del_16.png");
        this.buttonListAlles.add(this.jButtonDownloadLoeschen);
        this.buttonListDownloads.add(this.jButtonDownloadLoeschen);
        this.jButtonDownloadAufraeumen = new MVButton(new String[]{TOOLBAR_TAB_DOWNLOADS}, "Liste der Downloads aufr\u00e4umen", "Liste der Downloads aufr\u00e4umen", "download_clear_32.png", "download_clear_16.png");
        this.buttonListAlles.add(this.jButtonDownloadAufraeumen);
        this.buttonListDownloads.add(this.jButtonDownloadAufraeumen);
        this.jButtonAbosEinschalten = new MVButton(new String[]{TOOLBAR_TAB_ABOS}, "Abos einschalten", "Abos einschalten", "ja_32.png", "ja_16.png");
        this.buttonListAlles.add(this.jButtonAbosEinschalten);
        this.buttonListAbos.add(this.jButtonAbosEinschalten);
        this.jButtonAbosAusschalten = new MVButton(new String[]{TOOLBAR_TAB_ABOS}, "Abos ausschalten", "Abos ausschalten", "nein_32.png", "nein_16.png");
        this.buttonListAlles.add(this.jButtonAbosAusschalten);
        this.buttonListAbos.add(this.jButtonAbosAusschalten);
        this.jButtonAbosLoeschen = new MVButton(new String[]{TOOLBAR_TAB_ABOS}, "Abos l\u00f6schen", "Abos l\u00f6schen", "del_32.png", "del_16.png");
        this.buttonListAlles.add(this.jButtonAbosLoeschen);
        this.buttonListAbos.add(this.jButtonAbosLoeschen);
        this.jButtonAboAendern = new MVButton(new String[]{TOOLBAR_TAB_ABOS}, "Abo \u00e4ndern", "Abo \u00e4ndern", "configure_32.png", "configure_16.png");
        this.buttonListAlles.add(this.jButtonAboAendern);
        this.buttonListAbos.add(this.jButtonAboAendern);
        this.jButtonFilterPanel = new JButton();
        this.jTextFieldFilter = new JXSearchField();
        this.add(this.filler__5);
        if (!this.extern) {
            this.add(this.jButtonFilmeLaden);
            this.add(this.filler__10);
        }
        if (!this.extern || this.state.equals(TOOLBAR_TAB_DOWNLOADS)) {
            this.add(this.jButtonInfo);
            this.add(this.filler__10);
        }
        if (!this.extern) {
            this.add(this.jButtonFilmAbspielen);
            this.add(this.jButtonFilmSpeichern);
            this.add(this.filler__10);
        }
        if (!this.extern || this.state.equals(TOOLBAR_TAB_DOWNLOADS)) {
            this.add(this.jButtonDownloadAktualisieren);
            this.add(this.jButtonDownloadAlleStarten);
            this.add(this.jButtonDownloadFilmStarten);
            this.add(this.jButtonDownloadZurueckstellen);
            this.add(this.jButtonDownloadLoeschen);
            this.add(this.jButtonDownloadAufraeumen);
        }
        if (!this.extern) {
            this.add(this.filler__10);
        }
        if (!this.extern || this.state.equals(TOOLBAR_TAB_ABOS)) {
            this.add(this.jButtonAbosEinschalten);
            this.add(this.jButtonAbosAusschalten);
            this.add(this.jButtonAbosLoeschen);
            this.add(this.jButtonAboAendern);
        }
        if (!this.extern) {
            this.add(this.filler__trenner);
            this.jTextFieldFilter.setBackground(new Color(230, 230, 230));
            this.jTextFieldFilter.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.jTextFieldFilter.setToolTipText("Thema/Titel suchen");
            this.jTextFieldFilter.setDisabledTextColor(new Color(102, 102, 102));
            this.jTextFieldFilter.setMaximumSize(new Dimension(300, 35));
            this.jTextFieldFilter.setName("Thema/Titel");
            this.jTextFieldFilter.setPreferredSize(new Dimension(300, 25));
            this.jTextFieldFilter.setPrompt("Thema/Titel");
            this.jTextFieldFilter.setLayoutStyle(JXSearchField.LayoutStyle.MAC);
            this.jTextFieldFilter.setSearchMode(JXSearchField.SearchMode.INSTANT);
            this.jTextFieldFilter.setUseNativeSearchFieldIfPossible(true);
            this.jTextFieldFilter.getFindButton().setIcon(GetIcon.getProgramIcon("suchen_22.png"));
            this.jTextFieldFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Filter.checkPattern2((JTextField)MVToolBar.this.jTextFieldFilter);
                    ((MVToolBar)MVToolBar.this).daten.guiFilme.guiFilmeFiltern();
                }
            });
            this.jTextFieldFilter.setInstantSearchDelay(150);
            this.add((Component)this.jTextFieldFilter);
            this.jButtonFilterPanel.setToolTipText("Erweiterte Suche (Filter) anzeigen/ausblenden");
            this.jButtonFilterPanel.setBorder(null);
            this.jButtonFilterPanel.setBorderPainted(false);
            this.jButtonFilterPanel.setHorizontalTextPosition(0);
            this.jButtonFilterPanel.setMaximumSize(new Dimension(40, 40));
            this.jButtonFilterPanel.setMinimumSize(new Dimension(40, 40));
            this.jButtonFilterPanel.setOpaque(false);
            this.jButtonFilterPanel.setPreferredSize(new Dimension(40, 40));
            this.jButtonFilterPanel.setVerticalTextPosition(3);
            this.jButtonFilterPanel.setIcon(GetIcon.getProgramIcon("filter_anzeigen_22.png"));
            this.add(this.jButtonFilterPanel);
            this.add(this.filler__10);
        }
        if (!this.nrIconKlein.isEmpty()) {
            this.setIcon(Boolean.parseBoolean(Daten.mVConfig.get(this.nrIconKlein)));
        }
        this.loadVisible();
        this.initListener();
    }

    public final void setIcon(boolean klein) {
        Daten.mVConfig.add(this.nrIconKlein, Boolean.toString(klein));
        this.beobMausToolBar.itemKlein.setSelected(klein);
        this.jButtonFilmeLaden.setIcon();
        this.jButtonFilmAbspielen.setIcon();
        this.jButtonInfo.setIcon();
        this.jButtonFilmSpeichern.setIcon();
        this.jButtonDownloadAktualisieren.setIcon();
        this.jButtonDownloadAlleStarten.setIcon();
        this.jButtonDownloadFilmStarten.setIcon();
        this.jButtonDownloadZurueckstellen.setIcon();
        this.jButtonDownloadLoeschen.setIcon();
        this.jButtonDownloadAufraeumen.setIcon();
        this.jButtonAbosLoeschen.setIcon();
        this.jButtonAbosEinschalten.setIcon();
        this.jButtonAbosAusschalten.setIcon();
        this.jButtonAboAendern.setIcon();
        this.repaint();
    }

    public void setToolbar() {
        if (this.state != null) {
            this.setToolbar(this.state);
        }
    }

    public void setToolbar(String sstate) {
        this.state = sstate;
        this.filterAnzeigen();
        if (sstate.equals(TOOLBAR_NIX)) {
            for (MVButton b : this.buttonListToUse) {
                if (this.extern) {
                    b.setVisible(false);
                    continue;
                }
                b.setEnabled(false);
            }
        } else {
            for (MVButton b : this.buttonListToUse) {
                boolean ok = false;
                if (b.sparte.contains(sstate)) {
                    b.setEnabled(true);
                    b.setVisible(b.anzeigen);
                    ok = true;
                }
                if (ok) continue;
                if (this.extern) {
                    b.setVisible(false);
                    continue;
                }
                if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Download")) && b.sparte.contains(TOOLBAR_TAB_DOWNLOADS) || Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Download")) && b.sparte.contains(TOOLBAR_TAB_DOWNLOADS)) {
                    b.setVisible(false);
                    continue;
                }
                if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Abo")) && b.sparte.contains(TOOLBAR_TAB_ABOS) || Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Abo")) && b.sparte.contains(TOOLBAR_TAB_ABOS)) {
                    b.setVisible(false);
                    continue;
                }
                b.setEnabled(false);
            }
        }
    }

    public void filterAnzeigen() {
        this.jButtonFilterPanel.setEnabled(this.state.equals(TOOLBAR_TAB_FILME));
        this.jTextFieldFilter.setEnabled(this.state.equals(TOOLBAR_TAB_FILME));
        if (!this.extern) {
            this.jTextFieldFilter.setVisible(!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
        } else {
            this.jTextFieldFilter.setVisible(false);
        }
    }

    public void loadVisible() {
        if (!this.nrToolbar.isEmpty()) {
            String[] b = Daten.mVConfig.get(this.nrToolbar).split(":");
            if (this.buttonListToUse.size() == b.length) {
                for (int i = 0; i < b.length; ++i) {
                    this.buttonListToUse.get((int)i).anzeigen = Boolean.parseBoolean(b[i]);
                    this.buttonListToUse.get(i).setVisible(Boolean.parseBoolean(b[i]));
                }
            }
        }
        this.setToolbar();
        if (!this.nrIconKlein.isEmpty()) {
            this.setIcon(Boolean.parseBoolean(Daten.mVConfig.get(this.nrIconKlein)));
        }
    }

    private void storeVisible() {
        if (!this.nrToolbar.isEmpty()) {
            Daten.mVConfig.add(this.nrToolbar, TOOLBAR_NIX);
            for (MVButton b : this.buttonListToUse) {
                if (!Daten.mVConfig.get(this.nrToolbar).isEmpty()) {
                    Daten.mVConfig.add(this.nrToolbar, Daten.mVConfig.get(this.nrToolbar) + ":");
                }
                Daten.mVConfig.add(this.nrToolbar, Daten.mVConfig.get(this.nrToolbar) + Boolean.toString(b.anzeigen));
            }
        }
    }

    private void initListener() {
        ListenerMediathekView.addListener(new ListenerMediathekView(23, MVToolBar.class.getSimpleName()){

            @Override
            public void ping() {
                MVToolBar.this.filterAnzeigen();
            }
        });
        this.addMouseListener(this.beobMausToolBar);
        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            public void start(MSListenerFilmeLadenEvent event) {
                MVToolBar.this.jButtonFilmeLaden.setEnabled(false);
            }

            public void progress(MSListenerFilmeLadenEvent event) {
            }

            public void fertig(MSListenerFilmeLadenEvent event) {
                MVToolBar.this.jButtonFilmeLaden.setEnabled(true);
            }
        });
        this.jButtonFilmeLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.filmeLaden(MVToolBar.this.daten, false);
            }
        });
        this.jButtonFilmeLaden.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.isPopupTrigger() && MVToolBar.this.jButtonFilmeLaden.isEnabled()) {
                    Daten.filmeLaden.filmeLaden(MVToolBar.this.daten, true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger() && MVToolBar.this.jButtonFilmeLaden.isEnabled()) {
                    Daten.filmeLaden.filmeLaden(MVToolBar.this.daten, true);
                }
            }
        });
        this.jButtonFilmSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiFilme.guiFilmeFilmSpeichern();
            }
        });
        this.jButtonFilmAbspielen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiFilme.guiFilmeFilmAbspielen();
            }
        });
        this.jButtonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.filmInfo.showInfo();
            }
        });
        this.jButtonDownloadAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.aktualisieren();
            }
        });
        this.jButtonDownloadAufraeumen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.aufraeumen();
            }
        });
        this.jButtonDownloadLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.loeschen();
            }
        });
        this.jButtonDownloadAlleStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.starten(true);
            }
        });
        this.jButtonDownloadFilmStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.filmAbspielen();
            }
        });
        this.jButtonDownloadZurueckstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiDownloads.zurueckstellen();
            }
        });
        this.jButtonAbosEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiAbo.einAus(true);
            }
        });
        this.jButtonAbosAusschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiAbo.einAus(false);
            }
        });
        this.jButtonAbosLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVToolBar)MVToolBar.this).daten.guiAbo.loeschen();
            }
        });
        this.jButtonAboAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((MVToolBar)MVToolBar.this).daten.guiAbo.aendern();
            }
        });
        this.jButtonFilterPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = !Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"));
                Daten.mVConfig.add("Vis-Filter", Boolean.toString(b));
                MVToolBar.this.filterAnzeigen();
                ListenerMediathekView.notify(23, MVToolBar.class.getName());
            }
        });
    }

    private class BeobMausToolBar
    extends MouseAdapter {
        JCheckBoxMenuItem itemKlein = new JCheckBoxMenuItem("kleine Icons");
        JMenuItem itemReset = new JMenuItem("zur\u00fccksetzen");
        JCheckBoxMenuItem[] box;

        public BeobMausToolBar() {
            if (!MVToolBar.this.nrIconKlein.isEmpty()) {
                this.itemKlein.setSelected(Boolean.parseBoolean(Daten.mVConfig.get(MVToolBar.this.nrIconKlein)));
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            this.itemKlein.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVToolBar.this.setIcon(BeobMausToolBar.this.itemKlein.isSelected());
                }
            });
            jPopupMenu.add(this.itemKlein);
            jPopupMenu.addSeparator();
            this.box = new JCheckBoxMenuItem[MVToolBar.this.buttonListToUse.size()];
            for (int i = 0; i < this.box.length; ++i) {
                this.box[i] = null;
                if (MVToolBar.this.extern) {
                    for (String s : MVToolBar.this.buttonListToUse.get((int)i).sparte) {
                        if (!s.equals(MVToolBar.this.state)) continue;
                        this.box[i] = new JCheckBoxMenuItem(MVToolBar.this.buttonListToUse.get((int)i).name);
                        break;
                    }
                } else {
                    this.box[i] = new JCheckBoxMenuItem(MVToolBar.this.buttonListToUse.get((int)i).name);
                }
                if (this.box[i] == null) continue;
                this.box[i] = new JCheckBoxMenuItem(MVToolBar.this.buttonListToUse.get((int)i).name);
                this.box[i].setIcon(GetIcon.getProgramIcon(MVToolBar.this.buttonListToUse.get((int)i).imageIconKlein));
                this.box[i].setSelected(MVToolBar.this.buttonListToUse.get((int)i).anzeigen);
                this.box[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BeobMausToolBar.this.setButtonList();
                        MVToolBar.this.storeVisible();
                    }
                });
                jPopupMenu.add(this.box[i]);
            }
            jPopupMenu.addSeparator();
            this.itemReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BeobMausToolBar.this.resetToolbar();
                    MVToolBar.this.storeVisible();
                }
            });
            jPopupMenu.add(this.itemReset);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private void setButtonList() {
            if (this.box == null) {
                return;
            }
            for (int i = 0; i < this.box.length; ++i) {
                if (this.box[i] == null) continue;
                MVToolBar.this.buttonListToUse.get((int)i).anzeigen = this.box[i].isSelected();
                MVToolBar.this.buttonListToUse.get(i).setVisible(this.box[i].isSelected());
            }
            MVToolBar.this.setToolbar();
        }

        private void resetToolbar() {
            if (this.box == null) {
                return;
            }
            for (int i = 0; i < this.box.length; ++i) {
                if (this.box[i] == null) continue;
                MVToolBar.this.buttonListToUse.get((int)i).anzeigen = true;
                MVToolBar.this.buttonListToUse.get(i).setVisible(true);
            }
            MVToolBar.this.setToolbar();
            MVToolBar.this.setIcon(false);
        }
    }

    private class MVButton
    extends JButton {
        boolean anzeigen = true;
        String name = "";
        String imageIconKlein;
        String imageIconNormal;
        ArrayList<String> sparte = new ArrayList();

        public MVButton(String[] ssparte, String nname, String ttoolTip, String iimageIconNormal, String iimageIconKlein) {
            this.setToolTipText(ttoolTip);
            this.name = nname;
            this.imageIconKlein = iimageIconKlein;
            this.imageIconNormal = iimageIconNormal;
            this.sparte.addAll(Arrays.asList(ssparte));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
        }

        void setIcon() {
            if (!MVToolBar.this.nrIconKlein.isEmpty()) {
                if (Boolean.parseBoolean(Daten.mVConfig.get(MVToolBar.this.nrIconKlein))) {
                    this.setIcon(GetIcon.getProgramIcon(this.imageIconKlein));
                } else {
                    this.setIcon(GetIcon.getProgramIcon(this.imageIconNormal));
                }
            }
        }
    }
}

