/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyForcedPoint;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.daten.Daten;
import mediathek.daten.DownloadInfos;
import mediathek.gui.MVBandwidthMonitor;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MVFunctionSys;

public class MVDownloadInfo
extends JPanel {
    private double counter = 0.0;
    private JCheckBoxMenuItem menuItem = null;
    private Trace2DLtd m_trace = new Trace2DLtd(300);
    private IAxis x_achse = null;
    private boolean stopBeob = false;
    private JDialog jDialog = null;
    private JFrame parent = null;
    private final Timer timer = new Timer(false);
    private TimerTask timerTask = null;
    private JEditorPane jEditorPaneInfo;
    private JLabel jLabelBandwidth;
    private JPanel jPanelChart;
    private JPanel jPanelInfo;
    private JScrollPane jScrollPane1;
    private JSlider jSliderBandwidth;
    private JSplitPane jSplitPane1;

    public MVDownloadInfo(JFrame parent, final JCheckBoxMenuItem menuItem) {
        this.initComponents();
        this.parent = parent;
        this.menuItem = menuItem;
        this.jDialog = new JDialog((Frame)parent, "Bandbreite");
        this.jDialog.setDefaultCloseOperation(0);
        this.jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                menuItem.setSelected(false);
                MVDownloadInfo.this.toggleVisibility();
            }
        });
        Chart2D chart = new Chart2D();
        chart.setPaintLabels(true);
        chart.setUseAntialiasing(true);
        chart.setToolTipType((IToolTipType)Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        if (MVFunctionSys.getOs() == MVFunctionSys.OperatingSystemType.LINUX) {
            this.jDialog.setBackground(null);
            chart.setOpaque(true);
            this.setOpaque(true);
        } else {
            this.setBackground(Color.WHITE);
        }
        this.x_achse = chart.getAxisX();
        this.x_achse.getAxisTitle().setTitle("Minuten");
        this.x_achse.setPaintScale(true);
        this.x_achse.setVisible(true);
        this.x_achse.setPaintGrid(false);
        this.x_achse.setMajorTickSpacing(10.0);
        this.x_achse.setMinorTickSpacing(1.0);
        IAxis y_achse = chart.getAxisY();
        y_achse.getAxisTitle().setTitle("");
        y_achse.setPaintScale(true);
        y_achse.setVisible(true);
        y_achse.setPaintGrid(true);
        y_achse.setMajorTickSpacing(5.0);
        y_achse.setMinorTickSpacing(1.0);
        y_achse.setFormatter((IAxisLabelFormatter)new LabelFormatterAutoUnits());
        y_achse.setRangePolicy((IRangePolicy)new RangePolicyForcedPoint());
        this.m_trace.setName("");
        this.m_trace.setColor(Color.RED);
        chart.addTrace((ITrace2D)this.m_trace);
        this.jPanelChart.setBackground(Color.WHITE);
        this.jPanelChart.setLayout(new BorderLayout(0, 0));
        this.jPanelChart.add((Component)chart, "Center");
        ListenerMediathekView.addListener(new ListenerMediathekView(28, MVBandwidthMonitor.class.getSimpleName()){

            @Override
            public void ping() {
                MVDownloadInfo.this.setSlider();
            }
        });
        this.jEditorPaneInfo.setText("");
        this.jEditorPaneInfo.setEditable(false);
        this.jEditorPaneInfo.setFocusable(false);
        this.jEditorPaneInfo.setContentType("text/html");
        this.jSliderBandwidth.setMinimum(5);
        this.jSliderBandwidth.setMaximum(100);
        this.jSliderBandwidth.setToolTipText("");
        this.setSlider();
        this.jSliderBandwidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MVDownloadInfo.this.stopBeob) {
                    return;
                }
                int b = MVDownloadInfo.this.jSliderBandwidth.getValue() * 10;
                MVDownloadInfo.this.jLabelBandwidth.setText(b + " kByte/s");
                Daten.mVConfig.add("maxBandbreite", String.valueOf(b));
                ListenerMediathekView.notify(28, MVBandwidthMonitor.class.getName());
            }
        });
        this.jDialog.setContentPane(this);
        this.jSplitPane1.setDividerSize(15);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanelChart.setMinimumSize(new Dimension());
        this.jPanelInfo.setMinimumSize(new Dimension());
        if (GuiFunktionen.setSize("Groesse-Infodialog", this.jDialog, parent)) {
            try {
                double divider = Double.parseDouble(Daten.mVConfig.get("Divider-Infodialog"));
                this.addWL(divider);
            }
            catch (Exception ignored) {
                this.addWL(0.5);
            }
        } else {
            Dimension dim = this.jDialog.getSize();
            dim.height = 250;
            dim.width = 300;
            this.jDialog.setSize(dim);
            this.addWL(0.5);
        }
    }

    private void addWL(final double divider) {
        this.jDialog.addWindowListener(new WindowListener(){
            boolean done = false;

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (this.done) {
                    return;
                }
                this.done = true;
                if (divider < 0.0 || divider > 1.0) {
                    MVDownloadInfo.this.jSplitPane1.setDividerLocation(0.5);
                } else {
                    MVDownloadInfo.this.jSplitPane1.setDividerLocation(divider);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public JDialog getDialog() {
        return this.jDialog;
    }

    public void getDividerLocation() {
        this.jPanelChart.setMinimumSize(new Dimension());
        this.jPanelInfo.setMinimumSize(new Dimension());
        double MIN = this.jSplitPane1.getMinimumDividerLocation();
        double MAX = this.jSplitPane1.getMaximumDividerLocation();
        double akt = this.jSplitPane1.getDividerLocation();
        double divider = (akt - MIN) / (MAX - MIN);
        if (divider < 0.05) {
            divider = 0.0;
        } else if (divider > 0.95) {
            divider = 1.0;
        }
        Daten.mVConfig.add("Divider-Infodialog", String.valueOf(divider));
    }

    private void setSlider() {
        this.stopBeob = true;
        MVDownloadInfo.setSliderBandwith(this.jSliderBandwidth, this.jLabelBandwidth);
        this.stopBeob = false;
    }

    public static String setSliderBandwith(JSlider slider, JLabel label) {
        int bandbreiteKByte;
        try {
            bandbreiteKByte = Integer.parseInt(Daten.mVConfig.get("maxBandbreite"));
        }
        catch (Exception ex) {
            bandbreiteKByte = 1000;
            Daten.mVConfig.add("maxBandbreite", "1000");
        }
        slider.setValue(bandbreiteKByte / 10);
        String ret = MVDownloadInfo.getTextBandwith();
        if (label != null) {
            label.setText(ret);
            if (bandbreiteKByte > 500) {
                label.setForeground(Color.red);
            } else {
                label.setForeground(Color.black);
            }
        }
        return ret;
    }

    public static String getTextBandwith() {
        int bandbreiteKByte;
        try {
            bandbreiteKByte = Integer.parseInt(Daten.mVConfig.get("maxBandbreite"));
        }
        catch (Exception ex) {
            bandbreiteKByte = 1000;
            Daten.mVConfig.add("maxBandbreite", "1000");
        }
        String ret = bandbreiteKByte == 1000 ? "aus" : bandbreiteKByte + " kByte/s";
        return ret;
    }

    public void toggleVisibility() {
        boolean isSelected = this.menuItem.isSelected();
        Daten.mVConfig.add("Bandwidthmonitor-visible", Boolean.toString(this.menuItem.isSelected()));
        this.jDialog.setVisible(isSelected);
        try {
            if (this.menuItem.isSelected()) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        MVDownloadInfo.access$508(MVDownloadInfo.this);
                        MVDownloadInfo.this.m_trace.addPoint(MVDownloadInfo.this.counter / 60.0, (double)Daten.downloadInfos.bandwidth);
                        MVDownloadInfo.this.x_achse.getAxisTitle().setTitle(Daten.downloadInfos.roundBandwidth((long)MVDownloadInfo.this.counter));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MVDownloadInfo.this.setInfoText(Daten.downloadInfos);
                            }
                        });
                    }
                };
                this.timer.schedule(this.timerTask, 0L, 1000L);
            } else {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                this.timer.purge();
            }
        }
        catch (IllegalStateException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void setInfoText(DownloadInfos di) {
        String HEAD = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><style type=\"text/css\" .sans {font-family: Verdana, Geneva, sans-serif;}</style></head><body>";
        String END = "</body></html>";
        String info = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><style type=\"text/css\" .sans {font-family: Verdana, Geneva, sans-serif;}</style></head><body>";
        info = info + this.getInfoText();
        if (di.timeRestAktDownloads > 0L && di.timeRestAllDownloads > 0L) {
            info = info + "<span class=\"sans\"><b>Restzeit: </b>laufende: " + di.getRestzeit() + ", alle: " + di.getGesamtRestzeit() + "<br /></span>";
        } else if (di.timeRestAktDownloads > 0L) {
            info = info + "<span class=\"sans\"><b>Restzeit: </b>laufende: " + di.getRestzeit() + "<br /></span>";
        } else if (di.timeRestAllDownloads > 0L) {
            info = info + "<span class=\"sans\"><b>Restzeit: </b>alle: " + di.getGesamtRestzeit() + "<br /></span>";
        }
        if (di.byteAlleDownloads > 0L || di.byteAktDownloads > 0L) {
            info = info + "<span class=\"sans\"><b>Gr\u00f6\u00dfe: </b>";
            info = di.byteAktDownloads > 0L ? info + MVFilmSize.getGroesse(di.byteAktDownloads) + " von " + MVFilmSize.getGroesse(di.byteAlleDownloads) + " MByte" + "<br /></span>" : info + MVFilmSize.getGroesse(di.byteAlleDownloads) + " MByte" + "<br /></span>";
        }
        if (di.bandwidth > 0L) {
            info = info + "<span class=\"sans\"><b>Bandbreite: </b>";
            info = info + di.bandwidthStr + "<br /></span>";
        }
        info = info + "</body></html>";
        this.jEditorPaneInfo.setText(info);
    }

    private String getInfoText() {
        int[] starts = Daten.downloadInfos.downloadStarts;
        String textLinks = starts[0] == 1 ? "<span class=\"sans\"><b>Download:</b> 1" : "<span class=\"sans\"><b>Downloads:</b> " + starts[0];
        boolean print = false;
        for (int ii = 1; ii < starts.length; ++ii) {
            if (starts[ii] <= 0) continue;
            print = true;
            break;
        }
        if (print) {
            textLinks = textLinks + "&nbsp;&nbsp;( ";
            textLinks = starts[4] == 1 ? textLinks + "1 l\u00e4uft" : textLinks + starts[4] + " laufen";
            textLinks = starts[3] == 1 ? textLinks + ", 1 wartet" : textLinks + ", " + starts[3] + " warten";
            if (starts[5] > 0) {
                textLinks = starts[5] == 1 ? textLinks + ", 1 fertig" : textLinks + ", " + starts[5] + " fertig";
            }
            if (starts[6] > 0) {
                textLinks = starts[6] == 1 ? textLinks + ", 1 fehlerhaft" : textLinks + ", " + starts[6] + " fehlerhaft";
            }
            textLinks = textLinks + " )";
        }
        textLinks = textLinks + "<br /></span>";
        return textLinks;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanelChart = new JPanel();
        this.jPanelInfo = new JPanel();
        this.jSliderBandwidth = new JSlider();
        this.jLabelBandwidth = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneInfo = new JEditorPane();
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        GroupLayout jPanelChartLayout = new GroupLayout(this.jPanelChart);
        this.jPanelChart.setLayout(jPanelChartLayout);
        jPanelChartLayout.setHorizontalGroup(jPanelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanelChartLayout.setVerticalGroup(jPanelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 99, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.jPanelChart);
        this.jSliderBandwidth.setMaximum(1000);
        this.jSliderBandwidth.setMinimum(50);
        this.jSliderBandwidth.setPaintTicks(true);
        this.jSliderBandwidth.setSnapToTicks(true);
        this.jLabelBandwidth.setText("100 kByte/s");
        this.jLabelBandwidth.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jScrollPane1.setViewportView(this.jEditorPaneInfo);
        GroupLayout jPanelInfoLayout = new GroupLayout(this.jPanelInfo);
        this.jPanelInfo.setLayout(jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(jPanelInfoLayout.createSequentialGroup().addComponent(this.jLabelBandwidth, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderBandwidth, -1, 258, Short.MAX_VALUE))).addContainerGap()));
        jPanelInfoLayout.setVerticalGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderBandwidth, -2, -1, -2).addComponent(this.jLabelBandwidth)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 86, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanelInfo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    static /* synthetic */ double access$508(MVDownloadInfo x0) {
        double d = x0.counter;
        x0.counter = d + 1.0;
        return d;
    }
}

