/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.explodingpixels.macwidgets.HudWindow;
import com.jidesoft.utils.SystemInfo;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyForcedPoint;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.tool.MVFunctionSys;

public class MVBandwidthMonitor {
    private double counter = 0.0;
    private HudWindow hudWindow = null;
    private JCheckBoxMenuItem menuItem = null;
    private final Trace2DLtd m_trace = new Trace2DLtd(300);
    private IAxis x_achse = null;
    private final Timer timer = new Timer(false);
    private TimerTask timerTask = null;

    public MVBandwidthMonitor(JFrame parent, final JCheckBoxMenuItem menuItem) {
        this.menuItem = menuItem;
        if (!SystemInfo.isMacOSX()) {
            parent = null;
        }
        this.hudWindow = new HudWindow("Bandbreite", parent);
        this.hudWindow.makeResizeable();
        JDialog hudDialog = this.hudWindow.getJDialog();
        hudDialog.setDefaultCloseOperation(0);
        hudDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                menuItem.setSelected(false);
                MVBandwidthMonitor.this.toggleVisibility();
            }
        });
        Chart2D chart = new Chart2D();
        chart.setPaintLabels(true);
        chart.setUseAntialiasing(true);
        chart.setToolTipType((IToolTipType)Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        JPanel panel = new JPanel();
        if (MVFunctionSys.getOs() == MVFunctionSys.OperatingSystemType.LINUX) {
            hudDialog.setBackground(null);
            chart.setOpaque(true);
            panel.setOpaque(true);
        } else {
            panel.setBackground(Color.WHITE);
        }
        this.x_achse = chart.getAxisX();
        this.x_achse.getAxisTitle().setTitle("Minuten");
        this.x_achse.setPaintScale(true);
        this.x_achse.setVisible(true);
        this.x_achse.setPaintGrid(false);
        this.x_achse.setMajorTickSpacing(10.0);
        this.x_achse.setMinorTickSpacing(1.0);
        IAxis y_achse = chart.getAxisY();
        y_achse.getAxisTitle().setTitle("");
        y_achse.setPaintScale(true);
        y_achse.setVisible(true);
        y_achse.setPaintGrid(true);
        y_achse.setMajorTickSpacing(5.0);
        y_achse.setMinorTickSpacing(1.0);
        y_achse.setFormatter((IAxisLabelFormatter)new LabelFormatterAutoUnits());
        y_achse.setRangePolicy((IRangePolicy)new RangePolicyForcedPoint());
        this.m_trace.setName("");
        this.m_trace.setColor(Color.RED);
        chart.addTrace((ITrace2D)this.m_trace);
        panel.setLayout(new BorderLayout(0, 0));
        panel.add((Component)chart, "Center");
        this.hudWindow.setContentPane(panel);
        Dimension dim = hudDialog.getSize();
        dim.height = 150;
        dim.width = 300;
        hudDialog.setSize(dim);
    }

    public void toggleVisibility() {
        boolean isSelected = this.menuItem.isSelected();
        Daten.mVConfig.add("Bandwidthmonitor-visible", Boolean.toString(this.menuItem.isSelected()));
        this.hudWindow.getJDialog().setVisible(isSelected);
        try {
            if (this.menuItem.isSelected()) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        double bandwidth = 0.0;
                        LinkedList<DatenDownload> activeDownloadList = Daten.listeDownloads.getListOfStartsNotFinished(-1);
                        for (DatenDownload download : activeDownloadList) {
                            if (download.start == null || download.start.status != 2) continue;
                            bandwidth += (double)download.start.bandbreite;
                        }
                        if (bandwidth < 0.0) {
                            bandwidth = 0.0;
                        }
                        MVBandwidthMonitor.access$008(MVBandwidthMonitor.this);
                        MVBandwidthMonitor.this.m_trace.addPoint(MVBandwidthMonitor.this.counter / 60.0, bandwidth);
                        MVBandwidthMonitor.this.x_achse.getAxisTitle().setTitle(MVBandwidthMonitor.this.roundBandwidth(bandwidth, (long)MVBandwidthMonitor.this.counter));
                    }
                };
                this.timer.schedule(this.timerTask, 0L, 1000L);
            } else {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                this.timer.purge();
            }
        }
        catch (IllegalStateException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private String roundBandwidth(double bandw, long time) {
        if (bandw > 1000000.0) {
            return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + new DecimalFormat("####0.00").format(bandw / 1000000.0) + " MByte/s";
        }
        if (bandw > 1000.0) {
            return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + Math.round(bandw / 1000.0) + " kByte/s";
        }
        return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + Math.round(bandw) + " Byte/s";
    }

    static /* synthetic */ double access$008(MVBandwidthMonitor x0) {
        double d = x0.counter;
        x0.counter = d + 1.0;
        return d;
    }
}

