/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.jidesoft.swing.MarqueePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URISyntaxException;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mediathek.daten.Daten;
import mediathek.tool.BeobMausUrl;
import mediathek.tool.EscBeenden;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.UrlHyperlinkAction;
import org.jdesktop.swingx.JXHyperlink;

public class MVAboutDialog
extends JDialog {
    private final JLabel lblVersion = new JLabel();
    private final JPanel buttonPane = new JPanel();
    private final JLabel lblFilmlistPath = new JLabel();
    private final JLabel lblSettingsFilePath = new JLabel();
    private final Boolean isRunningOnMac;
    private final JLabel lblJavaVersion = new JLabel();
    private final JLabel lblVmType = new JLabel();
    private MarqueePane marqueePane;
    private final JFrame parentFrame;

    private void setupVersionString() {
        String strVersion = "Version ";
        strVersion = strVersion + "11";
        strVersion = strVersion + " (";
        strVersion = strVersion + MVFunctionSys.getBuildNr();
        strVersion = strVersion + ")";
        this.lblVersion.setText(strVersion);
    }

    private void initMarqueePane() {
        JEditorPane messagePane = new JEditorPane();
        messagePane.setEditable(false);
        messagePane.setFocusable(false);
        messagePane.setContentType("text/html");
        messagePane.setText("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><style type=\"text/css\"> .sans { font-family: Verdana, Geneva, sans-serif; }</style></head>\n<body>\n<span class=\"sans\"><b>http://zdfmediathk.sourceforge.net</b><br /></span>\n<p><span class=\"sans\"><b>Autoren:</b><br />\nXaver W. (W.Xaver [at] googlemail [dot] com)<br />\nChristian F. (crystalpalace1977 [at] googlemail [dot] com)<br />\nPatrick<br />\nthausherr<br />\nAndreas M.<br />\nsiedlerchr<br /></span><p>\n<span class=\"sans\"><b>Dokumentation / Test:</b><br />\nstyrol<br />\nhostis<br />\npmshell<br />\nthausherr<br />\napoleon<br />\nsiedlerchr<br />\nwerner252<br />\nthomas5<br />\nfrankypsilon</span><p>\n<span class=\"sans\"><b>Ein Dankesch\u00f6n an alle, die zu dieser Software beigetragen haben.</b></span>\n<br /><br /><br /></body></html>");
        this.marqueePane = new MarqueePane((Component)messagePane);
        this.marqueePane.setStayDelay(3000);
        this.marqueePane.setScrollDirection(2);
        this.marqueePane.setScrollAmount(1);
    }

    private void setupJavaInformation() {
        this.lblJavaVersion.setText(System.getProperty("java.version"));
        String strVmType = System.getProperty("java.vm.name");
        strVmType = strVmType + " (";
        strVmType = strVmType + System.getProperty("java.vendor");
        strVmType = strVmType + ")";
        this.lblVmType.setText(strVmType);
    }

    private void initialize() {
        try {
            this.setupVersionString();
            this.setupJavaInformation();
            Path xmlFilePath = Daten.getMediathekXmlFilePath();
            this.lblSettingsFilePath.setText(xmlFilePath.toAbsolutePath().toString());
            this.lblFilmlistPath.setText(Daten.getDateiFilmliste());
            if (this.isRunningOnMac.booleanValue()) {
                this.remove(this.buttonPane);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MVAboutDialog(JFrame parent, Boolean isRunningOnMac) {
        super(parent);
        this.parentFrame = parent;
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.isRunningOnMac = isRunningOnMac;
        new EscBeenden(this){

            @Override
            public void beenden_(JDialog d) {
                d.dispose();
            }
        };
        this.initMarqueePane();
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(100, 100, 790, 491);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setBackground(Color.WHITE);
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        JLabel lblProgramIcon = new JLabel();
        lblProgramIcon.setIcon(new ImageIcon(MVAboutDialog.class.getResource("/mediathek/res/MediathekView.png")));
        JLabel lblProgramName = new JLabel("MediathekView");
        lblProgramName.setFont(new Font("Lucida Grande", 1, 24));
        Color greyColor = new Color(159, 159, 159);
        this.lblVersion.setForeground(greyColor);
        this.lblVersion.setFont(new Font("Lucida Grande", 1, 13));
        JXHyperlink hprlnkWebsite = new JXHyperlink();
        hprlnkWebsite.setHorizontalAlignment(2);
        try {
            hprlnkWebsite.setAction((Action)new WebsiteHyperlinkAction());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        hprlnkWebsite.setText("Website");
        hprlnkWebsite.addMouseListener((MouseListener)new BeobMausUrl("http://zdfmediathk.sourceforge.net/"));
        JXHyperlink hprlnkDonation = new JXHyperlink();
        hprlnkDonation.setHorizontalAlignment(2);
        try {
            hprlnkDonation.setAction((Action)new DonationHyperlinkAction());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        hprlnkDonation.setText("Spende");
        hprlnkDonation.addMouseListener((MouseListener)new BeobMausUrl("http://zdfmediathk.sourceforge.net/index.html#donate"));
        JXHyperlink hprlnkAnleitung = new JXHyperlink();
        hprlnkAnleitung.setHorizontalAlignment(2);
        try {
            hprlnkAnleitung.setAction((Action)new AnleitungHyperlinkAction());
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        hprlnkAnleitung.setText("Anleitung");
        hprlnkAnleitung.addMouseListener((MouseListener)new BeobMausUrl("http://sourceforge.net/p/zdfmediathk/wiki/Home/"));
        JXHyperlink hprlnkForum = new JXHyperlink();
        hprlnkForum.setHorizontalAlignment(2);
        try {
            hprlnkForum.setAction((Action)new ForumHyperlinkAction());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        hprlnkForum.setText("Forum");
        hprlnkForum.addMouseListener((MouseListener)new BeobMausUrl("http://zdfmediathk.sourceforge.net/forum/"));
        JPanel pnlProgramPaths = new JPanel();
        TitledBorder border = new TitledBorder("Programmpfade");
        pnlProgramPaths.setBorder(border);
        pnlProgramPaths.setBackground(Color.WHITE);
        JPanel pnlJavaInformation = new JPanel();
        border = new TitledBorder("Java Information");
        pnlJavaInformation.setBorder(border);
        pnlJavaInformation.setBackground(Color.WHITE);
        GroupLayout gl_contentPanel = new GroupLayout(contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblProgramIcon).addComponent((Component)hprlnkWebsite, -2, -1, -2).addComponent((Component)hprlnkDonation, -2, -1, -2).addComponent((Component)hprlnkForum, -2, -1, -2).addComponent((Component)hprlnkAnleitung, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.marqueePane, -1, 464, Short.MAX_VALUE).addComponent(pnlJavaInformation, GroupLayout.Alignment.TRAILING, -1, 464, Short.MAX_VALUE).addComponent(pnlProgramPaths, -1, 464, Short.MAX_VALUE).addComponent(lblProgramName).addComponent(this.lblVersion, GroupLayout.Alignment.TRAILING, -1, 464, Short.MAX_VALUE)).addContainerGap()));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lblProgramName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblVersion).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.marqueePane, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(pnlProgramPaths, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(pnlJavaInformation, -2, 80, -2)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lblProgramIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)hprlnkWebsite, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)hprlnkDonation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)hprlnkForum, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)hprlnkAnleitung, -2, -1, -2))).addContainerGap(28, Short.MAX_VALUE)));
        JLabel lblVersion_1 = new JLabel("Version:");
        lblVersion_1.setForeground(greyColor);
        JLabel lblJavaType = new JLabel("Type:");
        lblJavaType.setForeground(greyColor);
        this.lblJavaVersion.setForeground(greyColor);
        this.lblVmType.setForeground(greyColor);
        GroupLayout gl_pnlJavaInformation = new GroupLayout(pnlJavaInformation);
        gl_pnlJavaInformation.setHorizontalGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_pnlJavaInformation.createSequentialGroup().addContainerGap().addGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblJavaType).addComponent(lblVersion_1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVmType, -1, 395, Short.MAX_VALUE).addComponent(this.lblJavaVersion, -1, 395, Short.MAX_VALUE)).addContainerGap()));
        gl_pnlJavaInformation.setVerticalGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_pnlJavaInformation.createSequentialGroup().addContainerGap().addGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblVersion_1).addComponent(this.lblJavaVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_pnlJavaInformation.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblJavaType).addComponent(this.lblVmType)).addContainerGap(52, Short.MAX_VALUE)));
        pnlJavaInformation.setLayout(gl_pnlJavaInformation);
        JLabel lblFilmliste = new JLabel("Filmliste:");
        lblFilmliste.setHorizontalAlignment(4);
        lblFilmliste.setForeground(greyColor);
        this.lblFilmlistPath.setForeground(greyColor);
        JLabel lblEinstellungen = new JLabel("Einstellungen:");
        lblEinstellungen.setForeground(greyColor);
        this.lblSettingsFilePath.setForeground(greyColor);
        GroupLayout gl_panel = new GroupLayout(pnlProgramPaths);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblFilmliste, -1, -1, Short.MAX_VALUE).addComponent(lblEinstellungen, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblSettingsFilePath, -1, 345, Short.MAX_VALUE).addComponent(this.lblFilmlistPath, -1, 345, Short.MAX_VALUE)).addContainerGap()));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblFilmliste).addComponent(this.lblFilmlistPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblEinstellungen).addComponent(this.lblSettingsFilePath)).addContainerGap(10, Short.MAX_VALUE)));
        pnlProgramPaths.setLayout(gl_panel);
        contentPanel.setLayout(gl_contentPanel);
        this.buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)this.buttonPane, "South");
        JButton okButton = new JButton("Schlie\u00dfen");
        okButton.setAction(new CloseDialogAction(this));
        this.buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.initialize();
        this.pack();
    }

    private class CloseDialogAction
    extends AbstractAction {
        private final MVAboutDialog dlg;

        public CloseDialogAction(MVAboutDialog dlg) {
            this.putValue("Name", "Schlie\u00dfen");
            this.putValue("ShortDescription", "Dialog schlie\u00dfen");
            this.dlg = dlg;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dlg.dispose();
        }
    }

    private class AnleitungHyperlinkAction
    extends AbstractAction {
        public AnleitungHyperlinkAction() throws URISyntaxException {
            this.putValue("ShortDescription", "http://sourceforge.net/p/zdfmediathk/wiki/Home/");
            this.putValue("LongDescription", "http://sourceforge.net/p/zdfmediathk/wiki/Home/");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UrlHyperlinkAction.urlOeffnen(MVAboutDialog.this.parentFrame, "http://sourceforge.net/p/zdfmediathk/wiki/Home/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private class ForumHyperlinkAction
    extends AbstractAction {
        public ForumHyperlinkAction() throws URISyntaxException {
            this.putValue("ShortDescription", "http://zdfmediathk.sourceforge.net/forum/");
            this.putValue("LongDescription", "http://zdfmediathk.sourceforge.net/forum/");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UrlHyperlinkAction.urlOeffnen(MVAboutDialog.this.parentFrame, "http://zdfmediathk.sourceforge.net/forum/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private class DonationHyperlinkAction
    extends AbstractAction {
        public DonationHyperlinkAction() throws URISyntaxException {
            this.putValue("ShortDescription", "http://zdfmediathk.sourceforge.net/index.html#donate");
            this.putValue("LongDescription", "http://zdfmediathk.sourceforge.net/index.html#donate");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UrlHyperlinkAction.urlOeffnen(MVAboutDialog.this.parentFrame, "http://zdfmediathk.sourceforge.net/index.html#donate");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private class WebsiteHyperlinkAction
    extends AbstractAction {
        public WebsiteHyperlinkAction() throws URISyntaxException {
            this.putValue("ShortDescription", "http://zdfmediathk.sourceforge.net/");
            this.putValue("LongDescription", "http://zdfmediathk.sourceforge.net/");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UrlHyperlinkAction.urlOeffnen(MVAboutDialog.this.parentFrame, "http://zdfmediathk.sourceforge.net/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }
}

