/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.TModel;

public class ListePsetVorlagen
extends LinkedList<String[]> {
    public static final String BS_WIN_32 = "Windows-32Bit";
    public static final String BS_WIN_64 = "Windows-64Bit";
    public static final String BS_LINUX = "Linux";
    public static final String BS_MAC = "Mac";
    public static final String[] BS = new String[]{"", "Windows-32Bit", "Windows-64Bit", "Linux", "Mac"};
    public static final String PGR = "Vorlage";
    public static final String PGR_NAME = "Name";
    public static final int PGR_NAME_NR = 0;
    public static final String PGR_BESCHREIBUNG = "Beschreibung";
    public static final int PGR_BESCHREIBUNG_NR = 1;
    public static final String PGR_VERSION = "Version";
    public static final int PGR_VERSION_NR = 2;
    public static final String PGR_BS = "Bs";
    public static final int PGR_BS_NR = 3;
    public static final String PGR_URL = "URL";
    public static final int PGR_URL_NR = 4;
    public static final String PGR_INFO = "Info";
    public static final int PGR_INFO_NR = 5;
    public static final int PGR_MAX_ELEM = 6;
    public static final String[] PGR_COLUMN_NAMES = new String[]{"Name", "Beschreibung", "Version", "Bs", "URL", "Info"};
    private static final int TIMEOUT = 10000;

    public TModel getTModel(String bs) {
        LinkedList<String[]> tmp = new LinkedList<String[]>();
        if (this.size() > 0) {
            Object[][] object;
            if (!bs.equals("")) {
                for (String[] aThi : this) {
                    if (!aThi[3].contains(bs)) continue;
                    tmp.add(aThi);
                }
                object = new String[tmp.size()][6];
                for (int i = 0; i < tmp.size(); ++i) {
                    object[i] = (String[])tmp.get(i);
                }
            } else {
                object = new String[this.size()][6];
                for (int i = 0; i < this.size(); ++i) {
                    object[i] = (String[])this.get(i);
                }
            }
            return new TModel(object, PGR_COLUMN_NAMES);
        }
        return new TModel(new Object[0][], PGR_COLUMN_NAMES);
    }

    public static ListePset getStandarset(JFrame parent, Daten ddaten, boolean replaceMuster) {
        ListePset listePset = null;
        String[] vorlage = null;
        ListePsetVorlagen listePsetVorlagen = new ListePsetVorlagen();
        if (listePsetVorlagen.loadListOfSets()) {
            for (String[] ar : listePsetVorlagen) {
                if (!ar[0].equalsIgnoreCase("Standardset " + MVFunctionSys.getOsString())) continue;
                vorlage = ar;
                break;
            }
            if (vorlage != null && !vorlage[4].equals("") && (listePset = ListePsetVorlagen.importPsetFile(parent, (String)vorlage[4], true)) != null) {
                listePset.version = vorlage[2];
            }
        }
        if (listePset == null) {
            InputStreamReader inReader;
            switch (MVFunctionSys.getOs()) {
                case LINUX: {
                    inReader = new GetFile().getPsetVorlageLinux();
                    break;
                }
                case MAC: {
                    inReader = new GetFile().getPsetVorlageMac();
                    break;
                }
                default: {
                    inReader = new GetFile().getPsetVorlageWindows();
                }
            }
            listePset = ListePsetVorlagen.importPset(inReader, true);
        }
        if (replaceMuster && listePset != null) {
            ListePset.progMusterErsetzen(parent, listePset);
        }
        return listePset;
    }

    public boolean loadListOfSets() {
        try {
            this.clear();
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            URLConnection conn = new URL("http://zdfmediathk.sourceforge.net/programmgruppen11/programmgruppen.xml").openConnection();
            conn.setRequestProperty("User-Agent", Daten.getUserAgent());
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(10000);
            InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals(PGR)) continue;
                String[] p = new String[6];
                ListePsetVorlagen.get(parser, PGR, PGR_COLUMN_NAMES, p);
                if (p[4].equals("")) continue;
                this.add(p);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(398001963, ex);
            return false;
        }
        return true;
    }

    public static ListePset importPsetFile(JFrame parent, String dateiUrl, boolean log) {
        int timeout = 10000;
        try {
            if (GuiFunktionen.istUrl(dateiUrl)) {
                URLConnection conn = new URL(dateiUrl).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                return ListePsetVorlagen.importPset(new InputStreamReader(conn.getInputStream(), "UTF-8"), log);
            }
            return ListePsetVorlagen.importPset(new InputStreamReader((InputStream)new FileInputStream(dateiUrl), "UTF-8"), log);
        }
        catch (Exception ex) {
            if (log) {
                Log.fehlerMeldung(630048926, ex);
            }
            return null;
        }
    }

    public static ListePset importPsetText(Daten dd, String text, boolean log) {
        return ListePsetVorlagen.importPset(new InputStreamReader(new ByteArrayInputStream(text.getBytes())), log);
    }

    private static ListePset importPset(InputStreamReader in, boolean log) {
        DatenPset datenPset = null;
        ListePset liste = new ListePset();
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                switch (parser.getLocalName()) {
                    case "Programmset": {
                        datenPset = new DatenPset();
                        if (!ListePsetVorlagen.get(parser, "Programmset", DatenPset.COLUMN_NAMES_, datenPset.arr)) {
                            datenPset = null;
                            break;
                        }
                        if (datenPset.isEmpty()) break;
                        liste.add(datenPset);
                        break;
                    }
                    case "Programm": {
                        if (datenPset == null) break;
                        DatenProg datenProg = new DatenProg();
                        if (!ListePsetVorlagen.get(parser, "Programm", DatenProg.COLUMN_NAMES_, datenProg.arr)) break;
                        datenPset.addProg(datenProg);
                    }
                }
            }
            in.close();
        }
        catch (Exception ex) {
            if (log) {
                Log.fehlerMeldung(467810360, ex);
            }
            return null;
        }
        if (liste.isEmpty()) {
            return null;
        }
        return liste;
    }

    private static boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung(467256394, ex);
        }
        return ret;
    }
}

