/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.DecimalFormat;
import java.util.LinkedList;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;

public class DownloadInfos {
    public int anzDownloadsRun = 0;
    public long byteAlleDownloads = 0L;
    public long byteAktDownloads = 0L;
    public long timeRestAktDownloads = 0L;
    public long timeRestAllDownloads = 0L;
    public long bandwidth = 0L;
    public String bandwidthStr = "";
    public int[] downloadStarts = new int[]{0, 0, 0, 0, 0, 0, 0};
    private LinkedList<DatenDownload> aktivDownloads;

    public String roundBandwidth(long time) {
        this.roundBandwidth();
        if ((double)this.bandwidth > 1000000.0) {
            return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + this.bandwidthStr;
        }
        if ((double)this.bandwidth > 1000.0) {
            return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + this.bandwidthStr;
        }
        return time / 60L + ":" + (time % 60L < 10L ? "0" + time % 60L : Long.valueOf(time % 60L)) + " Minuten / " + this.bandwidthStr;
    }

    public String roundBandwidth() {
        this.bandwidthStr = (double)this.bandwidth > 1000000.0 ? new DecimalFormat("####0.00").format((double)this.bandwidth / 1000000.0) + " MByte/s" : ((double)this.bandwidth > 1000.0 ? Math.round((double)this.bandwidth / 1000.0) + " kByte/s" : Math.round(this.bandwidth) + " Byte/s");
        return this.bandwidthStr;
    }

    public String getGesamtRestzeit() {
        if (this.timeRestAllDownloads > 0L) {
            if (this.timeRestAllDownloads < 60L) {
                return "< 1 Min";
            }
            return Long.toString(this.timeRestAllDownloads / 60L) + " Min";
        }
        return "";
    }

    public String getRestzeit() {
        if (this.timeRestAktDownloads > 0L) {
            if (this.timeRestAktDownloads < 60L) {
                return "< 1 Min";
            }
            return Long.toString(this.timeRestAktDownloads / 60L) + " Min";
        }
        return "";
    }

    public synchronized void makeDownloadInfos() {
        this.clean();
        this.downloadStarts = Daten.listeDownloads.getStarts();
        this.aktivDownloads = Daten.listeDownloads.getListOfStartsNotFinished(-1);
        for (DatenDownload download : this.aktivDownloads) {
            ++Daten.downloadInfos.anzDownloadsRun;
            Daten.downloadInfos.byteAlleDownloads = Daten.downloadInfos.byteAlleDownloads + (download.mVFilmSize.getSize() > 0L ? download.mVFilmSize.getSize() : 0L);
            if (download.start == null || download.start.status != 2) continue;
            Daten.downloadInfos.bandwidth += download.start.bandbreite;
            Daten.downloadInfos.byteAktDownloads = Daten.downloadInfos.byteAktDownloads + (download.mVFilmSize.getAktSize() > 0L ? download.mVFilmSize.getAktSize() : 0L);
            if (download.start.restSekunden <= Daten.downloadInfos.timeRestAktDownloads) continue;
            Daten.downloadInfos.timeRestAktDownloads = download.start.restSekunden;
        }
        if (Daten.downloadInfos.bandwidth < 0L) {
            Daten.downloadInfos.bandwidth = 0L;
        }
        if (Daten.downloadInfos.bandwidth > 0L) {
            long b = Daten.downloadInfos.byteAlleDownloads - Daten.downloadInfos.byteAktDownloads;
            Daten.downloadInfos.timeRestAllDownloads = b <= 0L ? 0L : b / Daten.downloadInfos.bandwidth;
            if (Daten.downloadInfos.timeRestAllDownloads < Daten.downloadInfos.timeRestAktDownloads) {
                Daten.downloadInfos.timeRestAllDownloads = Daten.downloadInfos.timeRestAktDownloads;
            }
            if (Daten.downloadInfos.anzDownloadsRun == 1) {
                Daten.downloadInfos.timeRestAllDownloads = 0L;
            }
        }
        Daten.downloadInfos.roundBandwidth();
    }

    private void clean() {
        this.anzDownloadsRun = 0;
        this.byteAlleDownloads = 0L;
        this.byteAktDownloads = 0L;
        this.timeRestAktDownloads = 0L;
        this.timeRestAllDownloads = 0L;
        this.bandwidth = 0L;
    }
}

