/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.controller.Log;
import mediathek.controller.MVUsedUrl;
import mediathek.daten.Daten;
import mediathek.tool.ListenerMediathekView;
import msearch.daten.DatenFilm;

public class MVUsedUrls {
    private final HashSet<String> listeUrls;
    private LinkedList<MVUsedUrl> listeUrlsSortDate;
    private final String fileName;
    private final int notifyEvent;

    public MVUsedUrls(String fileName, int notifyEvent) {
        this.fileName = fileName;
        this.notifyEvent = notifyEvent;
        this.listeUrlsSortDate = new LinkedList();
        this.listeUrls = new HashSet<String>(){

            @Override
            public void clear() {
                MVUsedUrls.this.listeUrlsSortDate.clear();
                super.clear();
            }
        };
        this.listeBauen();
    }

    public synchronized void setGesehen(boolean gesehen, ArrayList<DatenFilm> arrayFilms) {
        if (arrayFilms.isEmpty()) {
            return;
        }
        if (!gesehen) {
            this.urlAusLogfileLoeschen(arrayFilms);
            for (DatenFilm film : arrayFilms) {
                Daten.listeFilmeHistory.remove((Object)film);
            }
        } else {
            ArrayList<DatenFilm> neueFilme = new ArrayList<DatenFilm>();
            for (DatenFilm film : arrayFilms) {
                if (this.urlPruefen(film.getUrlHistory())) continue;
                neueFilme.add(film);
                Daten.listeFilmeHistory.add((Object)film);
            }
            this.zeileSchreiben(neueFilme);
        }
    }

    public synchronized void alleLoeschen() {
        this.listeUrls.clear();
        Path urlPath = this.getUrlFilePath();
        try {
            Files.deleteIfExists(urlPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ListenerMediathekView.notify(this.notifyEvent, MVUsedUrls.class.getSimpleName());
    }

    public synchronized boolean urlPruefen(String urlFilm) {
        return this.listeUrls.contains(urlFilm);
    }

    public synchronized Object[][] getObjectData() {
        int i = 0;
        Iterator iterator = this.listeUrlsSortDate.iterator();
        Object[][] object = new Object[this.listeUrlsSortDate.size()][];
        while (iterator.hasNext()) {
            object[i] = ((MVUsedUrl)iterator.next()).uUrl;
            ++i;
        }
        return object;
    }

    public synchronized LinkedList<MVUsedUrl> getSortList() {
        LinkedList<MVUsedUrl> ret = new LinkedList<MVUsedUrl>();
        for (MVUsedUrl aListeUrlsSortDate : this.listeUrlsSortDate) {
            ret.add(aListeUrlsSortDate);
        }
        Collections.sort(ret);
        return ret;
    }

    public synchronized boolean urlAusLogfileLoeschen(String urlFilm) {
        Throwable throwable;
        boolean gefunden = false;
        LinkedList<String> liste = new LinkedList<String>();
        Path urlPath = this.getUrlFilePath();
        if (Files.notExists(urlPath, new LinkOption[0])) {
            return false;
        }
        try {
            throwable = null;
            try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
                String zeile;
                while ((zeile = in.readLine()) != null) {
                    if (MVUsedUrl.getUrlAusZeile(zeile).getUrl().equals(urlFilm)) {
                        gefunden = true;
                        continue;
                    }
                    liste.add(zeile);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(281006874, ex);
        }
        if (gefunden) {
            try {
                throwable = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getUrlFilePath(), new OpenOption[0])));){
                    for (String entry : liste) {
                        bufferedWriter.write(entry + "\n");
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(566277080, ex);
            }
        }
        this.listeUrls.clear();
        this.listeBauen();
        ListenerMediathekView.notify(this.notifyEvent, MVUsedUrls.class.getSimpleName());
        return gefunden;
    }

    public synchronized boolean urlAusLogfileLoeschen(ArrayList<DatenFilm> filme) {
        Throwable throwable;
        boolean gefunden = false;
        boolean gef = false;
        LinkedList<String> newListe = new LinkedList<String>();
        Path urlPath = this.getUrlFilePath();
        if (Files.notExists(urlPath, new LinkOption[0])) {
            return false;
        }
        try {
            throwable = null;
            try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
                String zeile;
                while ((zeile = in.readLine()) != null) {
                    gef = false;
                    String url = MVUsedUrl.getUrlAusZeile(zeile).getUrl();
                    for (DatenFilm film : filme) {
                        if (!url.equals(film.getUrlHistory())) continue;
                        gefunden = true;
                        gef = true;
                        break;
                    }
                    if (gef) continue;
                    newListe.add(zeile);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(401020398, ex);
        }
        if (gefunden) {
            try {
                throwable = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getUrlFilePath(), new OpenOption[0])));){
                    for (String entry : newListe) {
                        bufferedWriter.write(entry + "\n");
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(784512067, ex);
            }
        }
        this.listeUrls.clear();
        this.listeBauen();
        ListenerMediathekView.notify(this.notifyEvent, MVUsedUrls.class.getSimpleName());
        return gefunden;
    }

    public synchronized boolean zeileSchreiben(String thema, String titel, String url) {
        boolean ret = false;
        String datum = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
        this.listeUrls.add(url);
        this.listeUrlsSortDate.add(new MVUsedUrl(datum, thema, titel, url));
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getUrlFilePath(), StandardOpenOption.APPEND)));){
            String text = MVUsedUrl.getUsedUrl(datum, thema, titel, url);
            bufferedWriter.write(text);
            ret = true;
        }
        catch (Exception ex) {
            Log.fehlerMeldung(945258023, ex);
        }
        ListenerMediathekView.notify(this.notifyEvent, MVUsedUrls.class.getSimpleName());
        return ret;
    }

    public synchronized boolean zeileSchreiben(ArrayList<DatenFilm> arrayFilms) {
        boolean ret = false;
        String datum = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getUrlFilePath(), StandardOpenOption.APPEND)));){
            for (DatenFilm film : arrayFilms) {
                this.listeUrls.add(film.getUrlHistory());
                this.listeUrlsSortDate.add(new MVUsedUrl(datum, film.arr[2], film.arr[3], film.getUrlHistory()));
                String text = MVUsedUrl.getUsedUrl(datum, film.arr[2], film.arr[3], film.getUrlHistory());
                bufferedWriter.write(text);
            }
            ret = true;
        }
        catch (Exception ex) {
            Log.fehlerMeldung(420312459, ex);
        }
        ListenerMediathekView.notify(this.notifyEvent, MVUsedUrls.class.getSimpleName());
        return ret;
    }

    public synchronized void zeilenSchreiben(LinkedList<MVUsedUrl> mvuuList) {
        new Thread(new zeilenSchreiben_(mvuuList)).start();
    }

    private Path getUrlFilePath() {
        Path urlPath = null;
        try {
            urlPath = Daten.getSettingsDirectory().resolve(this.fileName);
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return urlPath;
    }

    private void listeBauen() {
        Path urlPath = this.getUrlFilePath();
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                MVUsedUrl mvuu = MVUsedUrl.getUrlAusZeile(zeile);
                this.listeUrls.add(mvuu.getUrl());
                this.listeUrlsSortDate.add(mvuu);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(926362547, ex);
        }
    }

    private class zeilenSchreiben_
    implements Runnable {
        LinkedList<MVUsedUrl> mvuuList;

        public zeilenSchreiben_(LinkedList<MVUsedUrl> mvuuList) {
            this.mvuuList = mvuuList;
        }

        @Override
        public synchronized void run() {
            this.zeilenSchreiben(this.mvuuList);
        }

        private synchronized boolean zeilenSchreiben(LinkedList<MVUsedUrl> mvuuList) {
            boolean ret = false;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(MVUsedUrls.this.getUrlFilePath(), StandardOpenOption.APPEND)));){
                for (MVUsedUrl mvuu : mvuuList) {
                    MVUsedUrls.this.listeUrls.add(mvuu.getUrl());
                    MVUsedUrls.this.listeUrlsSortDate.add(mvuu);
                    String text = mvuu.getUsedUrl();
                    bufferedWriter.write(text);
                    ret = true;
                }
            }
            catch (Exception ex) {
                ret = false;
                Log.fehlerMeldung(945258023, ex);
            }
            ListenerMediathekView.notify(MVUsedUrls.this.notifyEvent, MVUsedUrls.class.getSimpleName());
            return ret;
        }
    }
}

