/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.controller.CheckUpdate;
import mediathek.controller.Log;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiDownloads;
import mediathek.gui.GuiFilme;
import mediathek.gui.MVAboutDialog;
import mediathek.gui.MVBandwidthMonitor;
import mediathek.gui.MVDownloadInfo;
import mediathek.gui.MVHelpDialog;
import mediathek.gui.MVStatusBar;
import mediathek.gui.MVToolBar;
import mediathek.gui.MVTray;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogBeenden;
import mediathek.gui.dialog.DialogLeer;
import mediathek.gui.dialog.DialogMediaDB;
import mediathek.gui.dialog.DialogStarteinstellungen;
import mediathek.gui.dialog.MVFilmInformation;
import mediathek.gui.dialog.MVFilmInformationLinux;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.dialogEinstellungen.PanelBlacklist;
import mediathek.gui.dialogEinstellungen.PanelMeldungen;
import mediathek.res.GetIcon;
import mediathek.tool.Duration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFont;
import mediathek.tool.MVFrame;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVMessageDialog;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;

public class MediathekGui
extends JFrame {
    private Daten daten;
    protected final DialogEinstellungen dialogEinstellungen;
    private final JSpinner jSpinnerAnzahl = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
    private final JLabel jLabelAnzahl = new JLabel("Anzahl gleichzeitige Downloads");
    private final JPanel jPanelAnzahl = new JPanel();
    private final JLabel jLabelBandbreite = new JLabel("Bandbreite pro Download");
    private final JPanel jPanelBandbreite = new JPanel();
    private final JSlider jSliderBandbreite = new JSlider();
    private PanelVorlage panelMeldungen = new PanelVorlage(this.daten, this);
    private JSplitPane splitPane = null;
    private final MVToolBar mVToolBar;
    private MVStatusBar statusBar;
    private final MVFrame[] frames = new MVFrame[3];
    private JCheckBoxMenuItem jCheckBoxFilterAnzeigen = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem jCheckBoxFilterExtrafenster = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxDownloadAnzeigen = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxDownloadExtrafenster = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxAboAnzeigen = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxAboExtrafenster = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxMeldungenAnzeigen = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem jCheckBoxMeldungenExtrafenster = new JCheckBoxMenuItem();
    private MVTray tray = null;
    private MVBandwidthMonitor bandwidthMonitor = null;
    private MVDownloadInfo mvDownloadInfo = null;
    private SplashScreen splash = null;
    private Graphics2D splashScreenContext = null;
    private int splashScreenProgress = 0;
    private JCheckBoxMenuItem cbBandwidthDisplay;
    protected JCheckBoxMenuItem jCheckBoxMenuItemBeschreibung;
    private JCheckBoxMenuItem jCheckBoxMenuItemMediaDb;
    private JCheckBoxMenuItem jCheckBoxMenuItemToolBar;
    protected JCheckBoxMenuItem jCheckBoxMenuItemVideoplayer;
    private JMenu jMenuAnsicht;
    private JMenuBar jMenuBar;
    protected JMenu jMenuDatei;
    protected JMenu jMenuDownload;
    protected JMenu jMenuHilfe;
    private JMenuItem jMenuItemAboNeu;
    private JMenuItem jMenuItemAbosAendern;
    private JMenuItem jMenuItemAbosAusschalten;
    private JMenuItem jMenuItemAbosEinschalten;
    private JMenuItem jMenuItemAbosLoeschen;
    protected JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemAnleitung;
    protected JMenuItem jMenuItemBeenden;
    protected JMenuItem jMenuItemBlacklist;
    private JMenuItem jMenuItemDownloadAbspielen;
    private JMenuItem jMenuItemDownloadAendern;
    private JMenuItem jMenuItemDownloadAlleStoppen;
    private JMenuItem jMenuItemDownloadGesehen;
    private JMenuItem jMenuItemDownloadMediensammlung;
    private JMenuItem jMenuItemDownloadShutDown;
    private JMenuItem jMenuItemDownloadStartTime;
    private JMenuItem jMenuItemDownloadStarten;
    private JMenuItem jMenuItemDownloadStoppen;
    private JMenuItem jMenuItemDownloadUngesehen;
    private JMenuItem jMenuItemDownloadVorziehen;
    private JMenuItem jMenuItemDownloadWartendeStoppen;
    private JMenuItem jMenuItemDownloadsAktualisieren;
    private JMenuItem jMenuItemDownloadsAlleStarten;
    private JMenuItem jMenuItemDownloadsAufraeumen;
    private JMenuItem jMenuItemDownloadsLoeschen;
    private JMenuItem jMenuItemDownloadsZurueckstellen;
    protected JMenuItem jMenuItemEinstellungen;
    protected JMenuItem jMenuItemFilmAbspielen;
    protected JMenuItem jMenuItemFilmAufzeichnen;
    private JMenuItem jMenuItemFilmeGesehen;
    private JMenuItem jMenuItemFilmeMediensammlung;
    private JMenuItem jMenuItemFilmeUngesehen;
    private JMenuItem jMenuItemFilmlisteLaden;
    protected JMenuItem jMenuItemFilterLoeschen;
    private JMenuItem jMenuItemSchriftGr;
    private JMenuItem jMenuItemSchriftKl;
    private JMenuItem jMenuItemSchriftNormal;
    private JPanel jPanelInfo;
    private JPanel jPanelToolBar;
    protected JPopupMenu.Separator jSeparator2;
    protected JPopupMenu.Separator jSeparator4;
    private JTabbedPane jTabbedPane;

    private void createStatusBar() {
        this.statusBar = new MVStatusBar(this.daten);
        JScrollPane js = new JScrollPane();
        js.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        js.setHorizontalScrollBarPolicy(31);
        js.setVerticalScrollBarPolicy(21);
        js.setViewportView(this.statusBar.getComponent());
        this.jPanelInfo.add((Component)js, "Center");
    }

    public MVStatusBar getStatusBar() {
        return this.statusBar;
    }

    public String getFilterTextFromSearchField() {
        return this.mVToolBar.jTextFieldFilter.getText();
    }

    public void closeSplashScreen() {
        this.splashScreenContext = null;
    }

    public void updateSplashScreenText(String text) {
        if (this.splashScreenContext == null) {
            return;
        }
        int y = 430;
        int x = 120;
        int width = 300;
        int maxSteps = 11;
        ++this.splashScreenProgress;
        this.splashScreenContext.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.splashScreenContext.setComposite(AlphaComposite.Clear);
        this.splashScreenContext.fillRect(120, 420, 300, 40);
        this.splashScreenContext.setPaintMode();
        this.splashScreenContext.setFont(new Font("SansSerif", 1, 12));
        this.splashScreenContext.setColor(Color.WHITE);
        this.splashScreenContext.drawString(text, 120, 432);
        this.splashScreenContext.setColor(Color.BLUE);
        this.splashScreenContext.fillRect(120, 415, 300, 5);
        this.splashScreenContext.setColor(Color.GREEN);
        this.splashScreenContext.fillRect(120, 415, this.splashScreenProgress * 27, 5);
        this.splash.update();
    }

    private void initializeSplashScreen() {
        try {
            this.splash = SplashScreen.getSplashScreen();
            if (this.splash != null) {
                this.splashScreenContext = this.splash.createGraphics();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MediathekGui(String[] ar) {
        this.initializeSplashScreen();
        String pfad = "";
        this.initComponents();
        if (ar != null) {
            Log.systemMeldung("");
            Log.systemMeldung("==========================================");
            for (String s : ar) {
                Log.systemMeldung("Startparameter: " + s);
            }
            Log.systemMeldung("==========================================");
            Log.systemMeldung("");
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
        }
        this.setDefaultCloseOperation(0);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MediathekGui.class.getResource("/mediathek/res/MediathekView_k.gif")));
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke("F10"), "none");
        this.updateSplashScreenText("Anwendungsdaten laden...");
        Duration duration = new Duration(MediathekGui.class.getSimpleName());
        duration.ping("Start");
        this.daten = new Daten(pfad, this);
        duration.ping("Daten");
        Log.startMeldungen();
        this.createStatusBar();
        this.mVToolBar = new MVToolBar(this.daten);
        this.jPanelToolBar.setLayout(new BorderLayout());
        this.jPanelToolBar.add((Component)this.mVToolBar, "Center");
        this.daten.filmInfo = SystemInfo.isMacOSX() ? new MVFilmInformation(this, this.jTabbedPane, this.daten) : new MVFilmInformationLinux(this, this.jTabbedPane, this.daten);
        duration.ping("HUD");
        if (this.daten.allesLaden()) {
            this.updateSplashScreenText("GUI Initialisieren...");
        } else {
            Daten.mVReplaceList.init();
            new DialogStarteinstellungen(this, this.daten).setVisible(true);
            this.pack();
        }
        duration.ping("Alles laden");
        this.setOrgTitel();
        this.setLookAndFeel();
        duration.ping("LookAndFeel");
        this.init();
        duration.ping("init");
        this.setSize();
        duration.ping("setSize");
        this.dialogEinstellungen = new DialogEinstellungen(this, this.daten);
        this.daten.dialogMediaDB = new DialogMediaDB(this);
        this.daten.dialogMediaDB.setVis();
        new CheckUpdate(this, this.daten).checkProgUpdate();
        duration.ping("CheckUpdate");
        if (GuiFunktionen.getImportArtFilme() == 2 && Daten.listeFilme.isTooOld()) {
            Log.systemMeldung("Neue Filmliste laden");
            Daten.filmeLaden.importFilmliste("", true);
        }
        duration.ping("Filmliste laden");
        ListenerMediathekView.addListener(new ListenerMediathekView(20, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.setOrgTitel();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(21, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.setTitelAllesAktuell();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(22, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.setTitelUpdate();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(25, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.jCheckBoxMenuItemBeschreibung.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-beschreibung-anzeigen")));
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(37, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.jCheckBoxMenuItemMediaDb.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_Dialog-anzeigen")));
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(23, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.jCheckBoxFilterAnzeigen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
                MediathekGui.this.jCheckBoxFilterExtrafenster.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Filter")));
            }
        });
        JRootPane rootPane = this.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "mac-f");
        rootPane.getActionMap().put("mac-f", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.setFocusSuchfeld();
            }
        });
        this.setFocusSuchfeld();
        this.cbBandwidthDisplay.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Bandwidthmonitor-visible")));
        if (SystemInfo.isMacOSX()) {
            this.bandwidthMonitor = new MVBandwidthMonitor(this, this.cbBandwidthDisplay);
            this.bandwidthMonitor.toggleVisibility();
            this.cbBandwidthDisplay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MediathekGui.this.bandwidthMonitor.toggleVisibility();
                }
            });
        } else {
            this.mvDownloadInfo = new MVDownloadInfo(this, this.cbBandwidthDisplay);
            this.mvDownloadInfo.toggleVisibility();
            this.cbBandwidthDisplay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MediathekGui.this.mvDownloadInfo.toggleVisibility();
                }
            });
        }
        duration.ping("Gui steht!");
    }

    private void setFocusSuchfeld() {
        ListenerMediathekView.notify(26, MediathekGui.class.getName());
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"))) {
            this.mVToolBar.jTextFieldFilter.requestFocus();
            this.mVToolBar.jTextFieldFilter.setCaretPosition(0);
        }
    }

    private void setLookAndFeel() {
        try {
            String laf = Daten.mVConfig.get("System-look");
            if (laf.equals("") || laf.length() == 1) {
                if (MVFunctionSys.getOs() != MVFunctionSys.OperatingSystemType.LINUX) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } else {
                laf = Daten.mVConfig.get("System-look");
                UIManager.setLookAndFeel(laf);
            }
            SwingUtilities.updateComponentTreeUI(this);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
        }
        catch (Exception ignored) {
            Daten.mVConfig.add("System-look", UIManager.getSystemLookAndFeelClassName());
        }
    }

    public void setToolbar(String state) {
        this.mVToolBar.setToolbar(state);
        switch (state) {
            case "": {
                this.buttonAus();
                break;
            }
            case "Tab-Filme": {
                this.buttonAus();
                this.jMenuItemFilmAbspielen.setEnabled(true);
                this.jMenuItemFilmAufzeichnen.setEnabled(true);
                this.jMenuItemFilterLoeschen.setEnabled(true);
                this.jMenuItemBlacklist.setEnabled(true);
                this.jMenuItemFilmeGesehen.setEnabled(true);
                this.jMenuItemFilmeUngesehen.setEnabled(true);
                this.jMenuItemFilmeMediensammlung.setEnabled(true);
                break;
            }
            case "Tab-Downloads": {
                this.buttonAus();
                this.jMenuItemDownloadStarten.setEnabled(true);
                this.jMenuItemDownloadStoppen.setEnabled(true);
                this.jMenuItemDownloadAlleStoppen.setEnabled(true);
                this.jMenuItemDownloadWartendeStoppen.setEnabled(true);
                this.jMenuItemDownloadsAktualisieren.setEnabled(true);
                this.jMenuItemDownloadAbspielen.setEnabled(true);
                this.jMenuItemDownloadsAufraeumen.setEnabled(true);
                this.jMenuItemDownloadsLoeschen.setEnabled(true);
                this.jMenuItemDownloadsAlleStarten.setEnabled(true);
                this.jMenuItemDownloadStartTime.setEnabled(true);
                this.jMenuItemDownloadAendern.setEnabled(true);
                this.jMenuItemDownloadsZurueckstellen.setEnabled(true);
                this.jMenuItemDownloadVorziehen.setEnabled(true);
                this.jMenuItemDownloadGesehen.setEnabled(true);
                this.jMenuItemDownloadUngesehen.setEnabled(true);
                this.jMenuItemDownloadShutDown.setEnabled(true);
                this.jMenuItemDownloadMediensammlung.setEnabled(true);
                this.jSpinnerAnzahl.setEnabled(true);
                this.jLabelAnzahl.setEnabled(true);
                this.jSliderBandbreite.setEnabled(true);
                this.jLabelBandbreite.setEnabled(true);
                break;
            }
            case "Tab-Abos": {
                this.buttonAus();
                this.jMenuItemAbosEinschalten.setEnabled(true);
                this.jMenuItemAbosAusschalten.setEnabled(true);
                this.jMenuItemAbosLoeschen.setEnabled(true);
                this.jMenuItemAbosAendern.setEnabled(true);
                this.jMenuItemAboNeu.setEnabled(true);
            }
        }
    }

    public void videoplayerAnzeigen(boolean anz) {
        this.jCheckBoxMenuItemVideoplayer.setSelected(!anz);
    }

    private void setOrgTitel() {
        this.setTitle("MediathekView 11");
    }

    private void setTitelUpdate() {
        this.setTitle("Ein Programmupdate ist verf\u00fcgbar");
    }

    private void setTitelAllesAktuell() {
        this.setTitle("Programmversion ist aktuell");
    }

    private void buttonAus() {
        this.jMenuItemFilmAbspielen.setEnabled(false);
        this.jMenuItemFilmAufzeichnen.setEnabled(false);
        this.jMenuItemFilterLoeschen.setEnabled(false);
        this.jMenuItemBlacklist.setEnabled(false);
        this.jMenuItemFilmeGesehen.setEnabled(false);
        this.jMenuItemFilmeUngesehen.setEnabled(false);
        this.jMenuItemFilmeMediensammlung.setEnabled(false);
        this.jMenuItemDownloadsAktualisieren.setEnabled(false);
        this.jMenuItemDownloadAbspielen.setEnabled(false);
        this.jMenuItemDownloadsAufraeumen.setEnabled(false);
        this.jMenuItemDownloadsLoeschen.setEnabled(false);
        this.jMenuItemDownloadsAlleStarten.setEnabled(false);
        this.jMenuItemDownloadStartTime.setEnabled(false);
        this.jMenuItemDownloadStarten.setEnabled(false);
        this.jMenuItemDownloadStoppen.setEnabled(false);
        this.jMenuItemDownloadAlleStoppen.setEnabled(false);
        this.jMenuItemDownloadWartendeStoppen.setEnabled(false);
        this.jMenuItemDownloadAendern.setEnabled(false);
        this.jMenuItemDownloadsZurueckstellen.setEnabled(false);
        this.jMenuItemDownloadGesehen.setEnabled(false);
        this.jMenuItemDownloadUngesehen.setEnabled(false);
        this.jMenuItemDownloadVorziehen.setEnabled(false);
        this.jMenuItemDownloadShutDown.setEnabled(false);
        this.jMenuItemDownloadMediensammlung.setEnabled(false);
        this.jSpinnerAnzahl.setEnabled(false);
        this.jLabelAnzahl.setEnabled(false);
        this.jSliderBandbreite.setEnabled(false);
        this.jLabelBandbreite.setEnabled(false);
        this.jMenuItemAbosEinschalten.setEnabled(false);
        this.jMenuItemAbosAusschalten.setEnabled(false);
        this.jMenuItemAbosLoeschen.setEnabled(false);
        this.jMenuItemAbosAendern.setEnabled(false);
        this.jMenuItemAboNeu.setEnabled(false);
    }

    private void setSize() {
        if (Daten.startMaximized || Boolean.parseBoolean(Daten.mVConfig.get("programmfenster-maximieren"))) {
            this.setExtendedState(6);
        } else {
            GuiFunktionen.setSize("Groesse", this, null);
        }
        try {
            int divider = Integer.parseInt(Daten.mVConfig.get("breite-Meldungen"));
            if (divider > 0) {
                this.splitPane.setDividerLocation(divider);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void init() {
        this.jMenuItemFilmlisteLaden.setIcon(GetIcon.getProgramIcon("filmlisteLaden_16.png"));
        this.jMenuItemEinstellungen.setIcon(GetIcon.getProgramIcon("configure_16.png"));
        this.jMenuItemBeenden.setIcon(GetIcon.getProgramIcon("beenden_16.png"));
        this.jMenuItemFilmAbspielen.setIcon(GetIcon.getProgramIcon("film_start_16.png"));
        this.jMenuItemFilmAufzeichnen.setIcon(GetIcon.getProgramIcon("film_rec_16.png"));
        this.jMenuItemFilmeGesehen.setIcon(GetIcon.getProgramIcon("history_add_16.png"));
        this.jMenuItemFilmeUngesehen.setIcon(GetIcon.getProgramIcon("history_remove_16.png"));
        this.jMenuItemBlacklist.setIcon(GetIcon.getProgramIcon("blacklist_16.png"));
        this.jMenuItemFilterLoeschen.setIcon(GetIcon.getProgramIcon("clear_16.png"));
        this.jMenuItemDownloadsAlleStarten.setIcon(GetIcon.getProgramIcon("download_alleStarten_16.png"));
        this.jMenuItemDownloadStartTime.setIcon(GetIcon.getProgramIcon("download_alleStarten_16.png"));
        this.jMenuItemDownloadAlleStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
        this.jMenuItemDownloadWartendeStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
        this.jMenuItemDownloadStarten.setIcon(GetIcon.getProgramIcon("download_start_16.png"));
        this.jMenuItemDownloadStoppen.setIcon(GetIcon.getProgramIcon("download_stop_16.png"));
        this.jMenuItemDownloadVorziehen.setIcon(GetIcon.getProgramIcon("move_up_16.png"));
        this.jMenuItemDownloadsZurueckstellen.setIcon(GetIcon.getProgramIcon("undo_16.png"));
        this.jMenuItemDownloadsLoeschen.setIcon(GetIcon.getProgramIcon("download_del_16.png"));
        this.jMenuItemDownloadAendern.setIcon(GetIcon.getProgramIcon("configure_16.png"));
        this.jMenuItemDownloadsAktualisieren.setIcon(GetIcon.getProgramIcon("view-refresh_16.png"));
        this.jMenuItemDownloadAbspielen.setIcon(GetIcon.getProgramIcon("film_start_16.png"));
        this.jMenuItemDownloadsAufraeumen.setIcon(GetIcon.getProgramIcon("download_clear_16.png"));
        this.jMenuItemDownloadShutDown.setIcon(GetIcon.getProgramIcon("beenden_16.png"));
        this.jMenuItemDownloadGesehen.setIcon(GetIcon.getProgramIcon("history_add_16.png"));
        this.jMenuItemDownloadUngesehen.setIcon(GetIcon.getProgramIcon("history_remove_16.png"));
        this.jMenuItemAbosEinschalten.setIcon(GetIcon.getProgramIcon("ja_16.png"));
        this.jMenuItemAbosAusschalten.setIcon(GetIcon.getProgramIcon("nein_16.png"));
        this.jMenuItemAbosLoeschen.setIcon(GetIcon.getProgramIcon("del_16.png"));
        this.jMenuItemAbosAendern.setIcon(GetIcon.getProgramIcon("configure_16.png"));
        this.jMenuItemAboNeu.setIcon(GetIcon.getProgramIcon("add_16.png"));
        this.jMenuItemAnleitung.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.initTabs();
        this.initMenue();
        this.mVToolBar.loadVisible();
        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            public void start(MSListenerFilmeLadenEvent event) {
                MediathekGui.this.jMenuItemFilmlisteLaden.setEnabled(false);
            }

            public void progress(MSListenerFilmeLadenEvent event) {
            }

            public void fertig(MSListenerFilmeLadenEvent event) {
                MediathekGui.this.jMenuItemFilmlisteLaden.setEnabled(true);
                MediathekGui.this.daten.allesSpeichern();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MediathekGui.this.tray != null && !SystemInfo.isMacOSX() && Boolean.parseBoolean(Daten.mVConfig.get("Tray-anzeigen"))) {
                    ((MediathekGui)MediathekGui.this).daten.mediathekGui.setVisible(false);
                } else {
                    MediathekGui.this.beenden(false, false);
                }
            }
        });
        this.setTray();
    }

    public void setTray() {
        if (this.tray == null && Boolean.parseBoolean(Daten.mVConfig.get("Tray-anzeigen"))) {
            this.tray = new MVTray(this.daten).systemTray();
        } else if (this.tray != null && !Boolean.parseBoolean(Daten.mVConfig.get("Tray-anzeigen"))) {
            this.tray.beenden();
            this.tray = null;
        }
    }

    public void hideFrame(String state) {
        switch (state) {
            case "Tab-Downloads": {
                this.jCheckBoxDownloadAnzeigen.setSelected(false);
                Daten.mVConfig.add("Vis-Download", Boolean.toString(false));
                break;
            }
            case "Tab-Abos": {
                this.jCheckBoxAboAnzeigen.setSelected(false);
                Daten.mVConfig.add("Vis-Abo", Boolean.toString(false));
                break;
            }
            case "Meldungen": {
                this.jCheckBoxMeldungenAnzeigen.setSelected(false);
                Daten.mVConfig.add("Vis-Meldungen", Boolean.toString(false));
            }
        }
        this.initFrames();
    }

    private void initFrames() {
        int nr = 1;
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Download"))) {
            this.hide(0, this.daten.guiDownloads);
        } else if (Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Download"))) {
            this.setFrame(0, "Groesse-Download", this.daten.guiDownloads, "Tab-Downloads", "Downloads");
        } else {
            this.setTab(0, this.daten.guiDownloads, "Downloads", nr++);
        }
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Abo"))) {
            this.hide(1, this.daten.guiAbo);
        } else if (Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Abo"))) {
            this.setFrame(1, "Groesse-Abo", this.daten.guiAbo, "Tab-Abos", "Abos");
        } else {
            this.setTab(1, this.daten.guiAbo, "Abos", nr++);
        }
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Meldungen"))) {
            this.hide(2, this.panelMeldungen);
        } else if (Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Meldungen"))) {
            this.setFrame(2, "Groesse-Meldungen", this.panelMeldungen, "Meldungen", "Meldungen");
        } else {
            this.setTab(2, this.panelMeldungen, "Meldungen", nr);
        }
        this.mVToolBar.loadVisible();
        this.jTabbedPane.setSelectedIndex(0);
        this.daten.guiFilme.isShown();
    }

    private void hide(int nrFrameArr, PanelVorlage panelVorlage) {
        panelVorlage.solo = true;
        if (this.frames[nrFrameArr] != null) {
            this.frames[nrFrameArr].dispose();
            this.frames[nrFrameArr] = null;
        }
        if (this.tabContain(panelVorlage)) {
            this.jTabbedPane.remove(panelVorlage);
        }
    }

    private void setFrame(int nrFrameArr, String nrGroesse, PanelVorlage panelVorlage, String sparte, String titel) {
        panelVorlage.solo = true;
        if (this.frames[nrFrameArr] == null) {
            if (this.tabContain(panelVorlage)) {
                this.jTabbedPane.remove(panelVorlage);
            }
            this.frames[nrFrameArr] = new MVFrame(this.daten, panelVorlage, sparte, titel);
            this.frames[nrFrameArr].setSize(nrGroesse);
        }
        this.frames[nrFrameArr].setVisible(true);
    }

    private void setTab(int nrFrameArr, PanelVorlage panelVorlage, String titel, int nrTab) {
        if (this.frames[nrFrameArr] != null) {
            this.frames[nrFrameArr].dispose();
            this.frames[nrFrameArr] = null;
        }
        if (!this.tabContain(panelVorlage)) {
            this.jTabbedPane.add((Component)panelVorlage, nrTab);
            this.jTabbedPane.setTitleAt(nrTab, titel);
        }
        panelVorlage.solo = false;
    }

    private boolean tabContain(Component check) {
        Component[] c;
        for (Component co : c = this.jTabbedPane.getComponents()) {
            if (!co.equals(check)) continue;
            return true;
        }
        return false;
    }

    private void initTabs() {
        this.daten.guiDownloads = new GuiDownloads(this.daten, this.daten.mediathekGui);
        this.daten.guiAbo = new GuiAbo(this.daten, this.daten.mediathekGui);
        this.daten.guiFilme = new GuiFilme(this.daten, this.daten.mediathekGui);
        this.daten.guiFilme.init();
        this.jTabbedPane.addTab("Filme", this.daten.guiFilme);
        this.panelMeldungen = new PanelVorlage(this.daten, this){

            @Override
            public void isShown() {
                if (!this.solo) {
                    MediathekGui.this.setToolbar("");
                    MediathekGui.this.statusBar.setIndexForLeftDisplay(MVStatusBar.StatusbarIndex.FILME);
                }
            }
        };
        PanelMeldungen panelMeldungenSystem = new PanelMeldungen(this.daten, this.daten.mediathekGui, Log.textSystem, 17, "Systemmeldungen");
        PanelMeldungen panelMeldungenPlayer = new PanelMeldungen(this.daten, this.daten.mediathekGui, Log.textProgramm, 18, "Meldungen Hilfsprogramme");
        this.splitPane = new JSplitPane(1, panelMeldungenSystem, panelMeldungenPlayer);
        Log.panelMeldungenPlayer = panelMeldungenPlayer;
        Log.panelMeldungenSystem = panelMeldungenSystem;
        this.panelMeldungen.setLayout(new BorderLayout());
        this.panelMeldungen.add((Component)this.splitPane, "Center");
        if (Daten.debug) {
            Daten.guiDebug = new GuiDebug(this.daten);
            this.jTabbedPane.addTab("Debug", Daten.guiDebug);
        }
        this.initFrames();
    }

    protected void initSpinner() {
        if (Daten.mVConfig.get("maxDownload").equals("")) {
            this.jSpinnerAnzahl.setValue(1);
            Daten.mVConfig.add("maxDownload", "1");
        } else {
            this.jSpinnerAnzahl.setValue(Integer.parseInt(Daten.mVConfig.get("maxDownload")));
        }
    }

    private void setSlider() {
        MVDownloadInfo.setSliderBandwith(this.jSliderBandbreite, null);
        this.setSliderText();
    }

    private void setSliderText() {
        String s = MVDownloadInfo.getTextBandwith();
        s = " [" + s + "]: ";
        while (s.length() < 20) {
            s = s + " ";
        }
        this.jLabelBandbreite.setText("Bandbreite pro Download" + s);
    }

    protected void setupBandwidthMenuItem() {
        this.jPanelBandbreite.setLayout(new BorderLayout());
        this.jPanelBandbreite.setBorder(new EmptyBorder(3, 5, 3, 5));
        this.jPanelBandbreite.add((Component)this.jLabelBandbreite, "West");
        this.jPanelBandbreite.add((Component)this.jSliderBandbreite, "East");
        this.jLabelBandbreite.setIcon(GetIcon.getProgramIcon("bandwith_16.png"));
        this.jSliderBandbreite.setMinimum(5);
        this.jSliderBandbreite.setMaximum(100);
        this.setSlider();
        this.jSliderBandbreite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int bandbreiteKByte = MediathekGui.this.jSliderBandbreite.getValue() * 10;
                Daten.mVConfig.add("maxBandbreite", String.valueOf(bandbreiteKByte));
                MediathekGui.this.setSliderText();
                ListenerMediathekView.notify(28, MediathekGui.class.getSimpleName());
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(28, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.setSlider();
            }
        });
        this.jMenuDownload.add(this.jPanelBandbreite);
    }

    protected void setupMaximumNumberOfDownloadsMenuItem() {
        this.initSpinner();
        this.jMenuDownload.add(new JPopupMenu.Separator());
        this.jPanelAnzahl.setLayout(new BorderLayout());
        this.jPanelAnzahl.setBorder(new EmptyBorder(3, 5, 3, 5));
        this.jPanelAnzahl.add((Component)this.jLabelAnzahl, "West");
        this.jPanelAnzahl.add((Component)this.jSpinnerAnzahl, "East");
        this.jLabelAnzahl.setIcon(GetIcon.getProgramIcon("up_down_16.png"));
        this.jSpinnerAnzahl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Daten.mVConfig.add("maxDownload", String.valueOf(((Number)MediathekGui.this.jSpinnerAnzahl.getModel().getValue()).intValue()));
                ListenerMediathekView.notify(6, MediathekGui.class.getSimpleName());
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(6, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.initSpinner();
            }
        });
        this.jMenuDownload.add(this.jPanelAnzahl);
    }

    protected void initMenue() {
        this.setupMaximumNumberOfDownloadsMenuItem();
        this.setupBandwidthMenuItem();
        this.jMenuItemEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.dialogEinstellungen.setVisible(true);
            }
        });
        this.jMenuItemBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.beenden(false, false);
            }
        });
        this.jMenuItemFilmlisteLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.filmeLaden(MediathekGui.this.daten, false);
            }
        });
        this.jMenuItemFilmAbspielen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.guiFilmeFilmAbspielen();
            }
        });
        this.jMenuItemFilmAufzeichnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.guiFilmeFilmSpeichern();
            }
        });
        this.jMenuItemFilterLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.guiFilmeFilterLoeschen();
            }
        });
        this.jMenuItemBlacklist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLeer dialog = new DialogLeer((Frame)((MediathekGui)MediathekGui.this).daten.mediathekGui, true);
                dialog.init("Blacklist", new PanelBlacklist(MediathekGui.this.daten, ((MediathekGui)MediathekGui.this).daten.mediathekGui, PanelBlacklist.class.getName() + "_2"));
                dialog.setVisible(true);
            }
        });
        this.jMenuItemFilmeGesehen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.filmGesehen();
            }
        });
        this.jMenuItemFilmeUngesehen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.filmUngesehen();
            }
        });
        this.jMenuItemFilmeMediensammlung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiFilme.guiFilmMediensammlung();
            }
        });
        this.jMenuItemDownloadsAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.aktualisieren();
            }
        });
        this.jMenuItemDownloadAbspielen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.filmAbspielen();
            }
        });
        this.jMenuItemDownloadsAufraeumen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.aufraeumen();
            }
        });
        this.jMenuItemDownloadsLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.loeschen();
            }
        });
        this.jMenuItemDownloadsAlleStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.starten(true);
            }
        });
        this.jMenuItemDownloadStartTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.startAtTime();
            }
        });
        this.jMenuItemDownloadStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.starten(false);
            }
        });
        this.jMenuItemDownloadsZurueckstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.zurueckstellen();
            }
        });
        this.jMenuItemDownloadVorziehen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.vorziehen();
            }
        });
        this.jMenuItemDownloadAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.aendern();
            }
        });
        this.jMenuItemDownloadAlleStoppen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.stoppen(true);
            }
        });
        this.jMenuItemDownloadWartendeStoppen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.wartendeStoppen();
            }
        });
        this.jMenuItemDownloadStoppen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.stoppen(false);
            }
        });
        this.jMenuItemDownloadShutDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listeDownloads.nochNichtFertigeDownloads() > 0) {
                    MediathekGui.this.beenden(true, false);
                } else {
                    MVMessageDialog.showMessageDialog(((MediathekGui)MediathekGui.this).daten.mediathekGui, "Die Downloads m\u00fcssen zuerst gestartet werden.", "Keine laufenden Downloads!", 0);
                }
            }
        });
        this.jMenuItemDownloadGesehen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.filmGesehen();
            }
        });
        this.jMenuItemDownloadUngesehen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.filmUngesehen();
            }
        });
        this.jMenuItemDownloadMediensammlung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiDownloads.guiFilmMediensammlung();
            }
        });
        this.jMenuItemAbosEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiAbo.einAus(true);
            }
        });
        this.jMenuItemAbosAusschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiAbo.einAus(false);
            }
        });
        this.jMenuItemAbosLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiAbo.loeschen();
            }
        });
        this.jMenuItemAbosAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiAbo.aendern();
            }
        });
        this.jMenuItemAboNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).daten.guiAbo.neu();
            }
        });
        this.jCheckBoxMenuItemToolBar.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Toolbar-Alles-anzeigen")));
        this.mVToolBar.setVisible(this.jCheckBoxMenuItemToolBar.isSelected());
        this.jCheckBoxMenuItemToolBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Toolbar-Alles-anzeigen", Boolean.toString(MediathekGui.this.jCheckBoxMenuItemToolBar.isSelected()));
                MediathekGui.this.mVToolBar.setVisible(MediathekGui.this.jCheckBoxMenuItemToolBar.isSelected());
            }
        });
        this.jCheckBoxMenuItemVideoplayer.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-videoplayer-anzeigen")));
        this.jCheckBoxMenuItemVideoplayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("system-panel-videoplayer-anzeigen", String.valueOf(MediathekGui.this.jCheckBoxMenuItemVideoplayer.isSelected()));
                ListenerMediathekView.notify(3, MediathekGui.class.getSimpleName());
            }
        });
        this.jCheckBoxMenuItemBeschreibung.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-beschreibung-anzeigen")));
        this.jCheckBoxMenuItemBeschreibung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("system-panel-beschreibung-anzeigen", String.valueOf(MediathekGui.this.jCheckBoxMenuItemBeschreibung.isSelected()));
                ListenerMediathekView.notify(25, MediathekGui.class.getSimpleName());
            }
        });
        this.jCheckBoxMenuItemMediaDb.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Media_DB_Dialog-anzeigen")));
        this.jCheckBoxMenuItemMediaDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Media_DB_Dialog-anzeigen", String.valueOf(MediathekGui.this.jCheckBoxMenuItemMediaDb.isSelected()));
                ((MediathekGui)MediathekGui.this).daten.dialogMediaDB.setVis();
            }
        });
        this.jMenuItemSchriftGr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVFont.setFontSize(true);
            }
        });
        this.jMenuItemSchriftKl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVFont.setFontSize(false);
            }
        });
        this.jMenuItemSchriftNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVFont.resetFontSize();
            }
        });
        this.jMenuAnsicht.add(new JSeparator());
        this.jCheckBoxFilterAnzeigen.setText("Filter anzeigen");
        this.jCheckBoxFilterExtrafenster.setText("in Extrafenster");
        this.jCheckBoxFilterExtrafenster.setBorder(BorderFactory.createEmptyBorder(1, 10, 5, 1));
        this.jMenuAnsicht.add(this.jCheckBoxFilterAnzeigen);
        this.jMenuAnsicht.add(this.jCheckBoxFilterExtrafenster);
        this.jCheckBoxFilterAnzeigen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
        this.jCheckBoxFilterAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Vis-Filter", Boolean.toString(MediathekGui.this.jCheckBoxFilterAnzeigen.isSelected()));
                ListenerMediathekView.notify(23, MediathekGui.class.getSimpleName());
            }
        });
        this.jCheckBoxFilterExtrafenster.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Filter")));
        this.jCheckBoxFilterExtrafenster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Fenster-Filter", Boolean.toString(MediathekGui.this.jCheckBoxFilterExtrafenster.isSelected()));
                ListenerMediathekView.notify(23, MediathekGui.class.getSimpleName());
            }
        });
        this.jMenuAnsicht.add(new JSeparator());
        this.jCheckBoxDownloadAnzeigen.setText("Downloads anzeigen");
        this.jCheckBoxDownloadExtrafenster.setText("in Extrafenster");
        this.jCheckBoxDownloadExtrafenster.setBorder(BorderFactory.createEmptyBorder(1, 10, 5, 1));
        this.jMenuAnsicht.add(this.jCheckBoxDownloadAnzeigen);
        this.jMenuAnsicht.add(this.jCheckBoxDownloadExtrafenster);
        this.jCheckBoxDownloadAnzeigen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Download")));
        this.jCheckBoxDownloadAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Vis-Download", Boolean.toString(MediathekGui.this.jCheckBoxDownloadAnzeigen.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jCheckBoxDownloadExtrafenster.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Download")));
        this.jCheckBoxDownloadExtrafenster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Fenster-Download", Boolean.toString(MediathekGui.this.jCheckBoxDownloadExtrafenster.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jMenuAnsicht.add(new JSeparator());
        this.jCheckBoxAboAnzeigen.setText("Abos anzeigen");
        this.jCheckBoxAboExtrafenster.setText("in Extrafenster");
        this.jCheckBoxAboExtrafenster.setBorder(BorderFactory.createEmptyBorder(1, 10, 5, 1));
        this.jMenuAnsicht.add(this.jCheckBoxAboAnzeigen);
        this.jMenuAnsicht.add(this.jCheckBoxAboExtrafenster);
        this.jCheckBoxAboAnzeigen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Abo")));
        this.jCheckBoxAboAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Vis-Abo", Boolean.toString(MediathekGui.this.jCheckBoxAboAnzeigen.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jCheckBoxAboExtrafenster.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Abo")));
        this.jCheckBoxAboExtrafenster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Fenster-Abo", Boolean.toString(MediathekGui.this.jCheckBoxAboExtrafenster.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jMenuAnsicht.add(new JSeparator());
        this.jCheckBoxMeldungenAnzeigen.setText("Meldungen anzeigen");
        this.jCheckBoxMeldungenExtrafenster.setText("in Extrafenster");
        this.jCheckBoxMeldungenExtrafenster.setBorder(BorderFactory.createEmptyBorder(1, 10, 5, 1));
        this.jCheckBoxMeldungenAnzeigen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Meldungen")));
        this.jCheckBoxMeldungenAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Vis-Meldungen", Boolean.toString(MediathekGui.this.jCheckBoxMeldungenAnzeigen.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jCheckBoxMeldungenExtrafenster.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Meldungen")));
        this.jCheckBoxMeldungenExtrafenster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Fenster-Meldungen", Boolean.toString(MediathekGui.this.jCheckBoxMeldungenExtrafenster.isSelected()));
                MediathekGui.this.initFrames();
            }
        });
        this.jMenuAnsicht.add(this.jCheckBoxMeldungenAnzeigen);
        this.jMenuAnsicht.add(this.jCheckBoxMeldungenExtrafenster);
        this.jMenuItemAnleitung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVHelpDialog dialogOk = new MVHelpDialog(((MediathekGui)MediathekGui.this).daten.mediathekGui, true, MediathekGui.this.daten, "Hilfe zum Programm");
                dialogOk.setVisible(true);
            }
        });
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.showAboutDialog();
            }
        });
    }

    public void showDialogPreferences() {
        this.dialogEinstellungen.setVisible(true);
    }

    protected void showAboutDialog() {
        MVAboutDialog aboutDialog = new MVAboutDialog(this, (Boolean)SystemInfo.isMacOSX());
        aboutDialog.setVisible(true);
        aboutDialog.dispose();
    }

    public boolean beenden(boolean showOptionTerminate, boolean shutDown) {
        if (Daten.listeDownloads.nochNichtFertigeDownloads() > 0) {
            DialogBeenden dialogBeenden = new DialogBeenden(this);
            if (showOptionTerminate) {
                dialogBeenden.setComboWaitAndTerminate();
            }
            dialogBeenden.setModal(true);
            dialogBeenden.setVisible(true);
            if (!dialogBeenden.applicationCanTerminate()) {
                return false;
            }
            shutDown = dialogBeenden.isShutdownRequested();
        }
        this.daten.guiFilme.tabelleSpeichern();
        this.daten.guiDownloads.tabelleSpeichern();
        this.daten.guiAbo.tabelleSpeichern();
        this.daten.dialogMediaDB.tabelleSpeichern();
        if (Daten.listeDownloads != null) {
            for (DatenDownload download : Daten.listeDownloads) {
                Start s = download.start;
                if (s == null) continue;
                s.stoppen = true;
            }
        }
        if (this.getExtendedState() == 6) {
            Daten.mVConfig.add("programmfenster-maximieren", Boolean.TRUE.toString());
        } else {
            Daten.mVConfig.add("programmfenster-maximieren", Boolean.FALSE.toString());
        }
        GuiFunktionen.getSize("Groesse", this);
        GuiFunktionen.getSize("Groesse-Einstellungen", this.dialogEinstellungen);
        if (this.mvDownloadInfo != null) {
            GuiFunktionen.getSize("Groesse-Infodialog", this.mvDownloadInfo.getDialog());
            this.mvDownloadInfo.getDividerLocation();
        }
        GuiFunktionen.getSize("Media_DB_Dialog-Groesse", this.daten.dialogMediaDB);
        Daten.mVConfig.add("breite-Meldungen", String.valueOf(this.splitPane.getDividerLocation()));
        if (this.frames[0] != null) {
            GuiFunktionen.getSize("Groesse-Download", this.frames[0]);
        }
        if (this.frames[1] != null) {
            GuiFunktionen.getSize("Groesse-Abo", this.frames[1]);
        }
        if (this.frames[2] != null) {
            GuiFunktionen.getSize("Groesse-Meldungen", this.frames[2]);
        }
        GuiFunktionen.getSize("Groesse-Filter", this.daten.guiFilme.mVFilterFrame);
        this.daten.allesSpeichern();
        Log.printEndeMeldung();
        if (shutDown) {
            this.shutdownComputer();
        }
        this.dispose();
        System.exit(0);
        return false;
    }

    protected void shutdownComputer() {
        String strShutdownCommand = "";
        switch (MVFunctionSys.getOs()) {
            case LINUX: {
                strShutdownCommand = Daten.mVConfig.get("Programm-Linux-Shutdown");
                if (!strShutdownCommand.isEmpty()) break;
                strShutdownCommand = "shutdown -h now";
                Daten.mVConfig.add("Programm-Linux-Shutdown", "shutdown -h now");
                break;
            }
            case WIN32: 
            case WIN64: {
                strShutdownCommand = "shutdown.exe -s -t 0";
                break;
            }
            default: {
                Log.fehlerMeldung(465321789, "Shutdown unsupported operating system ...");
            }
        }
        if (!strShutdownCommand.isEmpty()) {
            try {
                Log.systemMeldung("Shutdown: " + strShutdownCommand);
                Runtime.getRuntime().exec(strShutdownCommand);
            }
            catch (IOException ex) {
                Log.fehlerMeldung(915263047, ex);
            }
        }
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.jPanelInfo = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelToolBar = new JPanel();
        this.jMenuBar = new JMenuBar();
        this.jMenuDatei = new JMenu();
        this.jMenuItemFilmlisteLaden = new JMenuItem();
        this.jMenuItemEinstellungen = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemBeenden = new JMenuItem();
        JMenu jMenuFilme = new JMenu();
        this.jMenuItemFilmAbspielen = new JMenuItem();
        this.jMenuItemFilmAufzeichnen = new JMenuItem();
        this.jMenuItemFilterLoeschen = new JMenuItem();
        this.jMenuItemBlacklist = new JMenuItem();
        JPopupMenu.Separator jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemFilmeGesehen = new JMenuItem();
        this.jMenuItemFilmeUngesehen = new JMenuItem();
        this.jMenuItemFilmeMediensammlung = new JMenuItem();
        this.jMenuDownload = new JMenu();
        this.jMenuItemDownloadsAlleStarten = new JMenuItem();
        this.jMenuItemDownloadStartTime = new JMenuItem();
        this.jMenuItemDownloadAlleStoppen = new JMenuItem();
        this.jMenuItemDownloadWartendeStoppen = new JMenuItem();
        this.jMenuItemDownloadsAktualisieren = new JMenuItem();
        this.jMenuItemDownloadsAufraeumen = new JMenuItem();
        JPopupMenu.Separator jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemDownloadStarten = new JMenuItem();
        this.jMenuItemDownloadStoppen = new JMenuItem();
        this.jMenuItemDownloadVorziehen = new JMenuItem();
        this.jMenuItemDownloadsZurueckstellen = new JMenuItem();
        this.jMenuItemDownloadsLoeschen = new JMenuItem();
        this.jMenuItemDownloadAendern = new JMenuItem();
        JPopupMenu.Separator jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemDownloadGesehen = new JMenuItem();
        this.jMenuItemDownloadUngesehen = new JMenuItem();
        this.jMenuItemDownloadMediensammlung = new JMenuItem();
        this.jMenuItemDownloadAbspielen = new JMenuItem();
        JPopupMenu.Separator jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemDownloadShutDown = new JMenuItem();
        JMenu jMenuAbos = new JMenu();
        this.jMenuItemAbosEinschalten = new JMenuItem();
        this.jMenuItemAbosAusschalten = new JMenuItem();
        this.jMenuItemAbosLoeschen = new JMenuItem();
        this.jMenuItemAbosAendern = new JMenuItem();
        this.jMenuItemAboNeu = new JMenuItem();
        this.jMenuAnsicht = new JMenu();
        this.jCheckBoxMenuItemToolBar = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemBeschreibung = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemVideoplayer = new JCheckBoxMenuItem();
        JMenu jMenu1 = new JMenu();
        this.jMenuItemSchriftGr = new JMenuItem();
        this.jMenuItemSchriftKl = new JMenuItem();
        this.jMenuItemSchriftNormal = new JMenuItem();
        JPopupMenu.Separator jSeparator5 = new JPopupMenu.Separator();
        this.cbBandwidthDisplay = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemMediaDb = new JCheckBoxMenuItem();
        this.jMenuHilfe = new JMenu();
        this.jMenuItemAnleitung = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        jPanel1.setLayout(new BorderLayout());
        this.jPanelInfo.setLayout(new BorderLayout());
        jPanel1.add((Component)this.jPanelInfo, "Last");
        this.jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1));
        jPanel1.add((Component)this.jTabbedPane, "Center");
        GroupLayout jPanelToolBarLayout = new GroupLayout(this.jPanelToolBar);
        this.jPanelToolBar.setLayout(jPanelToolBarLayout);
        jPanelToolBarLayout.setHorizontalGroup(jPanelToolBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelToolBarLayout.setVerticalGroup(jPanelToolBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jMenuDatei.setMnemonic('d');
        this.jMenuDatei.setText("Datei");
        this.jMenuItemFilmlisteLaden.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItemFilmlisteLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filmlisteLaden_16.png")));
        this.jMenuItemFilmlisteLaden.setText("neue Filmliste laden");
        this.jMenuDatei.add(this.jMenuItemFilmlisteLaden);
        this.jMenuItemEinstellungen.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.jMenuItemEinstellungen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/configure_16.png")));
        this.jMenuItemEinstellungen.setText("Einstellungen");
        this.jMenuItemEinstellungen.setToolTipText("allgemeine Programmeinstellungen");
        this.jMenuDatei.add(this.jMenuItemEinstellungen);
        this.jMenuDatei.add(this.jSeparator2);
        this.jMenuItemBeenden.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItemBeenden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/beenden_16.png")));
        this.jMenuItemBeenden.setText("Beenden");
        this.jMenuDatei.add(this.jMenuItemBeenden);
        this.jMenuBar.add(this.jMenuDatei);
        jMenuFilme.setMnemonic('f');
        jMenuFilme.setText("Filme");
        this.jMenuItemFilmAbspielen.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItemFilmAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/film_start_16.png")));
        this.jMenuItemFilmAbspielen.setText("Film abspielen");
        jMenuFilme.add(this.jMenuItemFilmAbspielen);
        this.jMenuItemFilmAufzeichnen.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuItemFilmAufzeichnen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/film_rec_16.png")));
        this.jMenuItemFilmAufzeichnen.setText("Film aufzeichnen");
        jMenuFilme.add(this.jMenuItemFilmAufzeichnen);
        this.jMenuItemFilterLoeschen.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItemFilterLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/clear_16.png")));
        this.jMenuItemFilterLoeschen.setText("Filter l\u00f6schen");
        jMenuFilme.add(this.jMenuItemFilterLoeschen);
        this.jMenuItemBlacklist.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.jMenuItemBlacklist.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/blacklist_16.png")));
        this.jMenuItemBlacklist.setText("Blacklist \u00f6ffnen");
        jMenuFilme.add(this.jMenuItemBlacklist);
        jMenuFilme.add(jSeparator6);
        this.jMenuItemFilmeGesehen.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.jMenuItemFilmeGesehen.setText("Filme als gesehen markieren");
        jMenuFilme.add(this.jMenuItemFilmeGesehen);
        this.jMenuItemFilmeUngesehen.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemFilmeUngesehen.setText("Filme als ungesehen markieren");
        jMenuFilme.add(this.jMenuItemFilmeUngesehen);
        this.jMenuItemFilmeMediensammlung.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItemFilmeMediensammlung.setText("Titel in der Mediensammlung suchen");
        jMenuFilme.add(this.jMenuItemFilmeMediensammlung);
        this.jMenuBar.add(jMenuFilme);
        this.jMenuDownload.setMnemonic('w');
        this.jMenuDownload.setText("Downloads");
        this.jMenuItemDownloadsAlleStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_alleStarten_16.png")));
        this.jMenuItemDownloadsAlleStarten.setText("alle Downloads starten");
        this.jMenuDownload.add(this.jMenuItemDownloadsAlleStarten);
        this.jMenuItemDownloadStartTime.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_alleStarten_16.png")));
        this.jMenuItemDownloadStartTime.setText("alle Downloads um xx:yy Uhr starten");
        this.jMenuDownload.add(this.jMenuItemDownloadStartTime);
        this.jMenuItemDownloadAlleStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_stop_16.png")));
        this.jMenuItemDownloadAlleStoppen.setText("alle stoppen");
        this.jMenuItemDownloadAlleStoppen.setToolTipText("alle Downloads stoppen");
        this.jMenuDownload.add(this.jMenuItemDownloadAlleStoppen);
        this.jMenuItemDownloadWartendeStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_stop_16.png")));
        this.jMenuItemDownloadWartendeStoppen.setText("wartende stoppen");
        this.jMenuItemDownloadWartendeStoppen.setToolTipText("wartende Downloads stoppen");
        this.jMenuDownload.add(this.jMenuItemDownloadWartendeStoppen);
        this.jMenuItemDownloadsAktualisieren.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.jMenuItemDownloadsAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/view-refresh_16.png")));
        this.jMenuItemDownloadsAktualisieren.setText("Liste der Downloads aktualisieren");
        this.jMenuDownload.add(this.jMenuItemDownloadsAktualisieren);
        this.jMenuItemDownloadsAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_clear_16.png")));
        this.jMenuItemDownloadsAufraeumen.setText("Liste der Downloads aufr\u00e4umen");
        this.jMenuDownload.add(this.jMenuItemDownloadsAufraeumen);
        this.jMenuDownload.add(jSeparator3);
        this.jMenuItemDownloadStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_start_16.png")));
        this.jMenuItemDownloadStarten.setText("Downloads starten");
        this.jMenuDownload.add(this.jMenuItemDownloadStarten);
        this.jMenuItemDownloadStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_stop_16.png")));
        this.jMenuItemDownloadStoppen.setText("Downloads stoppen");
        this.jMenuDownload.add(this.jMenuItemDownloadStoppen);
        this.jMenuItemDownloadVorziehen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/move_up_16.png")));
        this.jMenuItemDownloadVorziehen.setText("Downloads vorziehen");
        this.jMenuDownload.add(this.jMenuItemDownloadVorziehen);
        this.jMenuItemDownloadsZurueckstellen.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        this.jMenuItemDownloadsZurueckstellen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/undo_16.png")));
        this.jMenuItemDownloadsZurueckstellen.setText("Downloads zur\u00fcckstellen");
        this.jMenuDownload.add(this.jMenuItemDownloadsZurueckstellen);
        this.jMenuItemDownloadsLoeschen.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItemDownloadsLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/download_del_16.png")));
        this.jMenuItemDownloadsLoeschen.setText("Downloads aus Liste entfernen");
        this.jMenuDownload.add(this.jMenuItemDownloadsLoeschen);
        this.jMenuItemDownloadAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/configure_16.png")));
        this.jMenuItemDownloadAendern.setText("Download \u00e4ndern");
        this.jMenuDownload.add(this.jMenuItemDownloadAendern);
        this.jMenuDownload.add(jSeparator1);
        this.jMenuItemDownloadGesehen.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.jMenuItemDownloadGesehen.setText("Filme als gesehen markieren");
        this.jMenuDownload.add(this.jMenuItemDownloadGesehen);
        this.jMenuItemDownloadUngesehen.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemDownloadUngesehen.setText("Filme als ungesehen markieren");
        this.jMenuDownload.add(this.jMenuItemDownloadUngesehen);
        this.jMenuItemDownloadMediensammlung.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItemDownloadMediensammlung.setText("Titel in der Mediensammlung suchen");
        this.jMenuDownload.add(this.jMenuItemDownloadMediensammlung);
        this.jMenuItemDownloadAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/film_start_16.png")));
        this.jMenuItemDownloadAbspielen.setText("gespeicherten Film abspielen");
        this.jMenuDownload.add(this.jMenuItemDownloadAbspielen);
        this.jMenuDownload.add(jSeparator7);
        this.jMenuItemDownloadShutDown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/beenden_16.png")));
        this.jMenuItemDownloadShutDown.setText("Rechner nach Downloads herunterfahren");
        this.jMenuDownload.add(this.jMenuItemDownloadShutDown);
        this.jMenuBar.add(this.jMenuDownload);
        jMenuAbos.setMnemonic('b');
        jMenuAbos.setText("Abos");
        this.jMenuItemAbosEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/ja_16.png")));
        this.jMenuItemAbosEinschalten.setText("einschalten");
        jMenuAbos.add(this.jMenuItemAbosEinschalten);
        this.jMenuItemAbosAusschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/nein_16.png")));
        this.jMenuItemAbosAusschalten.setText("ausschalten");
        jMenuAbos.add(this.jMenuItemAbosAusschalten);
        this.jMenuItemAbosLoeschen.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItemAbosLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/del_16.png")));
        this.jMenuItemAbosLoeschen.setText("l\u00f6schen");
        jMenuAbos.add(this.jMenuItemAbosLoeschen);
        this.jMenuItemAbosAendern.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.jMenuItemAbosAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/configure_16.png")));
        this.jMenuItemAbosAendern.setText("\u00e4ndern");
        jMenuAbos.add(this.jMenuItemAbosAendern);
        this.jMenuItemAboNeu.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/add_16.png")));
        this.jMenuItemAboNeu.setText("neues Abo anlegen");
        jMenuAbos.add(this.jMenuItemAboNeu);
        this.jMenuBar.add(jMenuAbos);
        this.jMenuAnsicht.setMnemonic('a');
        this.jMenuAnsicht.setText("Ansicht");
        this.jCheckBoxMenuItemToolBar.setSelected(true);
        this.jCheckBoxMenuItemToolBar.setText("Toolbar");
        this.jMenuAnsicht.add(this.jCheckBoxMenuItemToolBar);
        this.jCheckBoxMenuItemBeschreibung.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        this.jCheckBoxMenuItemBeschreibung.setText("Beschreibung anzeigen");
        this.jMenuAnsicht.add(this.jCheckBoxMenuItemBeschreibung);
        this.jCheckBoxMenuItemVideoplayer.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.jCheckBoxMenuItemVideoplayer.setText("Buttons anzeigen");
        this.jMenuAnsicht.add(this.jCheckBoxMenuItemVideoplayer);
        jMenu1.setText("Schriftgr\u00f6\u00dfe");
        this.jMenuItemSchriftGr.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        this.jMenuItemSchriftGr.setText("vergr\u00f6\u00dfern");
        jMenu1.add(this.jMenuItemSchriftGr);
        this.jMenuItemSchriftKl.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        this.jMenuItemSchriftKl.setText("verkleinern");
        jMenu1.add(this.jMenuItemSchriftKl);
        this.jMenuItemSchriftNormal.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        this.jMenuItemSchriftNormal.setText("Normalgr\u00f6\u00dfe");
        jMenu1.add(this.jMenuItemSchriftNormal);
        this.jMenuAnsicht.add(jMenu1);
        this.jMenuAnsicht.add(jSeparator5);
        this.cbBandwidthDisplay.setText("Bandbreitennutzung");
        this.jMenuAnsicht.add(this.cbBandwidthDisplay);
        this.jCheckBoxMenuItemMediaDb.setText("Mediensammlung durchsuchen");
        this.jMenuAnsicht.add(this.jCheckBoxMenuItemMediaDb);
        this.jMenuBar.add(this.jMenuAnsicht);
        this.jMenuHilfe.setMnemonic('h');
        this.jMenuHilfe.setText("Hilfe");
        this.jMenuItemAnleitung.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jMenuItemAnleitung.setText("Hilfe und Fragen zum Programm");
        this.jMenuHilfe.add(this.jMenuItemAnleitung);
        this.jMenuHilfe.add(this.jSeparator4);
        this.jMenuItemAbout.setText("\u00dcber MediathekView");
        this.jMenuHilfe.add(this.jMenuItemAbout);
        this.jMenuBar.add(this.jMenuHilfe);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, 1083, Short.MAX_VALUE).addComponent(this.jPanelToolBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanelToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -1, 805, Short.MAX_VALUE)));
        this.pack();
    }
}

