/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.widgets.WindowUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SourceListCountBadgeRenderer {
    private CustomJLabel fLabel = new CustomJLabel();
    private boolean fSelected = false;
    private static Font BADGE_FONT = new Font("Helvetica", 1, 11);
    private final Color fSelectedColor;
    private final Color fActiveUnselectedColor;
    private final Color fInactiveUnselectedColor;
    private final Color fTextColor;

    public SourceListCountBadgeRenderer(Color selectedColor, Color activeUnselectedColor, Color inactiveUnselectedColor, Color textColor) {
        this.fLabel.setFont(BADGE_FONT);
        this.fLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.fSelectedColor = selectedColor;
        this.fActiveUnselectedColor = activeUnselectedColor;
        this.fInactiveUnselectedColor = inactiveUnselectedColor;
        this.fTextColor = textColor;
    }

    public void setState(int count, boolean selected) {
        this.fLabel.setText(String.valueOf(count));
        this.fSelected = selected;
    }

    public JComponent getComponent() {
        return this.fLabel;
    }

    private class CustomJLabel
    extends JLabel {
        private CustomJLabel() {
        }

        private Color getSelectedBadgeColor() {
            return SourceListCountBadgeRenderer.this.fSelectedColor;
        }

        private Color getUnselectedBadgeColor(boolean parentWindowHasFocus) {
            return parentWindowHasFocus ? SourceListCountBadgeRenderer.this.fActiveUnselectedColor : SourceListCountBadgeRenderer.this.fInactiveUnselectedColor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2d = image.createGraphics();
            g2d.setFont(this.getFont());
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(SourceListCountBadgeRenderer.this.fSelected ? this.getSelectedBadgeColor() : this.getUnselectedBadgeColor(WindowUtils.isParentWindowFocused(this)));
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getHeight(), this.getHeight());
            g2d.setColor(SourceListCountBadgeRenderer.this.fTextColor);
            g2d.setComposite(SourceListCountBadgeRenderer.this.fSelected ? AlphaComposite.DstOut : AlphaComposite.SrcOver);
            Font font = g2d.getFont();
            FontRenderContext renderContext = g2d.getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(renderContext, this.getText());
            Rectangle visualBounds = glyphVector.getVisualBounds().getBounds();
            int x = this.getWidth() / 2 - g2d.getFontMetrics().stringWidth(this.getText()) / 2;
            int y = this.getHeight() / 2 - visualBounds.height / 2 - visualBounds.y;
            g2d.drawString(this.getText(), x, y);
            g.drawImage(image, 0, 0, null);
            g2d.dispose();
        }
    }
}

