/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekSrf
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "SRF";
    private static final int MAX_SEITEN_THEMA = 5;
    private static final int MAX_FILME_KURZ = 6;

    public MediathekSrf(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 400, startPrio);
    }

    @Override
    public void addToList() {
        String MUSTER = "{\"id\":\"";
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.meldungStart();
        seite = this.getUrlIo.getUri_Utf(SENDERNAME, "http://www.srf.ch/play/tv/atozshows/list?layout=json", seite, "");
        int pos = 0;
        while ((pos = seite.indexOf("{\"id\":\"", pos)) != -1) {
            String id;
            int pos1 = seite.indexOf("\"", pos += "{\"id\":\"".length());
            if (pos1 == -1 || (id = seite.substring(pos, pos1)).length() < 10 || id.isEmpty()) continue;
            String thema = seite.extract("\"title\":\"", "\"", pos1);
            thema = StringEscapeUtils.unescapeJava(thema).trim();
            this.listeThemen.addUrl(new String[]{id, thema});
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private final MSStringBuilder film_website;
        MSStringBuilder overviewPageFilm;
        MSStringBuilder filmPage;
        MSStringBuilder m3u8Page;
        private static final String PATTERN_URL = "\"url\":\"";
        private static final String PATTERN_URL_END = "\"";
        private final ArrayList<String> urlList;
        private final ArrayList<String> filmList;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekSrf.this.wartenSeiteLaden);
            this.film_website = new MSStringBuilder(65536);
            this.overviewPageFilm = new MSStringBuilder(65536);
            this.filmPage = new MSStringBuilder(65536);
            this.m3u8Page = new MSStringBuilder(65536);
            this.urlList = new ArrayList();
            this.filmList = new ArrayList();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekSrf.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekSrf.this.listeThemen.getListeThemen()) != null) {
                    MediathekSrf.this.meldungProgress(link[0]);
                    this.addFilme(link[0], link[1]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(832002877, ex);
            }
            MediathekSrf.this.meldungThreadUndFertig();
        }

        private void addFilme(String urlThema, String thema) {
            try {
                String urlFeed = "http://www.srf.ch/play/tv/episodesfromshow?id=" + urlThema + "&pageNumber=1&layout=json";
                this.overviewPageFilm = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, urlFeed, this.overviewPageFilm, "");
                this.addFilmsFromPage(this.overviewPageFilm, thema, urlFeed);
                if (MSConfig.loadLongMax()) {
                    String url = urlFeed.substring(0, urlFeed.indexOf("&pageNumber=1"));
                    for (int i = 2; i <= 5 && this.overviewPageFilm.indexOf("pageNumber=" + i) != -1; ++i) {
                        this.overviewPageFilm = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, url + "&pageNumber=" + i + "&layout=json", this.overviewPageFilm, "");
                        this.addFilmsFromPage(this.overviewPageFilm, thema, urlThema);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(195926364, ex);
            }
        }

        private void addFilmsFromPage(MSStringBuilder page, String thema, String themePageUrl) {
            String BASE_URL_JSON = "http://il.srgssr.ch/integrationlayer/1.0/ue/srf/video/play/";
            String END_URL_JSON = ".jsonp";
            int count = 0;
            this.filmList.clear();
            page.extractList("{\"id\":\"", "?id=", PATTERN_URL_END, this.filmList);
            for (String id : this.filmList) {
                if (MSConfig.getStop() || !MSConfig.loadLongMax() && ++count > 6) break;
                String jsonMovieUrl = "http://il.srgssr.ch/integrationlayer/1.0/ue/srf/video/play/" + id + ".jsonp";
                this.addFilms(jsonMovieUrl, themePageUrl, thema);
            }
        }

        private void addFilms(String jsonMovieUrl, String themePageUrl, String theme) {
            String INDEX_1 = "index_1_av.m3u8";
            String INDEX_2 = "index_2_av.m3u8";
            String INDEX_3 = "index_3_av.m3u8";
            String INDEX_4 = "index_4_av.m3u8";
            String INDEX_5 = "index_5_av.m3u8";
            MediathekSrf.this.meldung(jsonMovieUrl);
            this.filmPage = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, jsonMovieUrl, this.filmPage, "");
            try {
                String url3u8;
                String date_str = "";
                String time = "";
                Date date = this.extractDateAndTime(this.filmPage);
                if (date != null) {
                    SimpleDateFormat dfDayMonthYear = new SimpleDateFormat("dd.MM.yyyy");
                    date_str = dfDayMonthYear.format(date);
                    dfDayMonthYear = new SimpleDateFormat("HH:mm:ss");
                    time = dfDayMonthYear.format(date);
                }
                long duration = this.extractDuration(this.filmPage);
                String description = this.filmPage.extract("\"description\": \"", PATTERN_URL_END);
                description = StringEscapeUtils.unescapeJava(description).trim();
                String title = this.filmPage.extract("AssetMetadatas", "\"title\": \"", PATTERN_URL_END);
                String urlThema = this.filmPage.extract("\"homepageUrl\": \"", PATTERN_URL_END);
                if (urlThema.isEmpty()) {
                    urlThema = "http://www.srf.ch/play/tv/sendungen";
                }
                String subtitle = this.filmPage.extract("\"TTMLUrl\": \"", PATTERN_URL_END);
                String urlHD = this.getUrl(this.filmPage, "\"@quality\": \"HD\"", "\"text\": \"");
                String url_normal = this.getUrl(this.filmPage, "\"@quality\": \"SD\"", "\"text\": \"");
                String url_small = "";
                String string = url3u8 = urlHD.endsWith("m3u8") ? urlHD : url_normal;
                if (url3u8.endsWith("m3u8")) {
                    this.m3u8Page = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, url3u8, this.m3u8Page, "");
                    if (this.m3u8Page.indexOf("index_5_av.m3u8") != -1) {
                        urlHD = this.getUrlFromM3u8(url3u8, "index_5_av.m3u8");
                    }
                    if (this.m3u8Page.indexOf("index_4_av.m3u8") != -1) {
                        url_normal = this.getUrlFromM3u8(url3u8, "index_4_av.m3u8");
                    } else if (this.m3u8Page.indexOf("index_3_av.m3u8") != -1) {
                        url_normal = this.getUrlFromM3u8(url3u8, "index_3_av.m3u8");
                    }
                    if (this.m3u8Page.indexOf("index_2_av.m3u8") != -1) {
                        url_small = this.getUrlFromM3u8(url3u8, "index_2_av.m3u8");
                    } else if (this.m3u8Page.indexOf("index_1_av.m3u8") != -1) {
                        url_small = this.getUrlFromM3u8(url3u8, "index_1_av.m3u8");
                    }
                }
                if (url_normal.isEmpty() && !url_small.isEmpty()) {
                    url_normal = url_small;
                    url_small = "";
                }
                if (url_normal.startsWith("https")) {
                    url_normal = url_normal.replaceFirst("https", "http");
                }
                if (url_small.startsWith("https")) {
                    url_small = url_small.replaceFirst("https", "http");
                }
                if (urlHD.startsWith("https")) {
                    urlHD = urlHD.replaceFirst("https", "http");
                }
                if (url_normal.isEmpty()) {
                    MSLog.fehlerMeldung(962101451, "Keine URL: " + jsonMovieUrl);
                } else {
                    DatenFilm film = new DatenFilm(MediathekSrf.SENDERNAME, theme, urlThema, title, url_normal, "", date_str, time, duration, description);
                    if (!urlHD.isEmpty()) {
                        film.addUrlHd(urlHD, "");
                    }
                    if (!url_small.isEmpty()) {
                        film.addUrlKlein(url_small, "");
                    }
                    if (!subtitle.isEmpty()) {
                        film.addUrlSubtitle(subtitle);
                    }
                    MediathekSrf.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(556320087, ex);
            }
        }

        private String getUrl(MSStringBuilder filmPage, String s1, String s2) {
            String url = "";
            String m3u8 = "";
            this.urlList.clear();
            filmPage.extractList(s1, s2, PATTERN_URL_END, this.urlList);
            for (String u : this.urlList) {
                if (!u.endsWith("m3u8") && !u.endsWith("mp4")) continue;
                if (u.endsWith("m3u8")) {
                    m3u8 = u;
                }
                if (!u.endsWith("mp4")) continue;
                url = u;
                break;
            }
            if (url.isEmpty()) {
                url = m3u8;
            }
            return url;
        }

        private String getUrlFromM3u8(String m3u8Url, String qualityIndex) {
            String CSMIL = "csmil/";
            String url = m3u8Url.substring(0, m3u8Url.indexOf("csmil/")) + "csmil/" + qualityIndex;
            return url;
        }

        private long extractDuration(MSStringBuilder page) {
            long duration = 0L;
            String PATTERN_DURATION = "\"duration\":";
            String d = page.extract("\"duration\":", ",").trim();
            try {
                if (!d.isEmpty()) {
                    duration = Long.parseLong(d);
                    duration /= 1000L;
                }
            }
            catch (NumberFormatException ex) {
                MSLog.fehlerMeldung(646490237, ex);
            }
            return duration;
        }

        private Date extractDateAndTime(MSStringBuilder page) {
            String PATTERN_DATE_TIME = "\"publishedDate\": \"";
            String PATTERN_END = PATTERN_URL_END;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            String date_str = page.extract("\"AssetMetadatas\"", "\"publishedDate\": \"", PATTERN_URL_END);
            Date date = null;
            try {
                date = formatter.parse(date_str);
            }
            catch (ParseException ex) {
                MSLog.fehlerMeldung(784512304, (Exception)ex, "Date_STR " + date_str);
            }
            return date;
        }
    }
}

