/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.MSRunSender;
import msearch.tool.GermanStringSorter;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;

public class MediathekReader
implements Runnable {
    public String sendername = "";
    int maxThreadLaufen = 4;
    int wartenSeiteLaden = 500;
    boolean updateOn = false;
    int threads = 0;
    int max = 0;
    int progress = 0;
    int startPrio = 1;
    LinkedListUrl listeThemen = new LinkedListUrl();
    MSGetUrl getUrlIo;
    MSFilmeSuchen mSearchFilmeSuchen;
    static final int TIMEOUT = 3000;

    public MediathekReader(MSFilmeSuchen mmSearchFilmeSuchen, String name, int ssenderMaxThread, int ssenderWartenSeiteLaden, int sstartPrio) {
        this.mSearchFilmeSuchen = mmSearchFilmeSuchen;
        this.wartenSeiteLaden = ssenderWartenSeiteLaden;
        this.getUrlIo = new MSGetUrl(ssenderWartenSeiteLaden);
        this.sendername = name;
        this.maxThreadLaufen = ssenderMaxThread;
        this.startPrio = sstartPrio;
    }

    public int getStartPrio() {
        return this.startPrio;
    }

    public int getThreads() {
        return this.maxThreadLaufen;
    }

    public long getWaitTime() {
        return this.wartenSeiteLaden;
    }

    public boolean checkNameSenderFilmliste(String name) {
        return this.sendername.equalsIgnoreCase(name);
    }

    public String getNameSender() {
        return this.sendername;
    }

    public void delSenderInAlterListe(String sender) {
        this.mSearchFilmeSuchen.listeFilmeAlt.deleteAllFilms(sender);
    }

    public void clear() {
    }

    @Override
    public void run() {
        try {
            this.updateOn = false;
            this.threads = 0;
            this.addToList();
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(397543600, ex, this.sendername);
        }
    }

    void addToList() {
    }

    void addFilm(DatenFilm film, boolean urlPruefen) {
        if (urlPruefen) {
            if (this.mSearchFilmeSuchen.listeFilmeNeu.getFilmByUrl(film.arr[12]) == null) {
                this.addFilm(film);
            }
        } else {
            this.addFilm(film);
        }
    }

    void addFilm(DatenFilm film) {
        if (film.arr[9].isEmpty()) {
            film.arr[9] = this.mSearchFilmeSuchen.listeFilmeAlt.getDateiGroesse(film.arr[12], film.arr[1]);
        }
        film.setUrlHistory();
        film.setGeo();
        if (this.mSearchFilmeSuchen.listeFilmeNeu.addFilmVomSender(film)) {
            MSFilmeSuchen.listeSenderLaufen.inc(film.arr[1], MSRunSender.Count.FILME);
        }
    }

    DatenFilm istInFilmListe(String sender, String thema, String titel) {
        return this.mSearchFilmeSuchen.listeFilmeNeu.istInFilmListe(sender, thema, titel);
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String[])it.next())[nr].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    boolean istInListe(LinkedList<String> liste, String str) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    synchronized void meldungStart() {
        this.max = 0;
        this.progress = 0;
        MSLog.systemMeldung("===============================================================");
        MSLog.systemMeldung("Starten[" + (MSConfig.loadLongMax() ? "alles" : "update") + "] " + this.sendername + ": " + new SimpleDateFormat("HH:mm:ss").format(new Date()));
        MSLog.systemMeldung("   maxThreadLaufen: " + this.maxThreadLaufen);
        MSLog.systemMeldung("   wartenSeiteLaden: " + this.wartenSeiteLaden);
        MSLog.systemMeldung("");
        MSRunSender runSender = this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, "");
        runSender.maxThreads = this.maxThreadLaufen;
        runSender.waitOnLoad = this.wartenSeiteLaden;
    }

    synchronized void meldungAddMax(int mmax) {
        this.max += mmax;
        this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, "");
    }

    synchronized void meldungAddThread() {
        ++this.threads;
        this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, "");
    }

    synchronized void meldungProgress(String text) {
        ++this.progress;
        this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, text);
    }

    synchronized void meldung(String text) {
        this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, text);
    }

    synchronized void meldungThreadUndFertig() {
        --this.threads;
        if (this.threads <= 0) {
            this.mSearchFilmeSuchen.meldenFertig(this.sendername);
        } else {
            this.mSearchFilmeSuchen.melden(this.sendername, this.max, this.progress, "");
        }
    }

    public static boolean urlExists(String url) {
        if (!url.toLowerCase().startsWith("http")) {
            return false;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestProperty("User-Agent", MSConfig.getUserAgent());
            conn.setReadTimeout(3000);
            conn.setConnectTimeout(3000);
            int retCode = conn.getResponseCode();
            if (retCode < 400) {
                return true;
            }
            if (retCode == 403) {
                return true;
            }
            conn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    String addsUrl(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == '/' ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == '/' ? ret + pfad2 : ret + '/' + pfad2;
        }
        if (ret.equals("")) {
            MSLog.fehlerMeldung(469872800, pfad1 + " " + pfad2);
        }
        return ret;
    }

    static void listeSort(LinkedList<String[]> liste, int stelle) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (liste != null) {
            for (int i = 1; i < liste.size(); ++i) {
                String str2;
                String str1;
                for (int k = i; k > 0 && sorter.compare(str1 = liste.get(k - 1)[stelle], str2 = liste.get(k)[stelle]) > 0; --k) {
                    liste.add(k - 1, liste.remove(k));
                }
            }
        }
    }

    static long extractDuration(String dauer) {
        long dauerInSeconds = 0L;
        if (dauer.isEmpty()) {
            return 0L;
        }
        try {
            if (dauer.contains("min")) {
                dauer = dauer.replace("min", "").trim();
                dauerInSeconds = Long.parseLong(dauer) * 60L;
            } else {
                String[] parts = dauer.split(":");
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    dauerInSeconds += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
        }
        catch (Exception ex) {
            return 0L;
        }
        return dauerInSeconds;
    }

    static long extractDurationSec(String dauer) {
        long dauerInSeconds = 0L;
        if (dauer.isEmpty()) {
            return 0L;
        }
        try {
            dauerInSeconds = Long.parseLong(dauer);
        }
        catch (Exception ex) {
            return 0L;
        }
        return dauerInSeconds;
    }

    class LinkedListUrl
    extends LinkedList<String[]> {
        LinkedListUrl() {
        }

        synchronized boolean addUrl(String[] e) {
            if (!MediathekReader.this.istInListe(this, e[0], 0)) {
                return super.add(e);
            }
            return false;
        }

        synchronized String[] getListeThemen() {
            return (String[])this.pollFirst();
        }
    }
}

